--******************************************************************************************
function public.Init()

  private.SHOW_ANIM_TIME = 1;
  private.HIDE_ANIM_TIME = 1;
  private.SET_ANIM_TIME = 2;
  private.SLIDE_ANIM_TIME = 0;
  private.pos_x = 1115;
  private.pos_x_new = 1115;

  public.iter = 0;
  public.state = 0;
  public.fly = 0;
  public.event_id = 0;
  private.mouseon = false;

  ObjAttach("int_bonus", "ng_interface");

end;
--******************************************************************************************
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.CheckScreen()

  if GetWideScreen() then
    private.pos_x_new = private.pos_x + 0.5 * ( GetAppWidth() - 1024 );
  else
    private.pos_x_new = private.pos_x;
  end;
  ObjSet("int_bonus", {pos_x = private.pos_x_new});

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.BonusMouseEnter()

  SetCursor(CURSOR_HAND);
  private.mouseon = true;
  --ObjSet( "tmr_bonus", { playing = false } );
  public.ShowAnim( "hide" );

end;
-----------------------------------------------------------------------------
function public.BonusMouseLeave()

  SetCursor(CURSOR_DEFAULT);
  private.mouseon = false;

  --if ( not ld.is_in_alicehome_now ) then

    local trg = interface_impl.HideBonus;
    ObjSet( "tmr_bonus", { time = private.SET_ANIM_TIME, playing = true, endtrig = trg } );

  --end;

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.ShowAnim( event_id )

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_achive_open_window"); 

  local tme_show = private.SHOW_ANIM_TIME;
  local pos_panel_x = ObjGet("spr_int_bonus").pos_x;

  ObjSet( "tmr_bonus", { playing = false } );
  ObjAnimate( "spr_int_bonus", 0, 0, 0, "",
  {
    0.0, 2, pos_panel_x,
    tme_show, 2, -176
  } );

end;

function public.HideAnim( event_id )

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_achive_close_window"); 

  local pos_panel_x = ObjGet("spr_int_bonus").pos_x;
  local tme = private.HIDE_ANIM_TIME;

  ng_global.show_bonus = 0;
  ObjAnimate( "spr_int_bonus", 0, 0, 0, "",
  {
    0, 2, pos_panel_x,  
    tme, 2, 0;
  } );

end;

function public.WaitAnim( event_id )

  --if ( not ld.is_in_alicehome_now ) then

    local tme = private.SET_ANIM_TIME;

    ObjSet( "tmr_bonus", { endtrig = interface_impl.HideBonus,
                           time = tme,
                           playing = true } );

  --end;

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.CountTotal( event_id )

  ObjStopAnimate("spr_int_bonus", 0);
  ObjSet( "tmr_bonus", { playing = false } );

  if public.state == 1 then
    if public.event_id == -1 then
      ng_global.bonus_count_current = ng_global.bonus_count_current + public.iter;
    elseif public.event_id == 1 then
      ng_global.bonus_count_current = ng_global.bonus_count_current - public.iter;
    end;
  end;

  public.iter = ng_global.bonus_count_counter - ng_global.bonus_count_current;

  ng_global.bonus_count_current = ng_global.bonus_count_counter;
  
  ng_global.bonus_count_counter = ng_global.bonus_count;

  if public.iter < 0 then
    public.event_id = -1;
    public.iter = math.abs( public.iter );
  elseif public.iter > 0 then
    public.event_id = 1;
  end;
  private.SLIDE_ANIM_TIME = 0;
  for i = 2, public.iter, 1 do
    private.SLIDE_ANIM_TIME = private.SLIDE_ANIM_TIME + ( 0.3 / i );
  end;
  private.SLIDE_ANIM_TIME = ( 0.3 + private.SLIDE_ANIM_TIME ) / public.iter;

  if public.state == 0 then
    public.state = 1; --счетчик крутится
    --ng_global.show_bonus = 2;
    private.DrawNewCount( event_id );
  end;

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function private.DrawNewCount( event_id )

  if public.iter <= 0 then
    --ng_global.show_bonus = 1;
    public.state = 0;
    if event_id == "increase" and
       (not private.mouseon) then
      public.WaitAnim( event_id );
    end;
  else
    public.iter = public.iter - 1;
    local trg = function () private.DrawNewCount( event_id ); end;
    private.DrawSwap( 3, trg );
  end;

end;

function private.DrawSwap( id_panel, trg )

  local name = "spr_int_bonus_count_"..id_panel;
  local name_1 = "spr_int_bonus_count_"..id_panel.."_1";

  trg = trg or "";
  if ( ( ( ObjGet(name).pos_y == -450 ) or ( ObjGet(name_1).pos_y == -450 ) ) and (public.event_id == 1) ) or 
     ( ( ( ObjGet(name).pos_y == 0 ) or ( ObjGet(name_1).pos_y == 0 ) ) and (public.event_id == -1) ) then
    private.DrawSwap( id_panel - 1 );
  end;
  if ( ( ObjGet(name).pos_y <= -500 ) and (public.event_id == 1) ) or ( ( ObjGet(name).pos_y >= 50 ) and (public.event_id == -1) ) then
    ObjSet(name, {pos_y = ObjGet(name_1).pos_y + public.event_id * 500})
  end;
  if ( ( ObjGet(name_1).pos_y <= -500 ) and (public.event_id == 1) ) or ( ( ObjGet(name_1).pos_y >= 50 ) and (public.event_id == -1) ) then
    ObjSet(name_1, {pos_y = ObjGet(name).pos_y + public.event_id * 500})
  end;
  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_achive_number"); 
  ObjAnimate(name, 1, 0, 0, "", {0, 0, ObjGet(name).pos_y,   private.SLIDE_ANIM_TIME, 0, ObjGet(name).pos_y - public.event_id * 50});
  ObjAnimate(name_1, 1, 0, 0, trg, {0, 0, ObjGet(name_1).pos_y,   private.SLIDE_ANIM_TIME, 0, ObjGet(name_1).pos_y - public.event_id * 50});

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.GotoSecretroom()

  --ng_global.secretroom_enter = ng_global.currentprogress;
  --ng_global.show_bonus = 0;

  int_complex_inv.Hide();

  cmn.GotoRoom("rm_alicehome", 1, true);

  if common_impl.is_in_map == 1 then
    int_map_impl.CloseLd();
  end;

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------