--******************************************************************************************
function public.Init()

  public.SHOW_ANIM_TIME = 1;
  public.HIDE_ANIM_TIME = 1;
  public.SET_ANIM_TIME = 4;
  private.pos_x = 0;
  private.pos_x_new = 0;
  private.mouseon = false;

  private.start_x = -182;
  private.delta_x = 358;

  public.stack_name = {}; --хранит имена ачивок

  public.stack_panel = {}; --хранит id панелей

  public.busy_panel = { 0, 0, 0 }; --хранит информацию о занятых панельках

  public.state_anim_end = 0; --переменная хранит в себе кол-во закрывающихся панелек, нужно чтобы отловить какую панель стоит задвигать

  public.close_id = 0;

  ObjAttach("int_achiev", "ng_interface");

end;
--******************************************************************************************
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.CheckScreen()

  if GetWideScreen() then
    private.pos_x_new = private.pos_x - 0.5 * ( GetAppWidth() - 1024 ) - 11;
  else
    private.pos_x_new = private.pos_x - 11;
--DbgTrace( "OK" );
  end;

  ObjSet("int_achiev", {pos_x = private.pos_x_new});

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
function public.EventAnimEnd( event_id, close_id )

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    --SendMessage( Command_Achiev_Show );
    interface_impl.ShowAchiev();

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    public.close_id = close_id;--string.sub( sender, -1 );
    --SendMessage( Command_Achiev_Hide );
    interface_impl.HideAchiev();

------------------------------------------------------------------------------------
  end;

end;
-----------------------------------------------------------------------------
function public.AchMouseEnter( panel_id )

  SetCursor(CURSOR_HAND);
  private.mouseon = true;
  public.ShowAnim( "hide", panel_id );

end;
-----------------------------------------------------------------------------
function public.AchMouseLeave( panel_id )

  SetCursor(CURSOR_DEFAULT);
  private.mouseon = false;
  local trg = function () public.EventAnimEnd( "hide", panel_id ); end;
  ObjSet( "tmr_ach_"..panel_id, { time = public.SET_ANIM_TIME, playing = true, endtrig = trg } );

end;
-----------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.ShowAnim( event_id, panel_id )

  local trg = function () public.EventAnimEnd( event_id, panel_id ); end;
  local tme_show = public.SHOW_ANIM_TIME;
  local tme = public.SET_ANIM_TIME;
  local pos_panel_x = ObjGet("spr_int_achiev_"..panel_id).pos_x;

  --DbgTrace("SHOW spr_int_achiev_"..panel_id.." event_id "..event_id);

  ObjAnimate( "spr_int_achiev_"..panel_id, 0, 0, 0, "", { 0.0, 2, pos_panel_x,   tme_show, 2, private.start_x + private.delta_x } );
  if (not private.mouseon) then
    ObjSet( "tmr_ach_"..panel_id, { time = public.SET_ANIM_TIME, playing = true, endtrig = trg } );
    --if not string.find(cmn.GetCurrentRoom(), "ho_") then
    --  PlaySfx("assets/levels/common/audio/aud_smallwindow",0,"",0); 
    --end;
  else
    ObjSet( "tmr_ach_"..panel_id, { playing = false } );  
  end;

end;

function public.HideAnim( event_id, panel_id )

  local tme = public.HIDE_ANIM_TIME;
  local trg = public.HideAchiev;
  local pos_panel_x = ObjGet("spr_int_achiev_"..panel_id).pos_x;--int.achiev.pos_x_new + 370;

  --DbgTrace("HIDE spr_int_achiev_"..panel_id);

  ObjAnimate( "spr_int_achiev_"..panel_id, 0, 0, 0, trg, { 0.0, 2, pos_panel_x,   tme, 2, pos_panel_x - private.delta_x } );

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------------------
function public.HideAchiev()

  public.state_anim_end = public.state_anim_end - 1;

  public.busy_panel[public.stack_panel[1]] = 0;

  table.remove(public.stack_panel, 1);

  if #public.stack_name ~= 0 then 

    local name = public.stack_name[1];

    public.SetAchiev( name );

  end;

end;

function public.SetAchiev( achiev_name )

  for i = 1, 3, 1 do

    if public.busy_panel[i] == 0 then

      public.stack_panel[#public.stack_panel + 1] = i; --записываем номер панельки, массив нужен чтобы отслеживать какую закрывать панель

      public.busy_panel[i] = 1;

      table.remove(public.stack_name, 1);

      if ( string.sub( achiev_name, 1, 7 ) == "ce_col_" ) then

        ObjSet( "txt_int_achiev_"..i, { text = achiev_name, pos_y = -25 } );
        ObjSet( "txt_int_achiev_"..i.."_text", { text = "ce_col_find", pos_y = 4 } );

        ObjSet( "spr_int_achiev_pic_"..i, {res = "assets/levels/common/collectable/"..achiev_name});
        ObjSet( "spr_int_achiev_"..i, { event_mdown = public.GotoCollectable } );

        ObjSet( "txt_int_achiev_"..i.."_collectable", { text = ( #ng_global.collectable + 1 ).."/"..#game.rm_collectable_state, alp = 1 } );

      else

        ObjSet( "txt_int_achiev_"..i, { text = "ce_ach_"..achiev_name, pos_y = -28 } );
        ObjSet( "txt_int_achiev_"..i.."_text", { text = "ce_ach_"..achiev_name.."_text", pos_y = 18 } );

        ObjSet( "spr_int_achiev_pic_"..i, {res = "assets/levels/common/achievement/"..achiev_name});
        ObjSet( "spr_int_achiev_"..i, { event_mdown = public.GotoAchievements } );

        ObjSet( "txt_int_achiev_"..i.."_collectable", { alp = 0 } );

      end;

      local event_id = "hide";
      local panel_id = i;

      public.ShowAnim( event_id, panel_id );

      break;

    end;

  end;

end;

--переход в комнату ачивок
function public.GotoAchievements()

  int_complex_inv.Hide();
  if common.IsInSubRoom() then
    common.CloseSubRoom();
  end;

  cmn.GotoRoom("rm_achievements", 1, true);

  if common_impl.is_in_map == 1 then
    int_map_impl.CloseLd();
  end;

end;

--переход в комнату collectable
function public.GotoCollectable()

--  interface.DeployInventoryHide();
--
--  cmn.GotoRoom("rm_collectable", 1, true);
--
--  if ld.is_in_map == 1 then
--    int.map.CloseLd();
--  end;

end;
---------------------------------------------------------------------------------------------------------------------------------------------------------------------