/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    int pixelBitStride;
    int bitMask;
    int pixelsPerDataElement;
    int dataElementSize;
    int dataBitOffset;
    int scanlineStride;

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, (n2 * n4 + DataBuffer.getDataTypeSize(n) - 1) / DataBuffer.getDataTypeSize(n), 0);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
    }

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, 1);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
        this.dataType = n;
        this.pixelBitStride = n4;
        this.scanlineStride = n5;
        this.dataBitOffset = n6;
        this.dataElementSize = DataBuffer.getDataTypeSize(n);
        this.pixelsPerDataElement = this.dataElementSize / n4;
        if (this.pixelsPerDataElement * n4 != this.dataElementSize) {
            throw new RasterFormatException("MultiPixelPackedSampleModel does not allow pixels to span data element boundaries");
        }
        this.bitMask = (1 << n4) - 1;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(this.dataType, n, n2, this.pixelBitStride);
        return multiPixelPackedSampleModel;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n + (this.dataBitOffset + 7) / 8);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n + (this.dataBitOffset + 15) / 16);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n + (this.dataBitOffset + 31) / 32);
            }
        }
        return dataBuffer;
    }

    public int getNumDataElements() {
        return 1;
    }

    public int[] getSampleSize() {
        int[] nArray = new int[]{this.pixelBitStride};
        return nArray;
    }

    public int getSampleSize(int n) {
        return this.pixelBitStride;
    }

    public int getOffset(int n, int n2) {
        int n3 = n2 * this.scanlineStride;
        return n3 += (n * this.pixelBitStride + this.dataBitOffset) / this.dataElementSize;
    }

    public int getBitOffset(int n) {
        return (n * this.pixelBitStride + this.dataBitOffset) % this.dataElementSize;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getTransferType() {
        if (this.pixelBitStride > 16) {
            return 3;
        }
        if (this.pixelBitStride > 8) {
            return 1;
        }
        return 0;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray != null && nArray.length != 1) {
            throw new RasterFormatException("MultiPixelPackedSampleModel has only one band.");
        }
        SampleModel sampleModel = this.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height || n3 != 0) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.dataBitOffset + n * this.pixelBitStride;
        int n5 = dataBuffer.getElem(n2 * this.scanlineStride + n4 / this.dataElementSize);
        int n6 = this.dataElementSize - (n4 & this.dataElementSize - 1) - this.pixelBitStride;
        return n5 >> n6 & this.bitMask;
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height || n3 != 0) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = this.dataBitOffset + n * this.pixelBitStride;
        int n6 = n2 * this.scanlineStride + n5 / this.dataElementSize;
        int n7 = this.dataElementSize - (n5 & this.dataElementSize - 1) - this.pixelBitStride;
        int n8 = dataBuffer.getElem(n6);
        n8 &= ~(this.bitMask << n7);
        dataBuffer.setElem(n6, n8 |= (n4 & this.bitMask) << n7);
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        int n4 = this.dataBitOffset + n * this.pixelBitStride;
        int n5 = this.dataElementSize - (n4 & this.dataElementSize - 1) - this.pixelBitStride;
        int n6 = 0;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                n6 = dataBuffer.getElem(n2 * this.scanlineStride + n4 / this.dataElementSize);
                byArray[0] = (byte)(n6 >> n5 & this.bitMask);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                n6 = dataBuffer.getElem(n2 * this.scanlineStride + n4 / this.dataElementSize);
                sArray[0] = (short)(n6 >> n5 & this.bitMask);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                n6 = dataBuffer.getElem(n2 * this.scanlineStride + n4 / this.dataElementSize);
                nArray[0] = n6 >> n5 & this.bitMask;
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n3 = this.dataBitOffset + n * this.pixelBitStride;
        int n4 = dataBuffer.getElem(n2 * this.scanlineStride + n3 / this.dataElementSize);
        int n5 = this.dataElementSize - (n3 & this.dataElementSize - 1) - this.pixelBitStride;
        nArray2[0] = n4 >> n5 & this.bitMask;
        return nArray2;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        int n4 = this.dataBitOffset + n * this.pixelBitStride;
        int n5 = n2 * this.scanlineStride + n4 / this.dataElementSize;
        int n6 = this.dataElementSize - (n4 & this.dataElementSize - 1) - this.pixelBitStride;
        int n7 = dataBuffer.getElem(n5);
        n7 &= ~(this.bitMask << n6);
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n5, n7 |= (byArray[0] & 0xFF & this.bitMask) << n6);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n5, n7 |= (sArray[0] & 0xFFFF & this.bitMask) << n6);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n5, n7 |= (nArray[0] & this.bitMask) << n6);
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.dataBitOffset + n * this.pixelBitStride;
        int n4 = n2 * this.scanlineStride + n3 / this.dataElementSize;
        int n5 = this.dataElementSize - (n3 & this.dataElementSize - 1) - this.pixelBitStride;
        int n6 = dataBuffer.getElem(n4);
        n6 &= ~(this.bitMask << n5);
        dataBuffer.setElem(n4, n6 |= (nArray[0] & this.bitMask) << n5);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)object;
        return this.width == multiPixelPackedSampleModel.width && this.height == multiPixelPackedSampleModel.height && this.numBands == multiPixelPackedSampleModel.numBands && this.dataType == multiPixelPackedSampleModel.dataType && this.pixelBitStride == multiPixelPackedSampleModel.pixelBitStride && this.bitMask == multiPixelPackedSampleModel.bitMask && this.pixelsPerDataElement == multiPixelPackedSampleModel.pixelsPerDataElement && this.dataElementSize == multiPixelPackedSampleModel.dataElementSize && this.dataBitOffset == multiPixelPackedSampleModel.dataBitOffset && this.scanlineStride == multiPixelPackedSampleModel.scanlineStride;
    }

    public int hashCode() {
        int n = 0;
        n = this.width;
        n <<= 8;
        n ^= this.height;
        n <<= 8;
        n ^= this.numBands;
        n <<= 8;
        n ^= this.dataType;
        n <<= 8;
        n ^= this.pixelBitStride;
        n <<= 8;
        n ^= this.bitMask;
        n <<= 8;
        n ^= this.pixelsPerDataElement;
        n <<= 8;
        n ^= this.dataElementSize;
        n <<= 8;
        n ^= this.dataBitOffset;
        n <<= 8;
        return n ^= this.scanlineStride;
    }
}

