/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.WinRegistryUtil;
import java.util.Iterator;
import java.util.List;

public class WinAppAssociationWriter
implements AppAssociationWriter {
    private void restoreAssociationRegistration(BackupAssociation backupAssociation, int n) {
        try {
            String string;
            String string2 = backupAssociation.getCurMimeType();
            String string3 = backupAssociation.getCurFileExt();
            if (!backupAssociation.getCurMimeTypeExisted()) {
                if (string2 != null) {
                    WinRegistryUtil.removeMimeType(string2, n);
                }
            } else {
                string = backupAssociation.getBackupFileExt();
                if (string != null) {
                    WinRegistryUtil.setFileExtByMimeType(string, string2, n);
                }
            }
            if (!backupAssociation.getCurFileExtExisted()) {
                if (string3 != null) {
                    WinRegistryUtil.removeFileExt(string3, n);
                }
            } else {
                String string4;
                string = backupAssociation.getBackupMimeType();
                if (string != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(string, string3, n);
                }
                if ((string4 = backupAssociation.getBackupClassID()) != null) {
                    WinRegistryUtil.setClassIDByFileExt(string3, string4, n);
                }
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    private void restoreAssociationUnregistration(BackupAssociation backupAssociation, int n) {
        try {
            String string;
            String string2 = backupAssociation.getCurMimeType();
            String string3 = backupAssociation.getCurFileExt();
            if (backupAssociation.getCurMimeTypeExisted()) {
                WinRegistryUtil.addMimeType(string2, n);
                string = backupAssociation.getBackupFileExt();
                if (string != null) {
                    WinRegistryUtil.setFileExtByMimeType(string, string2, n);
                }
            }
            if (backupAssociation.getCurFileExtExisted()) {
                WinRegistryUtil.addFileExt(string3, n);
                string = backupAssociation.getBackupMimeType();
                String string4 = backupAssociation.getBackupClassID();
                if (string != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(string, string3, n);
                }
                if (string4 != null) {
                    WinRegistryUtil.setClassIDByFileExt(string3, string4, n);
                }
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    public void checkAssociationValidForRegistration(Association association) throws IllegalArgumentException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (association.getActionList() != null) {
            bl = association.getActionList().isEmpty();
        }
        if (association.getFileExtList() != null) {
            bl2 = association.getFileExtList().isEmpty();
        }
        if (!(bl3 = bl2 && association.getMimeType() == null ? false : (association.getDescription() != null || association.getIconFileName() != null || !bl ? !bl2 : true))) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    public void checkAssociationValidForUnregistration(Association association) throws IllegalArgumentException {
        boolean bl = true;
        if (association.getFileExtList() != null) {
            bl = association.getFileExtList().isEmpty();
        }
        if (association.getMimeType() == null && bl) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    public boolean isAssociationExist(Association association, int n) {
        String string = null;
        String string2 = association.getMimeType();
        Iterator iterator = association.getFileExtList() != null ? association.getFileExtList().iterator() : null;
        if (iterator != null && iterator.hasNext()) {
            string = (String)iterator.next();
        }
        if (WinRegistryUtil.isWin2kUserDefinedFileExtExist(string)) {
            return true;
        }
        if (string2 == null && string == null) {
            return false;
        }
        if (string2 == null && string != null) {
            return WinRegistryUtil.isFileExtExist(string, n);
        }
        if (string2 != null && string == null) {
            return WinRegistryUtil.isMimeTypeExist(string2, n);
        }
        String string3 = WinRegistryUtil.getMimeTypeByFileExt(string, n);
        String string4 = WinRegistryUtil.getFileExtByMimeType(string2, n);
        return WinRegistryUtil.isMimeTypeExist(string2, n) && WinRegistryUtil.isFileExtExist(string, n) && (string == null ? string4 == null : string.equals(string4)) && (string2 == null ? string3 == null : string2.equals(string3));
    }

    public void registerAssociation(Association association, int n) throws RegisterFailedException {
        boolean bl = false;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("98") != -1 || string.indexOf("me") != -1 || string.indexOf("nt") != -1) {
            bl = true;
        }
        if (bl) {
            n = 2;
        }
        BackupAssociation backupAssociation = new BackupAssociation(association, n);
        String string2 = backupAssociation.getCurMimeType();
        String string3 = backupAssociation.getCurFileExt();
        String string4 = association.getDescription();
        String string5 = association.getIconFileName();
        List list = association.getActionList();
        boolean bl2 = backupAssociation.getCurMimeTypeExisted();
        boolean bl3 = backupAssociation.getCurFileExtExisted();
        try {
            if (string2 == null && string3 != null) {
                WinRegistryUtil.addFileExt(string3, n);
                if (string4 != null) {
                    WinRegistryUtil.setDescriptionByFileExt(string4, string3, n);
                }
                if (string5 != null) {
                    WinRegistryUtil.setIconFileNameByFileExt(string5, string3, n);
                }
                if (list != null) {
                    WinRegistryUtil.setActionListByFileExt(list, string3, n);
                }
                WinRegistryUtil.markGeneratorByFileExt(string3, n);
            } else if (string2 != null && string3 == null) {
                WinRegistryUtil.addMimeType(string2, n);
            } else if (string2 != null && string3 != null) {
                if (!bl2) {
                    WinRegistryUtil.addMimeType(string2, n);
                }
                if (!bl3) {
                    WinRegistryUtil.addFileExt(string3, n);
                }
                if (string4 != null) {
                    WinRegistryUtil.setDescriptionByFileExt(string4, string3, n);
                }
                if (string5 != null) {
                    WinRegistryUtil.setIconFileNameByFileExt(string5, string3, n);
                }
                if (list != null) {
                    WinRegistryUtil.setActionListByFileExt(list, string3, n);
                }
                WinRegistryUtil.markGeneratorByFileExt(string3, n);
                WinRegistryUtil.setMutualRef(string3, string2, n);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            this.restoreAssociationRegistration(backupAssociation, n);
            throw registerFailedException;
        }
    }

    public void unregisterAssociation(Association association, int n) throws RegisterFailedException {
        boolean bl = false;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("98") != -1 || string.indexOf("me") != -1 || string.indexOf("nt") != -1) {
            bl = true;
        }
        if (bl) {
            n = 2;
        }
        BackupAssociation backupAssociation = new BackupAssociation(association, n);
        String string2 = backupAssociation.getCurMimeType();
        String string3 = backupAssociation.getCurFileExt();
        boolean bl2 = backupAssociation.getCurMimeTypeExisted();
        boolean bl3 = backupAssociation.getCurFileExtExisted();
        try {
            if (bl2) {
                WinRegistryUtil.removeMimeType(string2, n);
            }
            if (bl3) {
                WinRegistryUtil.removeFileExt(string3, n);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            this.restoreAssociationUnregistration(backupAssociation, n);
            throw registerFailedException;
        }
    }

    protected class BackupAssociation {
        private String curMimeType;
        private String curFileExt;
        private boolean curMimeTypeExisted;
        private boolean curFileExtExisted;
        private String backupMimeType;
        private String backupClassID;
        private String backupFileExt;

        private BackupAssociation() {
        }

        protected BackupAssociation(Association association, int n) {
            this.curMimeType = association.getMimeType();
            Iterator iterator = null;
            List list = association.getFileExtList();
            if (list != null) {
                iterator = list.iterator();
            }
            if (iterator != null && iterator.hasNext()) {
                this.curFileExt = (String)iterator.next();
            }
            this.curMimeTypeExisted = this.curMimeType != null ? WinRegistryUtil.isMimeTypeExist(this.curMimeType, n) : false;
            this.curFileExtExisted = this.curFileExt != null ? WinRegistryUtil.isFileExtExist(this.curFileExt, n) : false;
            if (this.curMimeTypeExisted) {
                this.backupFileExt = WinRegistryUtil.getFileExtByMimeType(this.curMimeType, n);
            }
            if (this.curFileExtExisted) {
                this.backupClassID = WinRegistryUtil.getClassIDByFileExt(this.curFileExt, n);
                this.backupMimeType = WinRegistryUtil.getMimeTypeByFileExt(this.curFileExt, n);
            }
        }

        protected String getCurMimeType() {
            return this.curMimeType;
        }

        protected String getCurFileExt() {
            return this.curFileExt;
        }

        protected boolean getCurMimeTypeExisted() {
            return this.curMimeTypeExisted;
        }

        protected boolean getCurFileExtExisted() {
            return this.curFileExtExisted;
        }

        protected String getBackupMimeType() {
            return this.backupMimeType;
        }

        protected String getBackupClassID() {
            return this.backupClassID;
        }

        protected String getBackupFileExt() {
            return this.backupFileExt;
        }
    }
}

