REM ==============================================================
REM AltirisEnv=Predefine DS environment variables to default values
REM Version=6.9 SP4/7.1 SP1
REM User scripts in \prestart or \startup can redefine these
REM	ALTIRIS_PREBOOT       (will contain winpe)
REM	ALTIRIS_PREBOOT2      (will contain winpe<n>)
REM	ALTIRIS_PROCESSOR     (will contain the processor: x86, x64, ia64)
REM	ALTIRIS_BOOTDEVICE    (will contain one of: DISK, PXE, CDROM, DVD, HBW, EBW, FLOPPY, DIR, FILES)
REM	ALTIRIS_BOOTTYPE      (will contain one of: STANDALONE, NETWORK, AUTOMATION, INSTALLER, UNINSTALLER)
REM	ALTIRIS_BOOTDISK      (will contain drive letter of original boot disk (including ":") - defined later)
REM	ALTIRIS_SHARE         (will contain drive letter for Deployment share (including ":"))
REM	ALTIRIS_SHARE_        (will contain drive letter for Deployment share (excluding ":"))
REM	ALTIRIS_VER           (will contain version of DS that created boot image)
REM	ALTIRIS_BLD           (will contain version/build of DS that created boot image)
REM	ALTIRIS_BDC           (will contain version of BDC that created boot image)
REM	ALTIRIS_UNC           (will contain the UNC of the Deployment share)
REM	ALTIRIS_DS_SERVER     (will contain server name for Deployment share)
REM	ALTIRIS_DS_SHARE      (will contain share name for Deployment share)
REM	ALTIRIS_PXE_IP        (will contain the IP address of the PXE server)
REM	ALTIRIS_PXE_SERVER    (will contain the name of the PXE server)
REM	ALTIRIS_PXE_BOOTPATH  (will contain the path to the boot image on the PXE server)
REM	ALTIRIS_PXE_ID        (will contain the PXE menu option ID of the boot image)
REM	ALTIRIS_PXE_OID       (will contain the PXE menu option original ID of the boot image)
REM	ALTIRIS_PXE_RID       (will contain the PXE menu option redirected ID of the boot image)
REM	ALTIRIS_PXE_CLIENTMAC (will contain the local mac address that the client PXE booted on)
REM	ALTIRIS_PXE_INTERFACE (will contain the local nic interface name that the client PXE booted on)
REM
REM ALTIRIS_SHARE may be redefined later on if the default mapping fails
REM ALTIRIS_UNC may be redefined later on if the default mapping fails
REM ALTIRIS_DS_SERVER may be redefined later on if the default mapping fails
REM --------------------------------------------------------------
:AltirisEnv

rem Tokens using $$ symbols are defined in the boot configuration,
rem and are dynamically resolved when the boot image is created.

rem Main (published) items
set _BDC_mode=$$BDC_mode$$

set ALTIRIS_PREBOOT=$$OS_TYPE$$
call %__utl%:get-winpe __winpe
if defined __winpe set ALTIRIS_PREBOOT2=winpe%__winpe%
set ALTIRIS_PREBOOT_SUBTYPE=$$OS_subtype$$
set ALTIRIS_PREBOOT_SUBSUBTYPE=$$OS_subsubtype$$
set ALTIRIS_PREBOOT_UID=$$OS_UID$$
set ALTIRIS_PREBOOT_ID=$$OS_ID$$
set ALTIRIS_PREBOOT_NAME=$$OS_NAME$$
set ALTIRIS_PREBOOT_NAME2=$$OS_NAME2$$
call %__utl%:get-processor ALTIRIS_PROCESSOR $$Processor$$
set ALTIRIS_BOOTDEVICE=$$ALTIRIS_BOOTDEVICE$$
set ALTIRIS_BOOTTYPE=$$ALTIRIS_BOOTTYPE$$
set ALTIRIS_BOOTDISK=
set ALTIRIS_SHARE_=$$SHARE$$
set ALTIRIS_SHARE=%ALTIRIS_SHARE_%:
set ALTIRIS_VER=$$ALTIRIS_VER$$
set ALTIRIS_BLD=$$ALTIRIS_BLD$$
set ALTIRIS_BDC=$$ALTIRIS_BDC$$
set ALTIRIS_DS_SERVER=$$DS_SERVER_NAME$$
set ALTIRIS_DS_SHARE=$$DS_SERVER_SHARE$$
if defined ALTIRIS_DS_SERVER if defined ALTIRIS_DS_SHARE set ALTIRIS_UNC=\\%ALTIRIS_DS_SERVER%\%ALTIRIS_DS_SHARE%
rem For backward compatibility
set share=%ALTIRIS_SHARE%

rem PXE items
call %__utl%:fnd-pxe ALTIRIS_PXE_IP ALTIRIS_PXE_SERVER ALTIRIS_PXE_BOOTPATH ALTIRIS_PXE_ID ALTIRIS_PXE_OID ALTIRIS_PXE_RID ALTIRIS_PXE_CLIENTMAC ALTIRIS_PXE_INTERFACE
%__dbg% echo ALTIRIS_PXE_IP="%ALTIRIS_PXE_IP%"
%__dbg% echo ALTIRIS_PXE_ID="%ALTIRIS_PXE_ID%"
%__dbg% echo ALTIRIS_PXE_OID="%ALTIRIS_PXE_OID%"
%__dbg% echo ALTIRIS_PXE_RID="%ALTIRIS_PXE_RID%"
%__dbg% echo ALTIRIS_PXE_SERVER="%ALTIRIS_PXE_SERVER%"
%__dbg% echo ALTIRIS_PXE_BOOTPATH="%ALTIRIS_PXE_BOOTPATH%"
%__dbg% echo ALTIRIS_PXE_CLIENTMAC="%ALTIRIS_PXE_CLIENTMAC%"
%__dbg% echo ALTIRIS_PXE_INTERFACE="%ALTIRIS_PXE_INTERFACE%"


rem ---------------------------
rem Temporary variables
rem Enable this item to remove temporary variables after initial boot.
rem if not defined __dbg set __DeleteVars=true

set _work=$$work$$
call %__utl%:set-temp %_work%

rem Settings to control the actions that will be performed
set _RunRDeploy=$$RunRDeploy$$
set _RunAgent=$$RunAgent$$
set _RunAgentRemote=$$RunAgentRemote$$
set _ScreenLock=$$CfgScreenLock$$
set _StartNetwork=$$StartNetwork$$
set _PreloadDrivers=$$PreloadDrivers$$
set _UseFactoryWinpe=$$CfgWinPEModel$$
set _EnableFirewall=$$CfgEnableFirewall$$

rem Settings for the network settings
set _UseStaticIP=$$CfgUseStaticIP$$
set _ClientInterface=Local Area Connection
set _ClientIP=$$CfgClientIP$$
set _ClientSubnet=$$CfgClientSubnet$$
set _ClientGateway=$$CfgClientGateway$$
set _ClientWins1=$$CfgClientWins1$$
set _ClientWins2=$$CfgClientWins2$$
set _ClientDns1=$$CfgClientDns1$$
set _ClientDns2=$$CfgClientDns2$$

rem Settings for network authentication
rem Parameters are:
rem	2=ip check timeout (10)
rem	3=ip check timeout increment (5)
rem	4=ip check retries (20)
rem	5=ips to exclude(-) / include(+) (-169.254)
rem	6=authentication timeout (180)
set _AuthParams=10 5 20 "-169.254" 180
set _PwlFile=$$CfgPwlFileTitle$$
set _Computer=$$CfgComputerName$$
set _Domain=$$CfgDomainOrServer$$

rem Settings for the closest server mapping
rem Specify the proper drive letter and share name to map to
rem Parameters are:
rem	1=Drive letter to map to the closest server (G:)
rem	2=Share name to map to on the closest server (images)
rem set _GetSrv_Map=G: images
set _GetSrv_Pwl=%systemdrive%\%_PwlFile%
set _GetSrv_Lst=%ALTIRIS_SHARE%\server.lst
set _GetSrv_Dom=%_Domain%
set _GetSrv_Bat=%ALTIRIS_SHARE%\techsup\windows\%ALTIRIS_PROCESSOR%\getsrv\getsrv.bat

rem Settings for the Agent
set _Agent_cfgpath=$$cfgpath$$
set _Agent_Persistent=$$Persistent$$
set _Agent_AutoUpdate=$$AutoUpdate$$
set _Agent_Lock=$$CfgScreenLock_Param$$
set _Agent_Params=

rem Settings for stand-alone RDeploy
set _RDClient=$$Client$$
set _RDClientConfig=$$ClientConfig$$


rem Misc
set dircmd=/ogne/a


rem Load user environment variables
if exist "%systemdrive%\userenv.bat" (
rem  echo Loading user environment variables...
  call "%systemdrive%\userenv.bat" %*
)


rem goto :eof
