@echo off
rem ==============================================================
rem Start=Install WinPE 2 files from WAIK installer or installed WAIK
rem Version=6.9 SP1
rem 	Install WinPE 2 files from WAIK installer or installed WAIK files
rem	Required:
rem	[-src=]<src> = Directory path containing the WAIK installer MSI
rem	-path=<path> = Destination path to install the files to
rem	-x86, -x64, -ia64 = Processor type to install the files for
rem	Options:
rem	[-msi=<file>] = Name of MSI file (waik<processor>.msi)
rem	[-silent[=opt]] = Install silently (off)
rem	[-[no]ini] = Create version.ini file (on (ini))
rem	[-[no]del] = Delete excess files (off (nodel))
rem	[-[no]force] = Force install even if files are already present (off (noforce))
rem	[-[no]map] = Create a drive share and map a drive letter if needed (on (map))
rem	[-[no]temp] = Copy files to temp folder if needed (on (temp))
rem	[-[no]check] = Check to see if it is already installed (off (nocheck))
rem	Debug options:
rem	[-[no]debug] = Display debugging info (off (nodebug))
rem	[-[no]echo] = Turn on batch command echo (off (noecho))
rem	[-[no]test] = Just test the logic, don't run the commands (off (run))
rem	return = 0 if successful
rem --------------------------------------------------------------
setlocal EnableDelayedExpansion EnableExtensions
set version=6.9.0.15

@echo:
@echo [%date:~4% %time%] =================================================
@echo [%date:~4% %time%] Begin WAIKInst.bat V%version% (%~f0) ...
@echo [%date:~4% %time%] =================================================

if defined debug (echo on) else (echo off)
if defined echo (set dbg=) else (set dbg=rem)

@echo:  cmdline="%*"
%dbg% @pause

rem ------------------------
rem Default parameters
set error=
set __pth=%~0
set __bat=%~f0
set __quiet=/qr
rem set __quiet=/qb
rem set __quiet=/qb+
rem set __quiet=/qb-
rem set __quiet=/qn
rem set __quiet=/qn+
rem set __quiet=/qf
rem set __quiet=/passive

set __src=%src%
set __dst=%dst%
set __prc=%prc%
set __msi=%msi%
set __ini=%ini%
set __del=%del%
set __frc=%force%
set __map=%map%
set __tmp=%copy%
set __chk=%check%
set __tst=%test%
set __prm=%prm%

if not defined __ini set __ini=true
if not defined __del set __del=true
rem if not defined _map set __map=true
rem if not defined _tmp set __tmp=true


rem Parse parameters
set __qq=
if "%~1" == "" goto params-help
set /a __i=0
:params-loop
shift
set /a __i=__i+1
set __p=%~0
set __pp=%0
if "%__p%" == "" goto params-end
%dbg% if not "%__p%" == ""       @echo:   %__i% = "%__p%"
if /i "%__p%" == "-?"            set __qq=&             goto params-help
if /i "%__p%" == "/?"            set __qq=&             goto params-help
if /i "%__p%" == "-??"           set __qq=true&         goto params-help
if /i "%__p%" == "/??"           set __qq=true&         goto params-help
if /i "%__p:~0,6%" == "-path="   set __dst=%__p:~6%&    goto params-loop
if /i "%__p:~0,5%" == "-src="    set __src=%__p:~5%&    goto params-loop
if /i "%__p:~0,5%" == "-msi="    set __msi=%__p:~5%&    goto params-loop
if /i "%__p%" == "-x86"          set __prc=x86&         goto params-loop
if /i "%__p%" == "-x64"          set __prc=amd64&       goto params-loop
if /i "%__p%" == "-ia64"         set __prc=ia64&        goto params-loop
if /i "%__p%" == "-silent"       set __quiet=/qn&       goto params-loop
if /i "%__p%" == "-s"            set __quiet=/qn&       goto params-loop
if /i "%__p%" == "/s"            set __quiet=/qn&       goto params-loop
if /i "%__p:~0,8%" == "-silent=" set __quiet=%__p:~8%&  goto params-loop
if /i "%__p:~0,3%" == "-s="      set __quiet=%__p:~3%&  goto params-loop
if /i "%__p%" == "-ini"          set __ini=%__i%&       goto params-loop
if /i "%__p%" == "-noini"        set __ini=&            goto params-loop
if /i "%__p%" == "-del"          set __del=%__i%&       goto params-loop
if /i "%__p%" == "-nodel"        set __del=&            goto params-loop
if /i "%__p%" == "-force"        set __frc=%__i%&       goto params-loop
if /i "%__p%" == "-noforce"      set __frc=&            goto params-loop
if /i "%__p%" == "-map"          set __map=%__i%&       goto params-loop
if /i "%__p%" == "-nomap"        set __map=&            goto params-loop
if /i "%__p%" == "-temp"         set __tmp=%__i%&       goto params-loop
if /i "%__p%" == "-notemp"       set __tmp=&            goto params-loop
if /i "%__p%" == "-check"        set __chk=%__i%&       goto params-loop
if /i "%__p%" == "-nocheck"      set __chk=&            goto params-loop
if /i "%__p%" == "-test"         set __tst=@echo:#&     goto params-loop
if /i "%__p%" == "-notest"       set __tst=&            goto params-loop
if /i "%__p%" == "-debug"        set dbg=&              goto params-loop
if /i "%__p%" == "-nodebug"      set dbg=rem&           goto params-loop
if /i "%__p%" == "-echo"         echo on &              goto params-loop
if /i "%__p%" == "-noecho"       echo off &             goto params-loop
if "%__src%" == ""               set __src=%__p%&       goto params-loop
set __prm=%__prm%%__pp% 
goto params-loop

:params-help

if defined __ini (set __tini=[on (ini^)])      else (set __tini=[off (noini^)])
if defined __del (set __tdel=[on (del^)])      else (set __tdel=[off (nodel^)])
if defined __frc (set __tfrc=[on (force^)])    else (set __tfrc=[off (noforce^)])
if defined __map (set __tmap=[on (map^)])      else (set __tmap=[off (nomap^)])
if defined __tmp (set __ttmp=[on (temp^)])     else (set __ttmp=[off (notemp^)])
if defined __tst (set __ttst=[on (test^)])     else (set __ttst=[off (run^)])
if defined __chk (set __tchk=[on (check^)])    else (set __tchk=[off (nocheck^)])
if defined __ech (set __tech=[on (echo^)])     else (set __tech=[off (noecho^)])
if defined __dbg (set __tdbg=[off (nodebug^)]) else (set __tdbg=[on (debug^)])

echo: Install WinPE 2 files from WAIK installer or installed WAIK files (%version%)
echo: Syntax:
echo:	%~nx0 ^<src^> [^<msi^>] ^<dst^> ^<prc^> [^<options^>]
echo:
echo: ^<src^> = Source path to install WAIK files from:
echo:	[-src=]^<src^> = Directory path containing the WAIK installer MSI
echo:	[-msi=^<file^>] = Name of MSI file (waik^<prc^>.msi)
echo:
echo: ^<dst^> = Destination path to install WAIK files to:
echo:	-path=^<path^> = Destination path to install the files to
echo:
echo: ^<prc^> = Processor architechture to install files for:
echo:	-x86, -x64, -ia64 = Processor type to install the files for
echo:
echo: ^<options^> = Installation options:
echo:	-silent[=^<opt^>] = Install silently [off]
echo:	-[no]ini = Create version.ini file %__tini%
echo:	-[no]del = Delete unneeded files %__tdel%
echo:	-[no]force = Force install even if files already exist %__tfrc%
echo:	-[no]map = Create a share ^& map a drive letter if needed %__tmap%
echo:	-[no]temp = Copy files to temp folder if needed %__ttmp%
rem echo:	-[no]check = Check to see if it is already installed %__tchk%
if defined __qq (set __qq=) else (set __qq=rem)
%__qq% echo:
%__qq% echo: Debug options:
%__qq% echo:	-[no]debug = Display debugging info %__tdbg%
%__qq% echo:	-[no]echo = Turn on batch command echo %__tech%
%__qq% echo:	-[no]test = Just test the logic, don't run the commands %__ttst%
if not defined error set error=1
goto bad

:params-end
rem if "%__src:~0,1%" == ^""^" set __src=%__src:~1,-1%
rem if "%__dst:~0,1%" == ^""^" set __dst=%__dst:~1,-1%
rem if "%__msi:~0,1%" == ^""^" set __msi=%__msi:~1,-1%
rem if "%__prm:~-1%" == " "    set __prm=%__prm:~0,-1%

rem Remove trailing "\" from source and destination paths
if "%__src:~-1%" == "\"    set __src=%__src:~0,-1%
if "%__dst:~-1%" == "\"    set __dst=%__dst:~0,-1%

set __root=%__dst%\tools
set __tools=%__dst%\tools\%__prc%
set __peroot=%__dst%\tools\petools
set __petools=%__dst%\tools\petools\%__prc%
set __tmpdir=%__dst%\temp-%random%
set __frcsys=%__frc%
set __frcwim=%__frc%
set __frcxml=%__frc%

%dbg% @echo:  dbg="%dbg%"
%dbg% @echo:  src="%__src%"
%dbg% @echo:  dst="%__dst%"
%dbg% @echo:  prc="%__prc%"
%dbg% @echo:  msi="%__msi%"
%dbg% @echo:  ini="%__ini%"
%dbg% @echo:  del="%__del%"
%dbg% @echo:  frc="%__frc%"
%dbg% @echo:  map="%__map
%dbg% @echo:  tmp="%__tmp%"
%dbg% @echo:  chk="%__chk%"
%dbg% @echo:  quiet="%__quiet%"
%dbg% @echo:  tst="%__tst%"
%dbg% @echo:  prm="%__prm%"
%dbg% @echo:  root="%__root%"
%dbg% @echo:  tools="%__tools%"
%dbg% @echo:  peroot="%__peroot%"
%dbg% @echo:  petools="%__petools%"
%dbg% @pause


rem ------------------------
rem Check for required parameters
if "%__src%" == "" @echo: Missing MSI source directory & set error=1612& goto bad
if "%__dst%" == "" @echo: Missing destination directory & set error=2& goto bad
if "%__prc%" == "" @echo: Missing processor type & set error=1633& goto bad
if defined error goto params-help


rem ######################################################################


rem ------------------------
rem Begin the install
@echo:
@echo Installing WinPE 2 %__prc% pre-boot files from "%__src%" to "%__dst%"...


rem ------------------------
rem Install/Extract/Copy files
if "%__msi%" == "" if exist "%__src%\waik%__prc%.msi" set __msi=waik%__prc%.msi
if "%__msi%" == "" if exist "%__src%\waikx86.msi"     set __msi=waikx86.msi
if "%__msi%" == "" if exist "%__src%\waikx64.msi"     set __msi=waikx64.msi
if "%__msi%" == "" if exist "%__src%\waikia64.msi"    set __msi=waikia64.msi
%dbg% @echo:  msi="%__msi%"

rem Extract/Install files from msi
if exist "%__src%\%__msi%" (
  set __typ=MSI installer files
  call :doextract "%__src%\%__msi%" "%_dst%"

rem Copy pre-gathered files
) else if exist "%__src%\tools" (
  set __typ=Installed WAIK files
  call :docopy "%__src%\tools" "%_dst%"

rem Nothing found at src
) else (
  @echo: Cannot find expected files at "%__src%"
  set error=2
)

if defined error goto bad


rem ------------------------
rem Delete unneeded files
if defined __del call :dodelete
if defined error goto bad


rem ------------------------
rem Create version.ini file
if defined __ini call :doversion
if defined error goto bad


rem ------------------------
rem Done
:done
@echo:
@echo Done.
set error=0


rem ------------------------
rem An error occurred
:bad
for /f "usebackq delims== tokens=1" %%v in (`set __`) do set %%v=
if not defined error set error=1619
%dbg% @echo ExitCode=%error%
endlocal & set error=%error%
@echo:
@echo [%date:~4% %time%] =================================================
@echo [%date:~4% %time%] End WAIKInst.bat
@echo [%date:~4% %time%] =================================================
@echo:
exit /b %error%


rem ######################################################################


rem ================================================
rem Extract/Install files
rem ------------------------------------------------
:doextract
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Extracting files from "%__src%\%__msi%" to "%__dst%"...

rem Backup wim files
call :backupwims

rem Extract files from the msi
call :extractmsi

rem Restore wim files
call :restorewims

rem Clean up invalid wim files
if not defined error call :cleanupwims

rem Extract the wim files
if not defined error call :extractwim

rem Extract the xml files
if not defined error call :extractxml

rem Clean up installed files
rem if not defined error call :cleanup

rem set error=%errorlevel%
if "%error%" == "0" set error=
if defined error @echo: Error %error% extracting files from "%__src%\%__msi%" to "%__dst%"
endlocal & set error=%error%
goto :eof



rem ================================================
rem Extract from msi
rem ------------------------------------------------
:extractmsi
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Extracting WinPE files from "%__src%\%__msi%" to "%__dst%"...

rem See if files have already been installed and should be installed or not
set __sysinst=& if exist "%__tools%\wimfltr.sys" set __sysinst=true
set __instsys=
if defined __sysinst (
  if not defined __frcsys (
    set __instsys=
  ) else (
    set __instsys=true
  )
) else (
  set __instsys=true
)

if defined __sysinst if not defined __instsys @echo: WinPE files have already been extracted - not reextracting files
if defined __sysinst if     defined __instsys @echo: WinPE files have already been extracted - reextracting files...
rem if not defined __sysinst                      %dbg% @echo: Do clean install of WinPE files...
if not defined __sysinst                      @echo: Do clean install of WinPE files...

if "%__map%" gtr "%__tmp%" (set ___map=__2&set ___tmp=__1) else (set ___map=__1& set ___tmp=__2)
if defined __map (set %___map%=mapdrive) else (set %___map%=)
if defined __tmp (set %___tmp%=copytemp) else (set %___tmp%=)

if defined __instsys                     if defined __1 call :%__1% "%__src%" ___1
if defined __instsys if not defined ___1 if defined __2 call :%__2% "%__src%" ___2
rem if defined __instsys                      if defined __map call :mapdrive "%__src%" ___1
rem if defined __instsys if not defined __map if defined __tmp call :copytemp "%__src%" ___2

dir . 1>nul 2>nul
set __cmd=call msiexec /a "%__src%\%__msi%" targetdir="%__dst%" %__quiet% %__prm%
if defined __instsys @echo: %__cmd%
if defined __instsys if not defined __tst %__cmd%
set error=%errorlevel%

if defined __instsys if defined __map call :unmapdrive "%__src%"
if defined __instsys if defined __tmp call :deletetemp "%__src%"

rem set error=%errorlevel%
if "%error%" == "0" set error=
if defined error @echo: Error %error% extracting WinPE files from "%__src%\%__msi%" to "%__dst%"
endlocal & set error=%error%& if not "%__instsys%" == "" set __frcwim=
goto :eof



rem ================================================
rem Extract wim file
rem ------------------------------------------------
:extractwim
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Extracting WIM file from "%__src%\winpe.cab" to "%__petools%\winpe.wim"...

rem See if files have already been installed and should be installed or not
set __wiminst=& if exist "%__petools%\winpe.wim" set __wiminst=true
set __instwim=
if defined __wiminst (
  if not defined __frcwim (
    set __instwim=
  ) else (
    set __instwim=true
  )
) else (
  set __instwim=true
)

if defined __wiminst if not defined __instwim @echo: WIM file has already been extracted - not reextracting file
if defined __wiminst if     defined __instwim @echo: WIM file has already been extracted - reextracting file...
rem if not defined __wiminst                      %dbg% @echo: Do clean extract of WIM file...
if not defined __wiminst                      @echo: Do clean extract of WIM file...

set __bcdedit=bdcutl.bin
set __wim=
if /i "%__prc%" == "x86"   set __wim=f1_winpe.wim
if /i "%__prc%" == "amd64" set __wim=f3_winpe.wim
if /i "%__prc%" == "ia64"  set __wim=f2_winpe.wim

dir . 1>nul 2>nul
set __cmd=call expand "%__src%\winpe.cab" -f:%__wim% "%__petools%"
if defined __instwim if defined __wim @echo: %__cmd%
if defined __instwim if defined __wim if not defined __tst %__cmd%
rem if defined __instwim if defined __wim if not defined __tst for /f "delims=| usebackq" %%i in (`%__cmd%`) do echo.    %%i
set error=%errorlevel%

if defined __instwim if defined __wim if exist "%__petools%\winpe.wim" del /q /f "%__petools%\winpe.wim"
if exist "%__petools%\%__wim%" rename "%__petools%\%__wim%" "winpe.wim"

if "%error%" == "0" set error=
if defined error @echo: Error %error% extracting WIM file from "%__src%\winpe.cab" to "%__petools%\winpe.wim"
endlocal & set error=%error%
goto :eof



rem ================================================
rem Extract xml files
rem ------------------------------------------------
:extractxml
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Extracting XML files from "%__src%\msxml*x86.msi" to "%__dst%"...

rem See if files have already been installed and should be installed or not
set __xmlinst=& if exist "%__peroot%\msxml*.dll" set __xmlinst=true
rem if exist "%__peroot%\msxml*.dll" goto extract-done
set __instxml=
if defined __xmlinst (
  if not defined __frcxml (
    set __instxml=
  ) else (
    set __instxml=true
  )
) else (
  set __instxml=true
)

if defined __xmlinst if not defined __instxml @echo: XML files have already been extracted - not reextracting files
if defined __xmlinst if     defined __instxml @echo: XML files have already been extracted - reextracting files...
rem if not defined __xmlinst                      %dbg% @echo: Do clean extract of XML files...
if not defined __xmlinst                      @echo: Do clean extract of XML files...

set __xml=
for /f "usebackq" %%a in (`dir/b "%__src%\msxml*x86.msi"`) do set __xml=%%a
rem if not defined __xml goto extract-done

dir . 1>nul 2>nul
set __cmd=call msiexec /a "%__src%\%__xml%" targetdir="%__tmpdir%\xml" /qn
if defined __instxml if defined __xml @echo: %__cmd%
if defined __instxml if defined __xml if not defined __tst %__cmd%
rem if defined __instxml if defined __xml if not defined __tst for /f "delims=| usebackq" %%i in (`%__cmd%`) do echo.    %%i
set error=%errorlevel%

if exist "%__tmpdir%\xml\system\msxml*.dll" move /y "%__tmpdir%\xml\system\msxml*.dll" "%__peroot%"
if exist "%__tmpdir%\xml" rd /s /q "%__tmpdir%\xml"
rem set error=%errorlevel%

rem :extract-done
if "%error%" == "0" set error=
if defined error @echo: Error %error% extracting XML files from "%__src%\msxml*x86.msi" to "%__dst%"
endlocal & set error=%error%
goto :eof



rem ================================================
rem Copy pre-gathered files
rem ------------------------------------------------
:docopy
set __msi=
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Copying files from "%__src%" to "%__dst%"...

if defined __sysinst if not defined __instsys @echo: WinPE files have already been copied - not recopying files
if defined __sysinst if     defined __instsys @echo: WinPE files have already been copied - recopying files...
rem if not defined __sysinst                      %dbg% @echo: Do clean copy of WinPE files...
if not defined __sysinst                      @echo: Do clean copy of WinPE files...

dir . 1>nul 2>nul
if /i not "%__dst%" == "%__src%" (
  set __cmd=xcopy "%__src%\tools" "%__dst%" /s /e /c /i /h /r /k /y %__prm%
  rem /f /q /o /x
  if defined __instsys @echo: %__cmd%
  if defined __instsys if not defined __tst %__cmd%
rem  if defined __instsys if not defined __tst for /f "delims=| usebackq" %%i in (`%__cmd%`) do echo.    %%i
) else (
  @echo: Source "%__src%" and destination "%__dst%" are the same - not copying files
)
set error=%errorlevel%

if "%error%" == "0" set error=
if defined error @echo: Error %error% copying WinPE files from "%__src%" to "%__dst%"
endlocal & set error=%error%
goto :eof



rem ================================================
rem Backup .WIM files
rem ------------------------------------------------
:backupwims
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Backup .WIM files in "%__peroot%"...

if exist "%__peroot%\x86\winpe.wim"   if exist "%__peroot%\x86\winpe.old"   del /f /q "%__peroot%\x86\winpe.old"
if exist "%__peroot%\amd64\winpe.wim" if exist "%__peroot%\amd64\winpe.old" del /f /q "%__peroot%\amd64\winpe.old"
if exist "%__peroot%\ia64\winpe.wim"  if exist "%__peroot%\ia64\winpe.old"  del /f /q "%__peroot%\ia64\winpe.old"

if exist "%__peroot%\x86\winpe.wim"   rename "%__peroot%\x86\winpe.wim"   *.old
if exist "%__peroot%\amd64\winpe.wim" rename "%__peroot%\amd64\winpe.wim" *.old
if exist "%__peroot%\ia64\winpe.wim"  rename "%__peroot%\ia64\winpe.wim"  *.old

set error=
endlocal & set error=%error%
goto :eof



rem ================================================
rem Restore .WIM files
rem ------------------------------------------------
:restorewims
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Restore .WIM files...

call :cleanupwims

if not exist "%__peroot%\x86\winpe.wim"   if exist "%__peroot%\x86\winpe.old"   rename "%__peroot%\x86\winpe.old"   *.wim
if not exist "%__peroot%\amd64\winpe.wim" if exist "%__peroot%\amd64\winpe.old" rename "%__peroot%\amd64\winpe.old" *.wim
if not exist "%__peroot%\ia64\winpe.wim"  if exist "%__peroot%\ia64\winpe.old"  rename "%__peroot%\ia64\winpe.old"  *.wim

if exist "%__peroot%\x86\winpe.old"   del /f /q "%__peroot%\x86\winpe.old"
if exist "%__peroot%\amd64\winpe.old" del /f /q "%__peroot%\amd64\winpe.old"
if exist "%__peroot%\ia64\winpe.old"  del /f /q "%__peroot%\ia64\winpe.old"

set error=
endlocal & set error=%error%
goto :eof



rem ================================================
rem Clean up invalid .WIM files
rem ------------------------------------------------
:cleanupwims
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Cleanup invalid .WIM files...

call :cleanupwim "%__peroot%\x86\winpe.wim"
call :cleanupwim "%__peroot%\amd64\winpe.wim"
call :cleanupwim "%__peroot%\ia64\winpe.wim"

set error=
endlocal & set error=%error%
goto :eof



rem ================================================
rem Clean up invalid .WIM file
rem ------------------------------------------------
:cleanupwim
setlocal EnableDelayedExpansion EnableExtensions

if "%~1" == "" goto cleanup-done
if not exist "%~1" goto cleanup-done
set __size=%~z1
if not defined __size goto cleanup-done
if %__size% lss 1000000  if exist "%~1" del /q /f "%~1" & echo: Removing placeholder file "%~1"...
if %__size% lss 10000000 if exist "%~1" if not exist "%__peroot%\bcdedit.exe" move /y "%~1" "%__peroot%\bcdedit.exe" & echo: Updating "%__peroot%\bcdedit.exe" from "%~1...

:cleanup-done
set error=
endlocal & set error=%error%
goto :eof



rem ================================================
rem Share and map a drive to the CD/DVD drive
rem	1 = Source path of drive to share and map to
rem	2 = Name of variable to set if successful
rem ------------------------------------------------
:mapdrive
if not "%~2" == "" set %~2=
set __map=
rem See if it is a UNC
set __drv=%~1
if "%__drv:~0,2%" == "\\" goto mapdrive-end
rem See if it is a mapped drive
set __drv=%~d1
for /f "usebackq tokens=2" %%a in (`net use`) do if /i "%%a" == "%__drv%" goto mapdrive-end
rem See if it is a read-only local drive
set __ok=
rem md "%__drv%\~~test~~" 2>nul 1>nul
md "%~1\~~test~~" 2>nul 1>nul
if not errorlevel 1 set __ok=true
rem rd "%__drv%\~~test~~" 2>nul 1>nul
rd "%~1\~~test~~" 2>nul 1>nul
if defined __ok goto mapdrive-end

for %%a in (c d e f g h i j k l m n o p q r s t u v w x y z) do if not exist %%a:\ set __map=%%a:
if not defined __map goto :eof

net use %__map% \\127.0.0.1\%__drv:~0,1%$ 1>nul 2>nul
if not errorlevel 1 (
  echo: Temporary drive %__map% mapped to %__drv%
  set __src=%__map%%~pnx1
  goto :eof
)

net share $$bdc-temp$$=%__drv%\ /users:1 /cache:none 1>nul 2>nul
if errorlevel 1 (
  set __map=
  goto :eof
)

net use %__map% \\127.0.0.1\$$bdc-temp$$ 1>nul 2>nul
if errorlevel 1 (
  net share $$bdc-temp$$ /del
  set __map=
  goto :eof
)

echo: Temporary drive %__drv% share created
echo: Temporary drive %__map% mapped to %__drv%
set __src=%__map%%~pnx1
:mapdrive-end
set __ok=
if not "%~2" == "" set %~2=true
dir . 1>nul 2>nul
goto :eof



rem ================================================
rem Remove temporary share and mapping
rem ------------------------------------------------
:unmapdrive
if defined __map net use %__map% /del 1>nul 2>nul
net share $$bdc-temp$$ /del 1>nul 2>nul
goto :eof



rem ================================================
rem Copy installers to temporary directory
rem	1 = Source path to copy installers from
rem ------------------------------------------------
:copytemp
set __tmp=
call :deletetemp

md "%__tmpdir%\copy"
if errorlevel 1 (
  set __tmp=
  goto :eof
)

echo: Copying installers from "%__src%" to local temporary directory "%__tmpdir%\copy"...
rem %__tst% copy "%__src%\*.*" "%__tmpdir%\copy"
%__tst% xcopy "%__src%" "%__tmpdir%\copy" /s /e /i /h /r /y
if errorlevel 1 (
  set __tmp=
  goto :eof
)

set __src=%__tmpdir%\copy
set __tmp=%__tmpdir%\copy
dir . 1>nul 2>nul
goto :eof



rem ================================================
rem Remove temporary copy of installer files
rem ------------------------------------------------
:deletetemp
rem if exist "%__tmpdir%\copy" rd /q /s "%__tmpdir%\copy" 1>nul 2>nul
if exist "%__tmp%" rd /q /s "%__tmp%" 1>nul 2>nul
rem dir . 1>nul 2>nul
goto :eof



rem ================================================
rem Delete unneeded files
rem ------------------------------------------------
:dodelete
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Deleting unneeded files...

for /f "usebackq delims== tokens=*" %%v in (`dir "%__dst%\*.*" /b /ad  2^>nul`) do if /i not "%%~nv" == "tools" if /i not "%%~nv" == "temp" %__tst% rd  /q /s "%__dst%\%%v"
for /f "usebackq delims== tokens=*" %%v in (`dir "%__dst%\*.*" /b /a-d 2^>nul`) do                              %__tst% del /q /f "%__dst%\%%v"

set error=%errorlevel%
if "%error%" == "0" set error=
if defined error @echo: Error %error% deleting unneeded files from "%__dst%"
rem This is not considered an error
set error=
endlocal & set error=%error%
goto :eof



rem ================================================
rem Create version.ini file
rem ------------------------------------------------
:doversion
setlocal EnableDelayedExpansion EnableExtensions
@echo:
@echo Creating version file %__tools%\version.ini...

set __tst2=^>^>
if not "%__tst%" == "" set __tst2=%__tst% echo 

if not exist "%__tools%" (
  @echo: Path "%__tools%" for version.ini does not exist
  set error=3
  goto dover-done
)

if not exist "%__tools%\wimfltr.inf" (
  @echo: File "%__tools%\wimfltr.inf" does not exist
  set error=2
  goto dover-done
)

  if /i "%__prc%" == "amd64" set __prc=x64
  for /f "usebackq tokens=1* delims=," %%a in (`findstr /i /b /c:"DriverVer=" "%__tools%\wimfltr.inf" 2^>nul`) do set __ver=%%b
  if not exist "%__tools%\wimfltr.inf" @echo: File "%__tools%\wimfltr.inf" does not exist & set __ver=^<unknown^>
  if "!__ver!" == "" @echo: Could not determine WAIK version from "%__tools%\wimfltr.inf" & set __ver=^<unknown^>

  %__tst% if exist "%__tools%\version.ini" del /q /f "%__tools%\version.ini"
  %__tst2%"%__tools%\version.ini" echo [Version]
  %__tst2%"%__tools%\version.ini" echo Version=!__ver!
  %__tst2%"%__tools%\version.ini" echo Min_BDC_Build=6.9.0
  %__tst2%"%__tools%\version.ini" echo OS=WinPE2
  %__tst2%"%__tools%\version.ini" echo Processor=!__prc!
  %__tst2%"%__tools%\version.ini" echo:
  %__tst2%"%__tools%\version.ini" echo [Build]
  %__tst2%"%__tools%\version.ini" echo MajorVersion=2008
  %__tst2%"%__tools%\version.ini" echo MinorVersion=0
  %__tst2%"%__tools%\version.ini" echo BuildMajorVersion=0
  %__tst2%"%__tools%\version.ini" echo BuildMinorVersion=0
  %__tst2%"%__tools%\version.ini" echo:
  %__tst2%"%__tools%\version.ini" echo [PrebootOS.ini]
  %__tst2%"%__tools%\version.ini" echo Version=!__ver!
  %__tst2%"%__tools%\version.ini" echo Build=2008.0.0.0
  %__tst2%"%__tools%\version.ini" echo Type=%__typ%
  %__tst2%"%__tools%\version.ini" echo Source=%__src%\%__msi%

:dover-done
if "%error%" == "0" set error=
rem This is not considered an error
set error=
endlocal & set error=%error%
goto :eof
