
local DF = _G ["DetailsFramework"]
if (not DF) then
	print ("|cFFFFAA00Please restart your client to finish update some AddOns.|r")
	return
end

local _

local default_config = {
	profile = {
		readycheck = true,
		arena_queue = true,
		group_queue = true,
		pull_timers = true,
		enter_combat = false,
		end_taxi = false,
		chat_scan = false,
		chat_scan_keywords = {},
		combat_log = false,
		combat_log_keywords = {},
		rare_scan = true,
		any_rare = true,
		rare_names = {},
	}
}

local options_table = {
	name = "FlashTaskBar",
	type = "group",
	args = {

	}
}

local FlashTaskBar = DF:CreateAddOn ("FlashTaskBar", "FlashTaskbarDB", default_config, options_table)
local lower = string.lower

FlashTaskBar.last_flash = 0

function FlashTaskBar:DoFlash()
	if (FlashTaskBar.last_flash + 5 < GetTime()) then
		FlashClientIcon()
		FlashTaskBar.last_flash = GetTime()
	end
end

function FlashTaskBar.OnInit (self)
	hooksecurefunc ("LFGDungeonReadyStatus_ResetReadyStates", function()
		if (FlashTaskBar.db.profile.group_queue) then
			FlashTaskBar:DoFlash()
		end
	end)
	hooksecurefunc ("PVPReadyDialog_Display", function()
		if (FlashTaskBar.db.profile.arena_queue) then
			FlashTaskBar:DoFlash()
		end
	end)
	 
	function FlashTaskBar:CommReceived (_, prefix)
		if (not FlashTaskBar.db.profile.pull_timers) then
			return
		end
		if (prefix:find ("PT")) then
			FlashTaskBar:DoFlash()
		elseif (prefix:find ("BWPull")) then
			FlashTaskBar:DoFlash()
		end
	end
	FlashTaskBar:RegisterComm ("D4", "CommReceived")
	FlashTaskBar:RegisterComm ("BigWigs", "CommReceived")
	
	function FlashTaskBar:READY_CHECK()
		if (FlashTaskBar.db.profile.readycheck) then
			FlashTaskBar:DoFlash()
		end
	end
	FlashTaskBar:RegisterEvent ("READY_CHECK")
	
	function FlashTaskBar:PLAYER_REGEN_DISABLED()
		if (FlashTaskBar.db.profile.enter_combat) then
			FlashTaskBar:DoFlash()
		end
	end
	FlashTaskBar:RegisterEvent ("PLAYER_REGEN_DISABLED")
	
	FlashTaskBar.on_taxi = false
	function FlashTaskBar:SPELL_FLYOUT_UPDATE()
		if (FlashTaskBar.on_taxi and not UnitOnTaxi ("player")) then
			if (FlashTaskBar.db.profile.end_taxi) then
				FlashTaskBar:DoFlash()
			end
		end
		FlashTaskBar.on_taxi = UnitOnTaxi ("player")
	end
	FlashTaskBar:RegisterEvent ("SPELL_FLYOUT_UPDATE")

--------> chat scan
	
	local player_name = UnitName ("player")
	
	local do_chat_scan = function (_, message)
		for _, keyword in ipairs (FlashTaskBar.db.profile.chat_scan_keywords) do
			if (lower (message):find (lower (keyword))) then
				FlashTaskBar:DoFlash()
			end
		end
		--if (message:find (player_name)) then
		--	FlashTaskBar:DoFlash()
		--end
	end
	
	function FlashTaskBar:EnableChatScan()
		FlashTaskBar:RegisterEvent ("CHAT_MSG_EMOTE", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_MONSTER_EMOTE", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_MONSTER_SAY", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_MONSTER_WHISPER", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_MONSTER_YELL", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_RAID_BOSS_EMOTE", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_RAID_BOSS_WHISPER", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_SYSTEM", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_SAY", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_YELL", do_chat_scan)
		FlashTaskBar:RegisterEvent ("CHAT_MSG_CHANNEL", do_chat_scan)
	end	
	
	function FlashTaskBar:DisableChatScan()
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_EMOTE")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_MONSTER_EMOTE")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_MONSTER_SAY")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_MONSTER_WHISPER")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_MONSTER_YELL")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_RAID_BOSS_EMOTE")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_RAID_BOSS_WHISPER")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_SYSTEM")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_SAY")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_YELL")
		FlashTaskBar:UnregisterEvent ("CHAT_MSG_CHANNEL")
	end

--------> combat log scan

	local combat_log_keywords = {}
	local do_combat_log_scan = function (event, time, token, hidding, who_serial, who_name, who_flags, who_flags2, target_serial, target_name, target_flags, target_flags2, ...)
		if (combat_log_keywords [lower (target_name)]) then
			FlashTaskBar:DoFlash()
		end
	end
	
	function FlashTaskBar:BuildCombatLogKeywordTable()
		wipe (combat_log_keywords)
		for _, keyword in ipairs (FlashTaskBar.db.profile.combat_log_keywords) do
			combat_log_keywords [lower (keyword)] = true
		end
	end
	
	function FlashTaskBar:EnableCombatLogScan()
		FlashTaskBar:RegisterEvent ("COMBAT_LOG_EVENT_UNFILTERED", do_combat_log_scan)
		FlashTaskBar:BuildCombatLogKeywordTable()
	end
	
	function FlashTaskBar:DisableCombatLogScan()
		FlashTaskBar:UnregisterEvent ("COMBAT_LOG_EVENT_UNFILTERED")
	end
	
--------> rare mob scan

	local do_rare_mob_scan = function()
		for i = 1, C_Vignettes.GetNumVignettes() do
			local serial = C_Vignettes.GetVignetteGUID (i)
			if (serial) then
				local _, _, name, objectIcon = C_Vignettes.GetVignetteInfoFromInstanceID (serial)
				if (objectIcon and objectIcon == 41) then
					if (FlashTaskBar.db.profile.any_rare) then
						FlashTaskBar:DoFlash()
					elseif (name) then
						for _, npc_name in ipairs (FlashTaskBar.db.profile.rare_names) do
							npc_name = lower (npc_name)
							name = lower (name)
							if (npc_name == name) then
								FlashTaskBar:DoFlash()
							end
						end
					end
				end
			end
		end
	end
	
	function FlashTaskBar:EnableRareMobScan()
		FlashTaskBar:RegisterEvent ("VIGNETTE_ADDED", do_rare_mob_scan) --"VIGNETTE_REMOVED"
	end
	
	function FlashTaskBar:DisableRareMobScan()
		FlashTaskBar:UnregisterEvent ("VIGNETTE_ADDED")
	end

--> build options panel
	
	local options = {
		{
			type = "toggle",
			name = "On Ready Check",
			desc = "Flash the task bar on ready check.",
			order = 1,
			get = function() return FlashTaskBar.db.profile.readycheck end,
			set = function (self, val) 
				FlashTaskBar.db.profile.readycheck = not FlashTaskBar.db.profile.readycheck
			end,
		},
		{
			type = "toggle",
			name = "On PvP Queues",
			desc = "Flash the task bar on battleground and arena queues.",
			order = 2,
			get = function() return FlashTaskBar.db.profile.arena_queue end,
			set = function (self, val) 
				FlashTaskBar.db.profile.arena_queue = not FlashTaskBar.db.profile.arena_queue
			end,
		},
		{
			type = "toggle",
			name = "On Finder Queues",
			desc = "Flash the task bar on raid, dungeon finders.",
			order = 3,
			get = function() return FlashTaskBar.db.profile.group_queue end,
			set = function (self, val) 
				FlashTaskBar.db.profile.group_queue = not FlashTaskBar.db.profile.group_queue
			end,
		},
		{
			type = "toggle",
			name = "Pull Timers",
			desc = "When a pull timer starts from BigWigs or DBM.",
			order = 4,
			get = function() return FlashTaskBar.db.profile.pull_timers end,
			set = function (self, val) 
				FlashTaskBar.db.profile.pull_timers = not FlashTaskBar.db.profile.pull_timers
			end,
		},
		{
			type = "toggle",
			name = "Enter Combat",
			desc = "When your character enters in any combat.",
			order = 5,
			get = function() return FlashTaskBar.db.profile.enter_combat end,
			set = function (self, val) 
				FlashTaskBar.db.profile.enter_combat = not FlashTaskBar.db.profile.enter_combat
			end,
		},
		{
			type = "toggle",
			name = "Fly Point Reached",
			desc = "When your fly through Fly Masters ends.",
			order = 6,
			get = function() return FlashTaskBar.db.profile.end_taxi end,
			set = function (self, val) 
				FlashTaskBar.db.profile.end_taxi = not FlashTaskBar.db.profile.end_taxi
			end,
		},
	}
	
	local options_text_template = FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE")
	local options_dropdown_template = FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE")
	local options_switch_template = FlashTaskBar:GetTemplate ("switch", "OPTIONS_CHECKBOX_TEMPLATE")
	local options_slider_template = FlashTaskBar:GetTemplate ("slider", "OPTIONS_SLIDER_TEMPLATE")
	local options_button_template = FlashTaskBar:GetTemplate ("button", "OPTIONS_BUTTON_TEMPLATE")
	
	local general_text1 = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "General Settings:", FlashTaskBar:GetTemplate ("font", "ORANGE_FONT_TEMPLATE"))
	general_text1:SetPoint ("topleft", main_frame, "topleft", 10, -50)
	FlashTaskBar:SetFontSize (general_text1, 16)
	
	local general_settings_frame = CreateFrame ("frame", "FlashTaskBarGeneralOptionsFrame", FlashTaskBar.OptionsFrame1)
	general_settings_frame:SetPoint ("topleft", 0, 0)
	general_settings_frame:SetSize (1, 1)
	
	FlashTaskBar:BuildMenu (general_settings_frame, options, 15, -77, 180, true, options_text_template, options_dropdown_template, options_switch_template, true, options_slider_template, options_button_template)
	
	local y_chat_scan = -170
	
	local camping_text1 = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "Camping Settings" .. ":", FlashTaskBar:GetTemplate ("font", "ORANGE_FONT_TEMPLATE"))
	camping_text1:SetPoint ("topleft", main_frame, "topleft", 10, y_chat_scan)
	FlashTaskBar:SetFontSize (camping_text1, 16)
	y_chat_scan = y_chat_scan - 30
	
	--> chat scan settings
	
	--> title label
	local blink_on_chat = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "Chat Scan:", FlashTaskBar:GetTemplate ("font", "ORANGE_FONT_TEMPLATE"))
	blink_on_chat:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan)	
	
	--> enabled
	local enable_chat_filter = function (_, _, value)
		FlashTaskBar.db.profile.chat_scan = value
		if (value) then
			FlashTaskBar:EnableChatScan()
		else
			FlashTaskBar:DisableChatScan()
		end
	end
	local chat_scan_switch, chat_scan_label = FlashTaskBar:CreateSwitch (FlashTaskBar.OptionsFrame1, enable_chat_filter, FlashTaskBar.db.profile.chat_scan, _, _, _, _, "switch_enable_chat_scan", _, _, _, _, "Chat Scan Enabled" .. ":", FlashTaskBar:GetTemplate ("switch", "OPTIONS_CHECKBOX_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	chat_scan_switch:SetAsCheckBox()
	chat_scan_switch.tooltip = "Search chat for specific words.\n\nFor instance, when a specific npc yells something and you want to be alerted by that."
	chat_scan_label:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-20)	
	
	--> key words
	--add
	local chat_scan_keyword, label_chat_scan_keyword = FlashTaskBar:CreateTextEntry (FlashTaskBar.OptionsFrame1, function()end, 120, 20, "entry_add_keyword", _, "Add Keyword" .. ":", FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	label_chat_scan_keyword:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-40)	
	
	local add_key_word_func = function()
		local keyword = chat_scan_keyword.text
		if (keyword ~= "") then
			tinsert (FlashTaskBar.db.profile.chat_scan_keywords, keyword)
		end
		chat_scan_keyword.text = ""
		chat_scan_keyword:ClearFocus()
		FlashTaskBar.OptionsFrame1.dropdown_keyword_remove:Refresh()
		FlashTaskBar.OptionsFrame1.dropdown_keyword_remove:Select (1, true)
	end
	local button_add_keyword = FlashTaskBar:CreateButton (FlashTaskBar.OptionsFrame1, add_key_word_func, 60, 18, "add", _, _, _, _, _, _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	button_add_keyword:SetPoint ("left", chat_scan_keyword, "right", 2, 0)
	
	--remove
	local dropdown_keyword_erase_fill = function()
		local t = {}
		for i, keyword in ipairs (FlashTaskBar.db.profile.chat_scan_keywords) do
			t [#t+1] = {value = i, label = keyword, onclick = empty_func}
		end
		return t
	end
	local label_keyword_remove = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "Erase Keyword" .. ": ", FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	local dropdown_keyword_remove = FlashTaskBar:CreateDropDown (FlashTaskBar.OptionsFrame1, dropdown_keyword_erase_fill, _, 160, 20, "dropdown_keyword_remove", _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"))
	dropdown_keyword_remove:SetPoint ("left", label_keyword_remove, "right", 2, 0)

	local keyword_remove = function()
		local value = dropdown_keyword_remove.value
		tremove (FlashTaskBar.db.profile.chat_scan_keywords, value)
		dropdown_keyword_remove:Refresh()
		dropdown_keyword_remove:Select (1, true)
	end
	local button_keyword_remove = FlashTaskBar:CreateButton (FlashTaskBar.OptionsFrame1, keyword_remove, 60, 18, "remove", _, _, _, _, _, _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	button_keyword_remove:SetPoint ("left", dropdown_keyword_remove, "right", 2, 0)
	label_keyword_remove:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-60)
	
	if (FlashTaskBar.db.profile.chat_scan) then
		FlashTaskBar:EnableChatScan()
	end
	
	
	--> combat log scan settings
	
	--> title label
	local blink_on_combatlog = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "CombatLog Scan:", FlashTaskBar:GetTemplate ("font", "ORANGE_FONT_TEMPLATE"))
	blink_on_combatlog:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-90)		
	
	--> enabled
	local enable_combatlog_filter = function (_, _, value)
		FlashTaskBar.db.profile.combat_log = value
		if (value) then
			FlashTaskBar:EnableCombatLogScan()
		else
			FlashTaskBar:DisableCombatLogScan()
		end
	end
	local combatlog_scan_switch, combatlog_scan_label = FlashTaskBar:CreateSwitch (FlashTaskBar.OptionsFrame1, enable_combatlog_filter, FlashTaskBar.db.profile.combat_log, _, _, _, _, "switch_enable_combatlog_scan", _, _, _, _, "CombatLog Scan Enabled" .. ":", FlashTaskBar:GetTemplate ("switch", "OPTIONS_CHECKBOX_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	combatlog_scan_switch.tooltip = "Check for target names on combat log.\n\nFor instance, when a specific npc takes damage end you want to be alerted by that."
	combatlog_scan_switch:SetAsCheckBox()
	combatlog_scan_label:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-110)	
	
	--> key words
	--add
	local combatlog_scan_keyword, label_combatlog_scan_keyword = FlashTaskBar:CreateTextEntry (FlashTaskBar.OptionsFrame1, function()end, 120, 20, "entry_add_keyword", _, "Npc Name" .. ":", FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	label_combatlog_scan_keyword:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-130)	
	
	local add_key_word_func = function()
		local keyword = combatlog_scan_keyword.text
		if (keyword ~= "") then
			tinsert (FlashTaskBar.db.profile.combat_log_keywords, keyword)
		end
		combatlog_scan_keyword.text = ""
		combatlog_scan_keyword:ClearFocus()
		FlashTaskBar.OptionsFrame1.dropdown_combatlog_keyword_remove:Refresh()
		FlashTaskBar.OptionsFrame1.dropdown_combatlog_keyword_remove:Select (1, true)
		FlashTaskBar:BuildCombatLogKeywordTable()
	end
	local button_add_keyword = FlashTaskBar:CreateButton (FlashTaskBar.OptionsFrame1, add_key_word_func, 60, 18, "add", _, _, _, _, _, _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	button_add_keyword:SetPoint ("left", combatlog_scan_keyword, "right", 2, 0)
	
	--remove
	local dropdown_keyword_erase_fill = function()
		local t = {}
		for i, keyword in ipairs (FlashTaskBar.db.profile.combat_log_keywords) do
			t [#t+1] = {value = i, label = keyword, onclick = empty_func}
		end
		return t
	end
	local label_keyword_remove = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "Remove" .. ": ", FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	local dropdown_keyword_remove = FlashTaskBar:CreateDropDown (FlashTaskBar.OptionsFrame1, dropdown_keyword_erase_fill, _, 160, 20, "dropdown_combatlog_keyword_remove", _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"))
	dropdown_keyword_remove:SetPoint ("left", label_keyword_remove, "right", 2, 0)

	local keyword_remove = function()
		local value = dropdown_keyword_remove.value
		tremove (FlashTaskBar.db.profile.combat_log_keywords, value)
		dropdown_keyword_remove:Refresh()
		dropdown_keyword_remove:Select (1, true)
		FlashTaskBar:BuildCombatLogKeywordTable()
	end
	local button_keyword_remove = FlashTaskBar:CreateButton (FlashTaskBar.OptionsFrame1, keyword_remove, 60, 18, "remove", _, _, _, _, _, _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	button_keyword_remove:SetPoint ("left", dropdown_keyword_remove, "right", 2, 0)
	label_keyword_remove:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-150)
	
	if (FlashTaskBar.db.profile.combat_log) then
		FlashTaskBar:EnableCombatLogScan()
	end
	
	
	--> rare mob scan settings
	
	--> title label
	local blink_on_raremob = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "Rare Npc Scan:", FlashTaskBar:GetTemplate ("font", "ORANGE_FONT_TEMPLATE"))
	blink_on_raremob:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-180)		
	
	--> enabled
	local enable_raremob_filter = function (_, _, value)
		FlashTaskBar.db.profile.rare_scan = value
		if (value) then
			FlashTaskBar:EnableRareMobScan()
		else
			FlashTaskBar:DisableRareMobScan()
		end
	end
	local raremob_scan_switch, raremob_scan_label = FlashTaskBar:CreateSwitch (FlashTaskBar.OptionsFrame1, enable_raremob_filter, FlashTaskBar.db.profile.rare_scan, _, _, _, _, "switch_enable_raremob_scan", _, _, _, _, "Rare Scan Enabled" .. ":", FlashTaskBar:GetTemplate ("switch", "OPTIONS_CHECKBOX_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	raremob_scan_switch:SetAsCheckBox()
	raremob_scan_switch.tooltip = "When a rare does respaw near you or you just pass by one."
	raremob_scan_label:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-200)	
	
	--> all rares
	local enable_raremob_all_filter = function (_, _, value)
		FlashTaskBar.db.profile.any_rare = value
	end
	local raremob_all_scan_switch, raremob_all_scan_label = FlashTaskBar:CreateSwitch (FlashTaskBar.OptionsFrame1, enable_raremob_all_filter, FlashTaskBar.db.profile.any_rare, _, _, _, _, "switch_enable_raremob_all_scan", _, _, _, _, "Any Rare Npc" .. ":", FlashTaskBar:GetTemplate ("switch", "OPTIONS_CHECKBOX_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	raremob_all_scan_switch:SetAsCheckBox()
	raremob_all_scan_label:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-220)	
	
	--> key words
	--add
	local raremob_scan_keyword, label_raremob_scan_keyword = FlashTaskBar:CreateTextEntry (FlashTaskBar.OptionsFrame1, function()end, 120, 20, "raremob_add_keyword", _, "Npc Name" .. ":", FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	label_raremob_scan_keyword:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-240)	
	
	local add_key_word_func = function()
		local keyword = raremob_scan_keyword.text
		if (keyword ~= "") then
			tinsert (FlashTaskBar.db.profile.rare_names, keyword)
		end
		raremob_scan_keyword.text = ""
		raremob_scan_keyword:ClearFocus()
		FlashTaskBar.OptionsFrame1.dropdown_rare_keyword_remove:Refresh()
		FlashTaskBar.OptionsFrame1.dropdown_rare_keyword_remove:Select (1, true)
	end
	local button_add_keyword = FlashTaskBar:CreateButton (FlashTaskBar.OptionsFrame1, add_key_word_func, 60, 18, "add", _, _, _, _, _, _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	button_add_keyword:SetPoint ("left", raremob_scan_keyword, "right", 2, 0)
	
	--remove
	local dropdown_keyword_erase_fill = function()
		local t = {}
		for i, keyword in ipairs (FlashTaskBar.db.profile.rare_names) do
			t [#t+1] = {value = i, label = keyword, onclick = empty_func}
		end
		return t
	end
	local label_keyword_remove = FlashTaskBar:CreateLabel (FlashTaskBar.OptionsFrame1, "Remove" .. ": ", FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	local dropdown_keyword_remove = FlashTaskBar:CreateDropDown (FlashTaskBar.OptionsFrame1, dropdown_keyword_erase_fill, _, 160, 20, "dropdown_rare_keyword_remove", _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"))
	dropdown_keyword_remove:SetPoint ("left", label_keyword_remove, "right", 2, 0)

	local keyword_remove = function()
		local value = dropdown_keyword_remove.value
		tremove (FlashTaskBar.db.profile.rare_names, value)
		dropdown_keyword_remove:Refresh()
		dropdown_keyword_remove:Select (1, true)
	end
	local button_keyword_remove = FlashTaskBar:CreateButton (FlashTaskBar.OptionsFrame1, keyword_remove, 60, 18, "remove", _, _, _, _, _, _, FlashTaskBar:GetTemplate ("dropdown", "OPTIONS_DROPDOWN_TEMPLATE"), FlashTaskBar:GetTemplate ("font", "OPTIONS_FONT_TEMPLATE"))
	button_keyword_remove:SetPoint ("left", dropdown_keyword_remove, "right", 2, 0)
	label_keyword_remove:SetPoint ("topleft", FlashTaskBar.OptionsFrame1, "topleft", 10, y_chat_scan-260)
	
	
	if (FlashTaskBar.db.profile.rare_scan) then
		FlashTaskBar:EnableRareMobScan()
	end
	
	--InterfaceOptionsFrame_OpenToCategory ("FlashTaskBar")
	--InterfaceOptionsFrame_OpenToCategory ("FlashTaskBar")
	
end
