DROP TABLE IF EXISTS `cloud_configs`;
CREATE TABLE `cloud_configs` (
  `k` varchar(255) NOT NULL DEFAULT '',
  `v` text,
  PRIMARY KEY (`k`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `cloud_configs` VALUES ('version','3.0');

DROP TABLE IF EXISTS `cloud_ggs`;
CREATE TABLE `cloud_ggs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `value` text,
  `addtime` datetime DEFAULT NULL,
  `imp` tinyint(3) NOT NULL DEFAULT '0',
  `zid` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_kms`;
CREATE TABLE `cloud_kms` (
  `kid` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `type` tinyint(3) NOT NULL DEFAULT '0',
  `km` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `useid` int(11) NOT NULL DEFAULT '0',
  `addtime` varchar(255) DEFAULT NULL,
  `usetime` datetime DEFAULT NULL,
  `zid` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`kid`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_level`;
CREATE TABLE `cloud_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL DEFAULT '0',
  `name` varchar(80) DEFAULT NULL,
  `vipprice` decimal(10,2) NOT NULL DEFAULT '1.00',
  `vipdprice` decimal(10,2) NOT NULL DEFAULT '1.00',
  `peieprice` decimal(10,2) NOT NULL DEFAULT '1.00',
  `zid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cloud_goods`;
CREATE TABLE `cloud_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `addtime` datetime DEFAULT NULL,
  `zid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_goods_km`;
CREATE TABLE `cloud_goods_km` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL DEFAULT '0',
  `goods` varchar(255) DEFAULT NULL,
  `km` varchar(255) DEFAULT NULL,
  `pass` varchar(255) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `buyuid` int(11) NOT NULL DEFAULT '0',
  `buytime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_msglist`;
CREATE TABLE `cloud_msglist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `qq` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `value` text,
  `addtime` datetime DEFAULT NULL,
  `zt` tinyint(3) NOT NULL DEFAULT '0',
  `zid` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_order`;
CREATE TABLE `cloud_order` (
  `trade_no` varchar(64) NOT NULL,
  `type` varchar(20) DEFAULT NULL,
  `orderid` varchar(64) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `name` varchar(64) DEFAULT NULL,
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int(1) NOT NULL DEFAULT '0',
  `zid` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`trade_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

DROP TABLE IF EXISTS `cloud_pay`;
CREATE TABLE `cloud_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `qq` char(20) DEFAULT NULL,
  `orderid` char(64) DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  `endtime` datetime DEFAULT NULL,
  `name` char(64) DEFAULT NULL,
  `text` char(255) DEFAULT NULL,
  `money` decimal(6,2) NOT NULL DEFAULT '0.00',
  `state` int(1) NOT NULL DEFAULT '0',
  `type` varchar(10) DEFAULT NULL,
  `mtype` tinyint(3) NOT NULL DEFAULT '0',
  `shopid` tinyint(3) NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `zid` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

DROP TABLE IF EXISTS `cloud_qiandaos`;
CREATE TABLE `cloud_qiandaos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `num` int(11) NOT NULL DEFAULT '0',
  `qdtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_qqs`;
CREATE TABLE `cloud_qqs` (
  `qid` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `zid` int(11) NOT NULL DEFAULT '1',
  `qq` varchar(11) NOT NULL DEFAULT '0',
  `pwd` varchar(255) DEFAULT NULL,
  `cookie` text,
  `cookiezt` tinyint(3) NOT NULL DEFAULT '0',
  `addtime` datetime DEFAULT NULL,
  `enddate` date DEFAULT NULL,
  `lastauto` datetime DEFAULT NULL,
  `zan` tinyint(3) NOT NULL DEFAULT '0',
  `zannet` int(11) NOT NULL DEFAULT '0',
  `lastzan` datetime DEFAULT NULL,
  `shuo` tinyint(3) NOT NULL DEFAULT '0',
  `shuocon` text,
  `shuoimg` varchar(255) DEFAULT NULL,
  `shuorate` int(11) NOT NULL DEFAULT '15',
  `shuoaite` varchar(255) DEFAULT NULL,
  `shuonet` int(11) NOT NULL DEFAULT '0',
  `lastshuo` datetime DEFAULT NULL,
  `nextshuo` datetime DEFAULT NULL,
  `reply` tinyint(3) NOT NULL DEFAULT '0',
  `replycon` text,
  `replyimg` varchar(255) DEFAULT NULL,
  `replyaite` varchar(255) CHARACTER SET utf8 COLLATE utf8_estonian_ci DEFAULT NULL,
  `replyrate` int(11) NOT NULL DEFAULT '15',
  `replynet` int(11) NOT NULL DEFAULT '0',
  `lastreply` datetime DEFAULT NULL,
  `nextreply` datetime DEFAULT NULL,
  `zf` tinyint(3) NOT NULL DEFAULT '0',
  `zfcon` text,
  `zfaite` varchar(255) DEFAULT NULL,
  `zfqqs` varchar(255) DEFAULT NULL,
  `zfnet` int(11) NOT NULL DEFAULT '0',
  `lastzf` datetime DEFAULT NULL,
  `delshuo` tinyint(3) NOT NULL DEFAULT '0',
  `lastdelshuo` datetime DEFAULT NULL,
  `delly` tinyint(3) NOT NULL DEFAULT '0',
  `lastdelly` datetime DEFAULT NULL,
  `vipqd` tinyint(3) NOT NULL DEFAULT '0',
  `lastvipqd` datetime DEFAULT NULL,
  `nextvipqd` datetime DEFAULT NULL,
  `qd` tinyint(3) NOT NULL DEFAULT '0',
  `lastqd` datetime DEFAULT NULL,
  `nextqd` datetime DEFAULT NULL,
  `qt` tinyint(3) NOT NULL DEFAULT '0',
  `lastqt` datetime DEFAULT NULL,
  `ht` tinyint(3) NOT NULL DEFAULT '0',
  `lastht` datetime DEFAULT NULL,
  `nextht` datetime DEFAULT NULL,
  `qunqd` tinyint(3) NOT NULL DEFAULT '0',
  `lastqunqd` datetime DEFAULT NULL,
  `nextqunqd` datetime DEFAULT NULL,
  `walletqd` tinyint(3) NOT NULL DEFAULT '0',
  `lastwalletqd` datetime DEFAULT NULL,
  `nextwalletqd` datetime DEFAULT NULL,
  `phone` tinyint(3) NOT NULL DEFAULT '0',
  `lastphone` varchar(255) DEFAULT NULL,
  `nextphone` datetime DEFAULT NULL,
  `ly` tinyint(1) NOT NULL DEFAULT '0',
  `lastly` datetime DEFAULT NULL,
  `nextly` datetime DEFAULT NULL,
  `zyzan` tinyint(1) NOT NULL DEFAULT '0',
  `lastzyzan` datetime DEFAULT NULL,
  `nextzyzan` datetime DEFAULT NULL,
  `buluo` tinyint(3) NOT NULL DEFAULT '0',
  `lastbuluo` datetime DEFAULT NULL,
  `nextbuluo` datetime DEFAULT NULL,
  `qipao` tinyint(3) NOT NULL DEFAULT '0',
  `lastqipao` datetime DEFAULT NULL,
  `yyjs` tinyint(3) NOT NULL DEFAULT '0',
  `lastyyjs` datetime DEFAULT NULL,
  `nextyyjs` datetime DEFAULT NULL,
  `lzqd` tinyint(3) NOT NULL DEFAULT '0',
  `lastlzqd` datetime DEFAULT NULL,
  `nextlzqd` datetime DEFAULT NULL,
  `yqd` tinyint(3) NOT NULL DEFAULT '0',
  `lastyqd` datetime DEFAULT NULL,
  `nextyqd` datetime DEFAULT NULL,
  `video` tinyint(3) NOT NULL DEFAULT '0',
  `lastvideo` datetime DEFAULT NULL,
  `nextvideo` datetime DEFAULT NULL,
  `gamevip` tinyint(3) NOT NULL DEFAULT '0',
  `lastgamevip` datetime DEFAULT NULL,
  `nextgamevip` datetime DEFAULT NULL,
  `webface` tinyint(3) NOT NULL DEFAULT '0',
  `lastwebface` datetime DEFAULT NULL,
  `nextwebface` datetime DEFAULT NULL, 
  `qcloud` tinyint(3) NOT NULL DEFAULT '0',
  `lastqcloud` datetime DEFAULT NULL,
  `nextqcloud` datetime DEFAULT NULL,
  `social` tinyint(3) NOT NULL DEFAULT '0',
  `lastsocial` datetime DEFAULT NULL,
  `nextsocial` datetime DEFAULT NULL,
  `qqgame` tinyint(3) NOT NULL DEFAULT '0',
  `lastqqgame` datetime DEFAULT NULL,
  `nextqqgame` datetime DEFAULT NULL,
  `xing` tinyint(3) NOT NULL DEFAULT '0',
  `lastxing` datetime DEFAULT NULL, 
  `nextxing` datetime DEFAULT NULL,
  `fzqd` tinyint(3) NOT NULL DEFAULT '0',
  `lastfzqd` datetime DEFAULT NULL, 
  `nextfzqd` datetime DEFAULT NULL,
  `weiyun` tinyint(3) NOT NULL DEFAULT '0',
  `lastweiyun` datetime DEFAULT NULL, 
  `nextweiyun` datetime DEFAULT NULL,
  `sweet_sign` tinyint(3) NOT NULL DEFAULT '0',
  `lastsweet_sign` datetime DEFAULT NULL, 
  `nextsweet_sign` datetime DEFAULT NULL,
  `checkin` tinyint(3) NOT NULL DEFAULT '0',
  `lastcheckin` datetime DEFAULT NULL, 
  `nextcheckin` datetime DEFAULT NULL,
  PRIMARY KEY (`qid`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_users`;
CREATE TABLE `cloud_users` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `zid` int(11) NOT NULL DEFAULT '1',
  `user` varchar(255) DEFAULT NULL,
  `pass` varchar(255) DEFAULT NULL,
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `yb` decimal(10,2) NOT NULL DEFAULT '0.00',
  `mxb` decimal(10,2) NOT NULL DEFAULT '0.00',
  `sid` varchar(255) DEFAULT NULL,
  `regtime` datetime DEFAULT NULL,
  `regip` varchar(255) DEFAULT NULL,
  `power` tinyint(3) NOT NULL DEFAULT '0',
  `mail` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `peie` int(11) NOT NULL DEFAULT '1',
  `vipenddate` date DEFAULT NULL,
  `daili` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_weblist`;
CREATE TABLE `cloud_weblist` (
  `zid` int(11) NOT NULL AUTO_INCREMENT,
  `upzid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `kfqq` varchar(255) NOT NULL DEFAULT '0',
  `domain` varchar(255) DEFAULT NULL,
  `domain2` varchar(255) DEFAULT NULL,
  `webname` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT '首页',
  `gg` text,
  `price_1peie` decimal(10,2) NOT NULL DEFAULT '10.00',
  `price_1vip` decimal(10,2) NOT NULL DEFAULT '5.00',
  `xzvip` tinyint(3) NOT NULL DEFAULT '0',
  `adddate` date DEFAULT NULL,
  `enddate` date DEFAULT NULL,
  `stop` tinyint(3) NOT NULL DEFAULT '0',
  `peie` int(11) NOT NULL DEFAULT '5000',
  `fzpeie` int(11) NOT NULL DEFAULT '5000',
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `alipay_account` varchar(255) DEFAULT NULL,
  `alipay_pid` varchar(255) DEFAULT NULL,
  `alipay_key` varchar(255) DEFAULT NULL,
  `alipay_moblie` tinyint(3) NOT NULL DEFAULT '0',
  `payapi` tinyint(3) NOT NULL DEFAULT '0',
  `music_url` varchar(255) DEFAULT NULL,
  `fzneed` tinyint(3) NOT NULL DEFAULT '0',
  `fzprice` decimal(10,2) NOT NULL DEFAULT '0.00',
  `addqq_mail` tinyint(3) NOT NULL DEFAULT '1',
  `addurl` varchar(255) DEFAULT NULL,
  `qdcon` text,
  `qdimg` varchar(255) DEFAULT NULL,
  `epay_pid` varchar(255) DEFAULT NULL,
  `epay_key` varchar(255) DEFAULT NULL,
  `hushua` tinyint(3) NOT NULL DEFAULT '1',
  `addfriend` varchar(20) DEFAULT NULL,
  `appdownurl` varchar(255) DEFAULT NULL,
  `addgroup` varchar(255) DEFAULT NULL,
  `addvipgroup` varchar(255) DEFAULT NULL,
  `appdownload` varchar(255) DEFAULT NULL,
  `wap` tinyint(3) NOT NULL DEFAULT '0',
  `qqjump` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`zid`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cloud_ips`;
CREATE TABLE `cloud_ips` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zid` varchar(255) NOT NULL DEFAULT '1',
  `ip` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

insert into `cloud_users` (`uid`,`zid`,`user`,`pass`,`mail`,`qq`,`regtime`,`power`) values('1','1','admin','123456','896188263@qq.com','896188263',NOW(),9);
