<?php 
// +----------------------------------------------------------------------
// | Quotes [ 没有目标的人生就是张拼图，反之则是蓝图]
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 云影 <8711973@qq.com>
// +----------------------------------------------------------------------
// | Date: 2016年8月19日
// +----------------------------------------------------------------------
namespace app\index\controller;
use think\Db;
class Daili extends Common
{
    function __construct(){
        parent::__construct();
        //判断是否已登录
        if (empty($this->userInfo) || $this->userInfo['daili'] == 0 || $this->userInfo['zid'] != ZID || Check_Daili($this->userInfo['daili']) == false) {
            $this->assign('alert', sweetAlert('无权限', '无权限！', 'warning', url('main/index')));
            exit($this->fetch('common/sweetalert'));
        }
    }
    
    public function index() 
    {
        $info = Db::name('level')->where(['level'=>$this->userInfo['daili'],'zid'=>ZID])->find();
        $do = input('do');
        $kmmsg = '';
        $search = '';
        if($do == "addkm"){
            $num = daddslashes(input('post.num/d'));
            $val = daddslashes(input('post.val/d'));
            $kind = daddslashes(input('post.type/d'));
            if ($kind == -1)
            {
                $this->assign('alert', sweetAlert('温馨提示', '请选择卡密类型', 'warning',url()));
                exit($this->fetch('common/sweetalert'));
            }
            if($num <= 0 || $val <= 0 || $kind < 0 || $kind > 3){
                $this->assign('alert', sweetAlert('温馨提示', '参数错误', 'warning',url()));
                exit($this->fetch('common/sweetalert'));
            }
            $t = 1;
            if ($kind == 0)
            {
                $t = $info['vipdprice'] ? : 999;
            } else if ($kind == 2)
            {
                $t = $info['peieprice'] ? : 999;
            } else if ($kind == 3)
            {
                $t = $info['vipprice'] ? : 999;
            }
            $need_money = $num * $val * $t;
            if($this->userInfo['money'] < $need_money){
                $this->assign('alert', sweetAlert('温馨提示', '余额不足', 'warning',url('main/kmcz')));
                exit($this->fetch('common/sweetalert'));
            } 
            Db::name('users')->where(['zid'=>ZID,'uid'=>$this->uid])->update(['money'=>$this->userInfo['money']-$need_money]);
            for($i=0;$i<$num;$i++){
                $km=getRandStr();
                $data[] = ['type'=>$kind,'km'=>$km,'value'=>$val,'addtime'=>date("Y-m-d H:i:s"),'zid'=>ZID,'uid'=>$this->uid];
                $kmmsg.="<li class='list-group-item'>{$km}</li>";
            }
            //分批写入 每次1000条
            $data = array_chunk($data,1000);
            foreach ($data as $datas){
                Db::name('kms')->insertAll($datas);
            }
            
        } else if($do == "cleanall"){
            Db::name('kms')->where(['zid'=>ZID,'uid'=>$this->uid])->where('useid','<>','0')->delete();
            $this->assign('alert', sweetAlert('温馨提示', '清空成功', 'success',url()));
        } else if($do == "del"){
            $id = daddslashes(input('id/d'));
            if(Db::name('kms')->where(['kid'=>$id,'zid'=>ZID,'uid'=>$this->uid])->delete()){
                $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success',url()));
            } else {
                $this->assign('alert', sweetAlert('温馨提示', '删除失败', 'warning'));
            }
        } else if ($do == "search"){
            $search = ['km'=>['like','%'.input('get.query').'%']];
        }
        $list = Db::name('kms')->where(['zid'=>ZID,'uid'=>$this->uid])->where($search)->order('kid DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('kmmsg',$kmmsg);
        $this->assign('dlinfo',$info);
        return $this->fetch();
    }
}