<?php 
namespace app\index\controller;
use think\Controller;
use think\Db;
//use app\util\AliPay;
class Common extends Controller
{
    protected $userInfo;
    protected $uid;
    protected $power;
    protected $database;
    protected $vip;
    protected $all_qqs;
    protected $all_fz;
    protected $mail_configs;
    
    function __construct(){
        parent :: __construct();
        //初始化cookie
        cookie(['prefix'=>'cloud_','expire'=>3600*24,'path'=>'/']);
        $this->database = config('database');
        $this->load_webconfigs();
		
        //记录来访IP
        $this->addIp(getIP());
        //清理来访IP
        $this->cleanIp();
        //反腾讯管家网址检测
        $Is_Txprotect = config('zz_txprotect') ? : 0;
        if ($Is_Txprotect == 1){
            $New_Controller = request()->controller();
            $New_Controller = strtolower($New_Controller);
            $WhiteController = ['ajax','main','tool'];
            if (!in_array($New_Controller,$WhiteController)){
                $this->txprotect();
            }
            $this->txprotect();
        }
        //判断登录状态
        $cookie = cookie('usersid');
        if($cookie != null){
            $this->userInfo = Db::name('users')->where(array('sid'=>$cookie))->find();
            $this->uid = $this->userInfo['uid'];
            $this->power = $this->userInfo['power'];
            if($this->userInfo['vipenddate'] >= date("Y-m-d")){
                $this->vip = true;
            }
            //获取消息列表
            $msglist = Db::name('msglist')->where(['uid'=>$this->userInfo['uid'],'zt'=>0])->order("addtime DESC")->limit(5)->select();
            $msg_num = count($msglist);
            if ($msg_num == 0){
                $msg_num = null;
            }
            $this->assign(['msglist'=>$msglist,'msg_num'=>$msg_num]);
        }
        $this->assign('alert','');
        $this->assign('userinfo',$this->userInfo);
        define('S_YB', config('zz_specialrmb_name') ? : '金币');
    }
    
    private function load_webconfigs(){
        //加载主站配置
        $zz_configs = Db::name('configs')->select();
        foreach($zz_configs as $row){
            config("zz_{$row['k']}",$row['v']);
        }
        
        
        //加载当前站点配置
        if($web = Db::name('weblist')->whereor(['domain'=>$_SERVER['HTTP_HOST'],'domain2'=>$_SERVER['HTTP_HOST']])->find()){
            define('ZID',$web['zid']);
            foreach($web as $key=>$val){
                config("web_{$key}",$val);
            }
        }else{
            $this->assign('alert',sweetAlert('该站为开通','此站未开通','warning','http://'.config('zz_domain')));
            exit($this->fetch('common/sweetalert'));
        }
        
        //获取客服QQ
        $kfqqs = explode('|',config('web_kfqq'));
        $this->assign('kfqqs',$kfqqs);
        //检查是否到期
        if (ZID != 1 && strtotime($web['enddate']) < time()){
            if(config('zz_fz_auto')){
                if($urow = Db::name('users')->where(['uid'=>$web['uid'],'power'=>9])->find()){
                    $fzprice = Db::name('weblist')->field('fzprice')->where(['zid'=>config('web_upzid')])->find();
                    $money = config("zz_auto_xffz_price") ? : 999;
                    if($urow['money'] >= $money){
                        if(Db::name('users')->where(['uid'=>$web['uid'],'zid'=>ZID,'power'=>9])->update(['money'=>$urow['money']-$money])){
                            $enddate = date("Y-m-d H:i:s",strtotime("+ 1 months",time()));
                            Db::name('weblist')->where(['zid'=>ZID])->update(['enddate'=>$enddate]);
                            $this->assign('alert',sweetAlert('续费成功','自动续费站点成功！','success','http://'.config('web_domain')));
                            exit($this->fetch('common/sweetalert'));
                        }
                    }
                }
            }
            $this->assign('alert',sweetAlert('站点已到期','请站长联系QQ：'.config('zz_qq').'续费！','warning','http://'.config('zz_domain')));
            exit($this->fetch('common/sweetalert'));
        }
        if(ZID !=1 && $web['stop'] == 1){
            $this->assign('alert',sweetAlert('站点被封禁','请站长联系QQ：'.config('zz_qq').'解封！','warning','http://'.config('zz_domain')));
            exit($this->fetch('common/sweetalert'));
        }
        //获取当前站点数据
        if(ZID != 1){
            $this->all_qqs = Db::name('qqs')->where(['zid'=>ZID])->count();
            $this->all_fz = Db::name('weblist')->where(['upzid'=>ZID])->count();
        }
        //获取邮箱信息,并保存到另外一个数组变量
        $this->mail_configs = [
            'port'  =>  config('zz_mail_port'),
            'host'  =>  config('zz_mail_host'),
            'username'  => config('zz_mail_user'),
            'password'  =>  config('zz_mail_pass'),
            'nick'  =>  config('web_webname'),
            
        ];
        
        if (ZID != 1)
        {
            //加载总站信息配置
            $web = Db::name('weblist')->whereor(['zid'=>1])->find();
            foreach($web as $key=>$val){
                config("zon_{$key}",$val);
            }
        } else {
            foreach($web as $key=>$val){
                config("zon_{$key}",$val);
            }
        }

    }
    
    //腾讯反检测
    function txprotect()
    {
        //IP屏蔽
        $iptables='977012992~977013247|977084416~977084927|1743654912~1743655935|1949957632~1949958143|2006126336~2006127359|2111446272~2111446527|3418570752~3418578943|3419242496~3419250687|3419250688~3419275263|3682941952~3682942207|3682942464~3682942719|3682986660~3682986663|1707474944~1707606015';
        $remoteiplong=bindec(decbin(ip2long($this->real_ip())));
        foreach(explode('|',$iptables) as $iprows){
            $ipbanrange=explode('~',$iprows);
            if($remoteiplong>=$ipbanrange[0] && $remoteiplong<=$ipbanrange[1])
                exit('欢迎使用！');
        }
        //HEADER特征屏蔽
        if(preg_match("/manager/", strtolower($_SERVER['HTTP_USER_AGENT'])) || strpos($_SERVER['HTTP_ACCEPT_LANGUAGE'], 'en')!==false && strpos($_SERVER['HTTP_ACCEPT_LANGUAGE'], 'zh')===false || strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone')!==false && strpos($_SERVER['HTTP_USER_AGENT'], 'en-')!==false && strpos($_SERVER['HTTP_USER_AGENT'], 'zh')===false || preg_match("/Windows NT 6.1/", $_SERVER['HTTP_USER_AGENT']) && $_SERVER['HTTP_ACCEPT']=='*/*' || preg_match("/Windows NT 5.1/", $_SERVER['HTTP_USER_AGENT']) && $_SERVER['HTTP_ACCEPT']=='*/*' || preg_match("/vnd.wap.wml/", $_SERVER['HTTP_ACCEPT']) && preg_match("/Windows NT 5.1/", $_SERVER['HTTP_USER_AGENT']) || strpos($_SERVER['HTTP_REFERER'], 'urls.tr.com')!==false || isset($_COOKIE['ASPSESSIONIDQASBQDRC']) || empty($_SERVER['HTTP_USER_AGENT'])) {
            exit('欢迎使用！');
        }
    }
    
    function real_ip()
    {
        $ip = $_SERVER['REMOTE_ADDR'];
        if (isset($_SERVER['HTTP_CLIENT_IP']) && preg_match('/^([0-9]{1,3}\\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && preg_match_all('#\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}#s', $_SERVER['HTTP_X_FORWARDED_FOR'], $matches)) {
            foreach ($matches[0] as $xip) {
                if (!preg_match('#^(10|172\\.16|192\\.168)\\.#', $xip)) {
                    $ip = $xip;
                    break;
                }
            }
        } elseif (isset($_SERVER['HTTP_CF_CONNECTING_IP']) && preg_match('/^([0-9]{1,3}\\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CF_CONNECTING_IP'])) {
            $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
        } elseif (isset($_SERVER['HTTP_X_REAL_IP']) && preg_match('/^([0-9]{1,3}\\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_X_REAL_IP'])) {
            $ip = $_SERVER['HTTP_X_REAL_IP'];
        }
        return $ip;
    }
    
    function addIp($ip)
    {
        $date = date("Y-m-d");
        $time = date("Y-m-d H:i:s");
        if (!Db::name('ips')->where(['zid'=>ZID,'date'=>$date,'ip'=>$ip])->find())
        {
            Db::name('ips')->insert([
                'zid'   =>  ZID,
                'date'  =>  $date,
                'time'  =>  $time,
                'ip'    =>  $ip,
            ]);
        }
    }
    
    function cleanIp()
    {
        //清理昨天前的来访IP
        $date = date("Y-m-d",strtotime('- 1 days'));
        Db::name("ips")->where(['date'=>$date,'zid'=>ZID])->delete();
    }
    
}
