<?php 
namespace app\index\controller;
use think\Db;

class Alipay extends Common
{
    var $alipay_config;
    //在类初始化方法中，引入相关类库
    public function __construct() {
        parent :: __construct();
        Vendor('Alipay.Alimd5function');
        Vendor('Alipay.Corefunction');
        Vendor('Alipay.Alipayconfig');
        Vendor('Alipay.Alinotify');
        Vendor('Alipay.Alisubmit');
        $type = input('type/d',0);
        if ($type == 0){
            $this->alipay_config = [
                'partner' => config('web_alipay_pid'),
                'seller_email' => config('web_alipay_account'),
                'key'=>config('web_alipay_key'),
                'sign_type'=>strtoupper('MD5'),
                'input_charset'=>strtolower('utf-8'),
                'cacert'=>AliPay_PATH.'cacert.pem',
                'transport'=>'http'
            ];
        } else {
            $this->alipay_config = [
                'partner' => config('zon_alipay_pid'),
                'seller_email' => config('zon_alipay_account'),
                'key'=>config('zon_alipay_key'),
                'sign_type'=>strtoupper('MD5'),
                'input_charset'=>strtolower('utf-8'),
                'cacert'=>AliPay_PATH.'cacert.pem',
                'transport'=>'http'
            ];
        }
    }
    
    public function Alipay_return(){
        $alipayNotify = new \AlipayNotify($this->alipay_config);
        $verify_result = $alipayNotify->verifyReturn();
        if($verify_result) {
            //商户订单号
        
            $out_trade_no = input('get.out_trade_no');
        
            //支付宝交易号
        
            $trade_no = input('get.trade_no');
        
            //交易状态
            $trade_status = input('get.trade_status');
        
            $srow = Db::name('pay')->where(['orderid'=>$out_trade_no])->find();
            $data = [
                'type'=>'alipay',
                'orderid'=>$out_trade_no,
                'trade_no'=>$trade_no,
                'time'=>date("Y-m-d H:i:S"),
                'name'=>$srow['name'],
                'money'=>$srow['money'],
                'status'=>2,
                'zid'=>ZID,
            ];
            
        
            if($trade_status == 'TRADE_FINISHED' || $trade_status == 'TRADE_SUCCESS') {
                if($srow['status']==0){
                    Db::name('order')->insert($data);
                    Db::name('pay')->where(['orderid'=>$out_trade_no])->update(['status'=>2,'endtime'=>date("Y-m-d H:i:s")]);
                    if ($srow['mtype'] == 0){
                        Db::name('users')->where(['uid'=>$srow['uid']])->setInc('money',$srow['money']);
                    } else if ($srow['mtype'] == 1)
                    {
                        Db::name('users')->where(['uid'=>$srow['uid']])->setInc('yb',$srow['money']);
                    }
                }else{
                    $this->assign('alert',sweetAlert('温馨提示','您充值的余额已到账，感谢您的购买','success',url('main/index')));
                    exit($this->fetch('common/sweetalert'));
                }
                $this->assign('alert',sweetAlert('温馨提示','支付成功,请到资金明细中查看','success',url('main/index')));
                exit($this->fetch('common/sweetalert'));
            }
            else {
                return "trade_status=".$trade_status;
            }
        }
        else {
            //验证失败
            //showmsg('验证失败！',4,'shop');
            $this->assign('alert',sweetAlert('温馨提示','验证失败','warning',url('main/index')));
            exit($this->fetch('common/sweetalert'));
        }
    }
    public function Alipay_notify(){
        $alipayNotify = new \AlipayNotify($this->alipay_config);
        $verify_result = $alipayNotify->verifyNotify();
        if($verify_result) {
            //商户订单号
    
            $out_trade_no = input('post.out_trade_no');
    
            //支付宝交易号
    
            $trade_no = input('post.trade_no');
    
            //交易状态
            $trade_status = input('post.trade_status');
    
            $srow = Db::name('pay')->where(['orderid'=>$out_trade_no])->find();
            $data = [
                'type'=>'alipay',
                'orderid'=>$out_trade_no,
                'trade_no'=>$trade_no,
                'time'=>date("Y-m-d H:i:S"),
                'name'=>$srow['name'],
                'money'=>$srow['money'],
                'status'=>2,
                'zid'=>ZID,
            ];
            Db::name('order')->insert($data);
            
            if ($trade_status == 'TRADE_FINISHED') {
                //退款日期超过可退款期限后（如三个月可退款），支付宝系统发送该交易状态通知
            } else if ($trade_status == 'TRADE_SUCCESS' && $srow['status']==0){
                //付款完成后，支付宝系统发送该交易状态通知
                Db::name('pay')->where(['orderid'=>$out_trade_no])->update(['status'=>2,'endtime'=>date("Y-m-d H:i:s")]);
                if ($srow['mtype'] == 0){
                    Db::name('users')->where(['uid'=>$srow['uid']])->setInc('money',$srow['money']);
                } else if ($srow['mtype'] == 1)
                {
                    Db::name('users')->where(['uid'=>$srow['uid']])->setInc('yb',$srow['money']);
                }
                
           }
           echo "success";
        } else {
            
          //验证失败
          echo "fail";
        }
    }
    
}