<?php
namespace app\index\controller;
use think\Db;
class Admin extends Common
{
    function __construct(){
        parent::__construct();
        //判断是否已登录
        if (empty($this->userInfo) || $this->userInfo['power'] != 9 || $this->userInfo['zid'] != ZID || config('web_uid') != $this->uid) {
            $this->assign('alert', sweetAlert('无权限', '无权限！', 'warning', url('main/index')));
            exit($this->fetch('common/sweetalert'));
        }
    }
    public function epayorders()
    {
        if (!config('web_epay_pid') || !config('web_epay_key'))
        {
            $this->assign('alert', sweetAlert('请先初始化', '请先初始化易支付账户', 'warning', url('epayset')));
            exit($this->fetch('common/sweetalert'));
        }
        $json = get_curl('http://pay.walpay.cn/api.php?act=orders&limit=50&pid=' . config('web_epay_pid') . '&key=' . config('web_epay_key'));
        $data = json_decode($json,true);
        if ($data['code'] != 1)
        {
            $this->assign('alert', sweetAlert('查询失败', '获取交易记录失败！', 'warning', url('epayset')));
            exit($this->fetch('common/sweetalert'));
        }
        $this->assign('list',$data['data']);
        return $this->fetch();    
    }
    
    
    public function addweb()
    {
        if (!config('zz_fzhz'))
        {
            $this->assign('alert',sweetAlert('警告','站长还没有配置好分站信息，无法开通!','warning',url('index')));
            exit($this->fetch('common/sweetalert'));
        }
        if(ZID != 1 && $this->all_fz >= config('web_fzpeie')){
            $this->assign('alert',sweetAlert('警告','你的分站配额已达上限，请增加配额！','warning',url('index')));
            exit($this->fetch('common/sweetalert'));
        }
        if(IS_POST){
            $uid = input('post.uid/d',0);
            //$month = input('post.month/d') ? daddslashes(input('post.month/d')) : 1;
            $qz = daddslashes(input('post.fzqz'));
            $name = daddslashes(input('post.name'));
            $qq = daddslashes(input('post.qq'));
            $url = $qz.".".config('zz_fzhz');
            $money = (config('zz_fzprice_month') + config('web_fzprice'));
            if($this->userInfo['yb'] < $money && ZID != 1){
                $this->assign('alert',sweetAlert('警告',S_YB . '不足','warning',url('index/shop')));
                exit($this->fetch('common/sweetalert'));
            } else if($qz == NUll || $name == NULL || $qq == NULL){
                $this->assign('alert',sweetAlert('警告','参数错误','warning',url('addweb')));
                exit($this->fetch('common/sweetalert'));
            } else if(!Db::name('users')->where(['uid'=>$uid,'zid'=>ZID])->find()){
                $this->assign('alert',sweetAlert('警告','用户不存在','warning',url('addweb')));
                exit($this->fetch('common/sweetalert'));
            } else if(!preg_match('/^[1-9][0-9]{4,9}$/', $qq)){
                $this->assign('alert',sweetAlert('警告','QQ号格式错误','warning',url('addweb')));
                exit($this->fetch('common/sweetalert'));
            } else if(Db::name('weblist')->whereor(['domain'=>$url,'domain2'=>$url])->find()){
                $this->assign('alert',sweetAlert('警告','前缀已被他人使用','warning',url('addweb')));
                exit($this->fetch('common/sweetalert'));
            } else {
                $enddate = date("Y-m-d",strtotime("+ 1 months",time()));
                config('zz_peie') ? $peie = config('zz_peie') : $peie = 200;
                config('zz_fzpeie') ? $fzpeie = config('zz_fzpeie') : $fzpeie = 50;
                $data = [
                    'domain'=>$url,
                    'webname'=>$name,
                    'kfqq'=>$qq,
                    'adddate'=>date("Y-m-d"),
                    'enddate'=>$enddate,
                    'upzid'=>ZID,
                    'uid'=>$uid,
                    'peie'=>$peie,
                    'fzpeie'=>$fzpeie
        
                ];
                if(Db::name('weblist')->insert($data)){
                    $zid = Db::getLastInsID();
                    Db::name('users')->where(['uid'=>$uid])->update([
                        'power'=>9,
                        'zid'=>$zid
        
                    ]);
                    if (ZID != 1){
                        Db::name('users')->where(['uid'=>$this->uid])->setDec('yb',$money);
                    }
                    $this->assign('alert',sweetAlert('温馨提示','开通成功','success',"http://".$url));
                } else {
                    $this->assign('alert',sweetAlert('警告','开通失败，请联系管理员','warning',url('addweb')));
                    exit($this->fetch('common/sweetalert'));
                }
            }
             
        }
        $this->assign('all_fz',$this->all_fz);
        return $this->fetch();
    }
    
    public function index(){
        $fzprice = Db::name('weblist')->field('fzprice')->where(['zid'=>config('web_upzid')])->find();
        $money = config('zz_auto_xffz_price') ? : 1;
        $pmoney = config('zz_fzprice_num') ? : 1;
        if (config('zon_payapi') == 2){
            $PayTypeArr = [
                'alipay',
                'qqpay',
                'wxpay'
            ];
        } else {
            $PayTypeArr = [
                'alipay',
            ];
        }
        if(IS_POST && ZID != 1){
            $do = input('do');
            if ($do == 'delay'){
                $month = input('post.month/d',1);
                if($month < 0){
                    $month = 1;
                }
                $need_money = $money * $month;
                if($this->userInfo['yb'] < $need_money){
                    $this->assign('alert', sweetAlert('余额不足', S_YB . '不足！', 'warning', url('main/shop')));
                    exit($this->fetch('common/sweetalert'));
                } else {
                    $enddate = date("Y-m-d",strtotime("+ {$month} months",strtotime(config('web_enddate'))));
                    if(Db::name('users')->where(['zid'=>ZID,'uid'=>$this->uid])->update(['yb'=>$this->userInfo['yb']-$need_money]) && Db::name('weblist')->where(['zid'=>ZID])->update(['enddate'=>$enddate])){
                        $msg = '';
                        if (config('zz_admin_xf_zspeie') > 0)
                        {
                            $msg = '同时赠送您' . config('zz_admin_xf_zspeie') . '个分站配额';
                            Db::name('weblist')->where(['zid'=>ZID])->setInc('fzpeie',config('zz_admin_xf_zspeie'));
                        }
                        $this->assign('alert', sweetAlert('温馨提示', '成功续费'.$month.'个月！' . $msg, 'success',url('index')));
                    } else {
                        $this->assign('alert', sweetAlert('Error', '续费失败！', 'warning', url('index')));
                        exit($this->fetch('common/sweetalert'));
                    }
                    
                }
            } else if ($do == 'plus')
            {
                $num = input('post.num/d',1);
                if ($num < 0)
                {
                    $num = 1;
                }
                $need_money = $pmoney * $num;
                if($this->userInfo['yb'] < $need_money){
                    $this->assign('alert', sweetAlert('余额不足', S_YB . '不足！', 'warning', url('main/shop')));
                    exit($this->fetch('common/sweetalert'));
                } else {
                    if(Db::name('users')->where(['zid'=>ZID,'uid'=>$this->uid])->update(['yb'=>$this->userInfo['yb']-$need_money]) && Db::name('weblist')->where(['zid'=>ZID])->setInc('fzpeie',$num)){
                        $this->assign('alert', sweetAlert('温馨提示', '成功购买'.$num.'个分站配额！', 'success',url('index')));
                    } else {
                        $this->assign('alert', sweetAlert('Error', '购买失败！', 'warning', url('index')));
                        exit($this->fetch('common/sweetalert'));
                    }
                }
            } else if ($do == 'pay' && input('post.money') != NULL && config('zon_payapi') > 0)
            {
                Vendor('Alipay.Alimd5function');
                Vendor('Alipay.Corefunction');
                if (config('zon_paypai') == 1){
                    Vendor('Alipay.Alipayconfig');
                    Vendor('Alipay.Alinotify');
                    Vendor('Alipay.Alisubmit');
                }   else if (config('zon_payapi') == 2){
                    Vendor('Epay.Epayconfig');
                    Vendor('Epay.Epaynotify');
                    Vendor('Epay.Epaysubmit');
                }
                //$type = ['1'=>'alipay','2'=>'epay'];
                $money = daddslashes(input('money'));
                if(!is_numeric($money) || $money <= 0){
                    $this->assign('alert',sweetAlert('警告','参数错误','warning',url()));
                    exit($this->fetch('common/sweetalert'));
                }
                $PayType = input('?post.type') ? input('post.type') : "alipay";
                if (!empty($PayType)){
                    if (!in_array($PayType,$PayTypeArr)){
                        $this->assign('alert',sweetAlert('警告','参数错误','warning',url()));
                        exit($this->fetch('common/sweetalert'));
                    }
                }
                
                $orderid=date("YmdHis").rand(111,999);
                $PayRow = [
                    'name'=>config('web_webname').'-用户ID:'.$this->uid.'充值'.$money."元" . S_YB,
                    'money'=>$money
                ];
                $data = [
                    'uid'=>$this->uid,
                    'type'=>$PayType,
                    'orderid'=>$orderid,
                    'addtime'=>date("Y-m-d H:i:s"),
                    'name'=>$PayRow['name'],
                    'money'=>$PayRow['money'],
                    'status'=>0,
                    'zid'=>1,
                    'mtype'=>1,
                ];
                if(Db::name('pay')->insert($data)){
                    exit(pay($orderid,$PayRow['name'],$PayRow['money'],$PayType,1));
                } else {
                    $this->assign('alert',sweetAlert('警告','订单生成失败','warning',url()));
                    exit($this->fetch('common/sweetalert'));
                }
            }
        }
        //本站统计
        $data = [
            'ip'    =>  Db::name('ips')->where(['zid'=>ZID,'date'=>date("Y-m-d")])->count(),
            'user'  =>  Db::name('users')->where('TO_DAYS(regtime)=TO_DAYS(NOW())')->where(['zid'=>ZID])->count(),
            'qq'    =>  Db::name('qqs')->where('TO_DAYS(addtime)=TO_DAYS(NOW())')->where(['zid'=>ZID])->count(),
            'vip'   =>  Db::name('users')->where('TO_DAYS(regtime)=TO_DAYS(NOW()) and vipenddate > CURDATE()')->where(['zid'=>ZID])->count()
        ];
        $this->assign('all_fz',$this->all_fz);
        $this->assign('money',$money);
        $this->assign('pmoney',$pmoney);
        $this->assign('data',$data);
        $this->assign('paytype',$PayTypeArr);
        $this->assign('paytypename',['alipay'=>'支付宝','qqpay'=>'QQ钱包','wxpay'=>'微信']);
        return $this->fetch();
    }
    public function qqlist(){
        $search = '';
        $act = input('do');
        $where = '';
        if (ZID != 1)
        {
            $where = ['zid'=>ZID];
        }
        if($act == "del"){
            $uin = input('uin/d');
            if(Db::name('qqs')->where(array('qq'=>$uin))->where($where)->delete()){
                $this->assign('alert',sweetAlert('温馨提示', 'QQ删除成功', 'success'));
            } else {
                $this->assign('alert',sweetAlert('温馨提示', 'QQ删除失败', 'warning'));
            }
        } else if ($act == "search"){
            $search = ['qid|qq'=>['like','%'.input('get.query').'%']];
        }
        $list = Db::name('qqs')->where($where)->where($search)->order('qid DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('active','qqlist');
        return $this->fetch();
    }
    public function ulist(){
        $search = '';
        $act = input('do');
        $where = '';
        if (ZID != 1)
        {
            $where = ['zid'=>ZID];
        }
        if($act == "del"){
            $uid = input('uid/d');
            if($uid == $this->uid){
                $uid = 0;
            }
            if(Db::name('users')->where(['uid'=>$uid])->where($where)->delete()){
                $this->assign('alert',sweetAlert('温馨提示', '用户删除成功', 'success'));
            } else {
                $this->assign('alert',sweetAlert('温馨提示', '用户删除失败', 'warning'));
            }
        } else if ($act == "search"){
            $search = ['uid|user'=>['like','%'.input('get.query').'%']];
        }
        $list = Db::name('users')->where($where)->where($search)->order("uid DESC")->paginate(10);
        $this->assign('list',$list);
        return $this->fetch();
    }
    public function zzset() {
        if(ZID != 1){
            $this->assign('alert', sweetAlert('无权限', '无权限！', 'warning', url('main/index')));
            exit($this->fetch('common/sweetalert'));
        }
        if(IS_POST){
            foreach(input('post.') as $k=>$value){
                Db::execute("INSERT INTO ".$this->database['prefix']."configs SET k='" . daddslashes($k) . "',v='" . daddslashes($value) . "' ON DUPLICATE KEY UPDATE v='" . daddslashes($value) . "'");
            }
            $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('zzset')));
        }
        //$this->assign('cronapi',$apilist);
        return $this->fetch();
    }
   public function webset() {
        $bgurl = "/assets/Index/images/banner".ZID.".png";
        if (!file_exists(__DIR__ . "/../../.." . $bgurl)){
            $bgurl = "/assets/Index/images/banner1.jpg";
        }
        if(IS_POST){
           if ($file = request()->file('background')){
                if(!$file->check(['ext'=>'png'])){
                    $this->assign('alert',sweetAlert('温馨提示','图片格式错误','warning',url('webset')));
                    exit($this->fetch('common/sweetalert'));
                }
                if ($file->getSize() > 3000000){
                    $this->assign('alert',sweetAlert('温馨提示','图片太大了','warning',url('webset')));
                    exit($this->fetch('common/sweetalert'));
                }
                $info = $file->move(ROOT_PATH . 'assets/Index/' . DS . 'images','banner'.ZID.'.png');
            }
            foreach(input('post.') as $k=>$value){
                if ($k == 'domain2')
                {
                    if (Db::name('weblist')->where(['domain'=>$value,'domain2'=>$value])->find())
                    {
                        continue;
                    }
                }
                Db::name('weblist')->where(['zid'=>ZID])->update([$k=>$value]);
            }
            $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('webset')));
        }
        $this->assign('bgurl',$bgurl);
        return $this->fetch();
    }
	   public function qiandao() {
        $bgurl = "/assets/Index/images/banner".ZID.".png";
        if (!file_exists(__DIR__ . "/../../.." . $bgurl)){
            $bgurl = "/assets/Index/images/banner1.jpg";
        }
        if(IS_POST){
           if ($file = request()->file('background')){
                if(!$file->check(['ext'=>'png'])){
                    $this->assign('alert',sweetAlert('温馨提示','图片格式错误','warning',url('webset')));
                    exit($this->fetch('common/sweetalert'));
                }
                if ($file->getSize() > 3000000){
                    $this->assign('alert',sweetAlert('温馨提示','图片太大了','warning',url('webset')));
                    exit($this->fetch('common/sweetalert'));
                }
                $info = $file->move(ROOT_PATH . 'assets/Index/' . DS . 'images','banner'.ZID.'.png');
            }
            foreach(input('post.') as $k=>$value){
                if ($k == 'domain2')
                {
                    if (Db::name('weblist')->where(['domain'=>$value,'domain2'=>$value])->find())
                    {
                        continue;
                    }
                }
                Db::name('weblist')->where(['zid'=>ZID])->update([$k=>$value]);
            }
            $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('qiandao')));
        }
        $this->assign('bgurl',$bgurl);
        return $this->fetch();
    }
    public function kmlist(){
        $do = input('do');
        $kmmsg = '';
        $search = '';
        if($do == "addkm"){
            $num = daddslashes(input('post.num/d'));
            $val = daddslashes(input('post.val/d'));
            $kind = daddslashes(input('post.type/d'));
            if ($kind == -1)
            {
                $this->assign('alert', sweetAlert('温馨提示', '请选择卡密类型', 'warning',url('kmlist')));
                exit($this->fetch('common/sweetalert'));
            }
            if($num <= 0 || $val <= 0 || $kind < 0 || $kind > 3){
                $this->assign('alert', sweetAlert('温馨提示', '参数错误', 'warning',url('kmlist')));
                exit($this->fetch('common/sweetalert'));
            }
            $t = 1;
            if ($kind == 0)
            {
                $t = config('zz_fzz_vipdprice') ? : 999;
            } else if ($kind == 2)
            {
                $t = config('zz_fzz_peieprice') ? : 999;
            } else if ($kind == 3)
            {
                $t = config('zz_fzz_vipprice') ? : 999;
            }
            $need_money = $num * $val * $t;
            if(config('web_fzneed') == 1 && $this->userInfo['money'] < $need_money && ZID != 1){
                $this->assign('alert', sweetAlert('温馨提示', '余额不足', 'warning',url('main/kmcz')));
                exit($this->fetch('common/sweetalert'));
            } 
            if(config('web_fzneed') == 1 && ZID != 1){
                Db::name('users')->where(['zid'=>ZID,'uid'=>$this->uid])->update(['money'=>$this->userInfo['money']-$need_money]);
            }
            for($i=0;$i<$num;$i++){
                $km=getRandStr();
                $data[] = ['type'=>$kind,'km'=>$km,'value'=>$val,'addtime'=>date("Y-m-d H:i:s"),'zid'=>ZID];
                $kmmsg.="<li class='list-group-item'>{$km}</li>";
            }
            //分批写入 每次1000条
            $data = array_chunk($data,1000);
            foreach ($data as $datas){
                Db::name('kms')->insertAll($datas);
            }
            
        } else if($do == "cleanall"){
            Db::name('kms')->where(['zid'=>ZID])->where('useid','<>','0')->delete();
            $this->assign('alert', sweetAlert('温馨提示', '清空成功', 'success',url('kmlist')));
        } else if($do == "del"){
            $id = daddslashes(input('id/d'));
            if(Db::name('kms')->where(['kid'=>$id,'zid'=>ZID])->delete()){
                $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success',url('kmlist')));
            } else {
                $this->assign('alert', sweetAlert('温馨提示', '删除失败', 'warning'));
            }
        } else if ($do == "search"){
            $search = ['km'=>['like','%'.input('get.query').'%']];
        }
        $list = Db::name('kms')->where(['zid'=>ZID])->where($search)->order('kid DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('kmmsg',$kmmsg);
        return $this->fetch();
    }
    public function paylist() {
        $where = ['zid'=>ZID];
        $list = Db::name('pay')->where($where)->order('id DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('zt',$zt = ['2'=>'<font color=green>交易成功</font>','1'=>'<font color=green>交易成功</font>','0'=>'<font color=red>交易失败</font>']);
        return $this->fetch();
    }
    public function orderlist(){
        $where = ['zid'=>ZID];
        $list = Db::name('order')->where($where)->order('time DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('zt',$zt = ['2'=>'<font color=green>交易成功</font>','1'=>'<font color=green>交易成功</font>','0'=>'<font color=red>交易失败</font>']);
        return $this->fetch();
    }
    public function gglist() {
        
        if(input('type') == "all" && ZID == 1){
            $where = 1;
            $this->assign('all',true);
        } else {
            $where = ['zid'=>ZID];
            $this->assign('all',false);
        }
        if(input('do') == "del"){
            $id = input('id/d');
            if(Db::name('ggs')->where(['id'=>$id])->where($where)->delete()){
                $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success'));
            } else {
                $this->assign('alert', sweetAlert('温馨提示', '删除失败', 'warning',url('gglist')));
                exit($this->fetch('common/sweetalert'));
            }
        }
        
        $list = Db::name('ggs')->where($where)->order('addtime DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('imp',$imp = ['1'=>'<font color=red>重要公告</font>','0'=>'普通公告']);
        return $this->fetch();
    }
    public function addgg() {
        $do = input('do');
        $this->assign('do','');
        $this->assign('id','');
        $this->assign('gginfo',['name'=>'','value'=>'','imp'=>0]);
        if($do == "add"){
            $name = daddslashes(input('post.name'));
            $value = daddslashes(input('post.gg'));
            $imp = input('post.imp/d');
            if($imp < 0)  $imp = 0;
            if($imp > 1)  $imp = 1;
            if($name == NULL || $value == NULL){
                return $this->error('名称或内容不能为空',url('addgg'));
            }
            $data = [
                'name'=>$name,
                'value'=>$value,
                'imp'=>$imp,
                'addtime'=>date('Y-m-d H:i:s'),
                'zid'=>ZID
                
            ];
            if(Db::name('ggs')->insert($data)){
                $this->assign('alert', sweetAlert('温馨提示', '添加成功', 'success',url('gglist')));
            } else {
                $this->assign('alert', sweetAlert('温馨提示', '添加失败', 'warning',url('addgg')));
                exit($this->fetch('common/sweetalert'));
            }
        } else if($do == "edit"){
            $id = input('id/d');
            if(ZID == 1){
                $where = ['id'=>$id];
            } else {
                $where = ['id'=>$id,'zid'=>ZID];
            }
            if(!$gginfo = Db::name('ggs')->where($where)->find()){
                $this->assign('alert', sweetAlert('温馨提示', '不存在', 'warning',url('gglist')));
                exit($this->fetch('common/sweetalert'));
            }   elseif(IS_POST){
                $name = daddslashes(input('post.name'));
                $value = daddslashes(input('post.gg'));
                $imp = input('post.imp/d');
                Db::name('ggs')->where(['zid'=>ZID,'id'=>$id])->update(['name'=>$name,'value'=>$value,'imp'=>$imp]);
                $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('gglist')));
            }
            $this->assign('id',$id);
            $this->assign('do','edit');
            $this->assign('gginfo',$gginfo);
        }
        return $this->fetch();
    }
    public function weblist(){
        $where = '';
        if (ZID != 1){
            $where = ['upzid'=>ZID];
        }
        if(input('do') == "del"){
            $id = input('id/d');
            if(Db::name('weblist')->where(['zid'=>$id])->where($where)->delete()){
                Db::name('users')->where(['zid'=>$id])->update(['power'=>0,'zid'=>ZID]);
                $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success'));
            } else {
                $this->assign('alert', sweetAlert('温馨提示', '删除失败', 'warning',url('weblist')));
                exit($this->fetch('common/sweetalert'));
            }
        }
        if(ZID == 1){
            $where = '';
        } else {
            $where  = ['upzid'=>ZID];
        }
        $list = Db::name('weblist')->where($where)->where('zid','<>','1')->order('zid DESC')->paginate(10);
        $this->assign('list',$list);
        return $this->fetch();
    }
    public function web() {
        $id = input('id/d');
        $do = input('do');
        if(ZID == 1){
            $where = '';
        } else {
            $where  = ['upzid'=>ZID];
        }
        if(empty($id) || $id == 1){
            $this->assign('alert', sweetAlert('温馨提示', '参数错误', 'warning',url('weblist')));
            exit($this->fetch('common/sweetalert'));
        } else if(!$WebRow = Db::name('weblist')->where($where)->where(['zid'=>$id])->find()){
            $this->assign('alert', sweetAlert('温馨提示', '不存在', 'warning',url('weblist')));
            exit($this->fetch('common/sweetalert'));
        }
        if(IS_POST && $do == "save"){
            foreach(input('post.') as $k=>$value){
                if (($k == "enddate" || $k == "fzneed" || $k == "stop" || $k == "fzpeie" || $k == "peie") && ZID != 1 ){
                    $this->assign('alert', sweetAlert('温馨提示', '无权限', 'warning',url('weblist')));
                    exit($this->fetch('common/sweetalert'));
                }
                Db::name('weblist')->where(['zid'=>$id])->update([$k=>$value]);
            }
            $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('web',['id'=>$id])));
            
        }
        $this->assign('webinfo',$WebRow);
        return $this->fetch();
    }
    public function cronlist() {
        if(ZID != 1){
            $this->assign('alert', sweetAlert('无权限', '无权限！', 'warning', url('main/index')));
            exit($this->fetch('common/sweetalert'));
        }
        return $this->fetch();
        
    }
    public function uedit() {
        $do = input('do');
        $uid =  input('uid/d');
        if(ZID == 1){
            $where = '';
        } else {
            $where = ['zid'=>ZID];
        }
        if((!$urow = Db::name('users')->where(['uid'=>$uid])->where($where)->find()) || $uid == $this->uid){
            $this->assign('alert', sweetAlert('温馨提示', '用户不存在', 'warning',url('ulist')));
            exit($this->fetch('common/sweetalert'));
        } else {
            if(IS_POST){
                if(!input('pass')){
                    $pass = $urow['pass'];
                } else {
                    $pass = input('pass');
                }
                if(input('money/d') < 0){
                    $this->assign('alert', sweetAlert('温馨提示', '余额格式错误', 'warning',url('uedit',['do'=>'edit','uid'=>$uid])));
                    exit($this->fetch('common/sweetalert'));
                }
                $yb = $urow['yb'];
                if (ZID == 1)
                {
                    $yb = input('post.yb/^[0-9]+(.[0-9]{1,2})?$/');
                }
                if(Db::name('users')->where(['uid'=>$uid])->where($where)->update(['pass'=>$pass,'money'=>input('post.money/^[0-9]+(.[0-9]{1,2})?$/'),'yb'=>$yb])){
                    $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success'));
                } else {
                    $this->assign('alert', sweetAlert('温馨提示', '修改失败', 'warning',url('uedit',['do'=>'edit','uid'=>$uid])));
                   // exit($this->fetch('common/sweetalert'));
                }
            }
            $urow = Db::name('users')->where(['uid'=>$uid])->where($where)->where("`uid` <> ".$this->uid)->find();
            $this->assign('userrow',$urow);
        }
        return $this->fetch();
    }
    
    public function msglist()
    {
        if(input('type') == "all" && ZID == 1){
            $where = 1;
            $this->assign('all',true);
        } else {
            $where = ['zid'=>ZID];
            $this->assign('all',false);
        }
        $msgrow = NULL;
        if(input('do') == "del"){
            if (ZID == 1){
                $where = '';
            }
            $id = input('id/d');
            if(Db::name('msglist')->where(['id'=>$id])->where($where)->delete()){
                $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success'));
            } else {
                $this->assign('alert', sweetAlert('温馨提示', '删除失败', 'warning',url('msglist')));
                exit($this->fetch('common/sweetalert'));
            }
        } 

        $list = Db::name('msglist')->where($where)->order('addtime DESC')->paginate(10);
        $this->assign('list',$list);
        $this->assign('zt',['1'=>'<font color="green">已读</font>','0'=>'<font color="red">未读</font>']);
        $this->assign('msgrow',$msgrow);
        return $this->fetch();
    }
    
    public function msglook($id = 0)
    {
        if(ZID == 1){
            $where = 1;
        } else {
            $where = ['zid'=>ZID];
        }
        
        if (!$msgrow = Db::name('msglist')->where(['id'=>$id])->where($where)->find()){
            $this->assign('alert', sweetAlert('温馨提示', '此消息不存在', 'warning',url('msglist')));
            exit($this->fetch('common/sweetalert'));
        }
        
        $act = input('act');
        if ($act == "read"){
            Db::name('msglist')->where(['id'=>$id])->where($where)->update(['zt'=>1]);
            $this->assign('alert', sweetAlert('温馨提示', '标记为已读成功', 'warning',url('msglist')));
            exit($this->fetch('common/sweetalert'));
        } else if ($act == "noread"){
            Db::name('msglist')->where(['id'=>$id])->where($where)->update(['zt'=>0]);
            $this->assign('alert', sweetAlert('温馨提示', '标记为未读成功', 'warning',url('msglist')));
            exit($this->fetch('common/sweetalert'));
        }
        
        $this->assign('zt',['0'=>'未读','1'=>'已读']);
        $this->assign('msgrow',$msgrow);
        return $this->fetch();
    }
    
    public function addmsg()
    {
        
        if (IS_POST){
            if (ZID == 1){
                $where = '';
            } else {
                $where = ['zid'=>ZID];
            }
            $object = input('post.object');
            $isVip = false;
            $isNovip = false;
            if ($object == "vip"){
                $isVip = true;
            } else if($object == "novip") {
                $isNovip = true;
            } else if (!$rows = Db::name('users')->where(['uid'=>$object,'zid'=>ZID])->where($where)->find()){
                $this->assign('alert', sweetAlert('温馨提示', '此用户不存在', 'warning'));
                exit($this->fetch('common/sweetalert'));
            }
            $name = input('post.name');
            $value = input('post.value');
            if (!$name || !$value){
                $this->assign('alert', sweetAlert('温馨提示', '名称或内容不能为空!', 'warning',url('addmsg')));
                exit($this->fetch('common/sweetalert'));
            }
            if ($isVip == true){
                $rows = Db::name('users')->where('vipenddate','EGT',date("Y-m-d"))->where($where)->select();
                
            } else if ($isNovip == true) {
                $rows = Db::name('users')->where("`vipenddate` < :date OR `vipenddate` IS NULL")->where($where)->bind(['date'=>date("Y-m-d")])->select();
            }
            if ($isNovip == true || $isVip == true){
                foreach ($rows as $row){
                    Db::name('msglist')->insert([
                        'uid'=>$row['uid'],
                        'name'=>$name,
                        'value'=>$value,
                        'addtime'=>date("Y-m-d H:i:s"),
                        'qq'=>$this->userInfo['qq'],
                        'zid'=>ZID,
                        'zt'=>0
                    ]);
                }
            } else {
                Db::name('msglist')->insert([
                    'uid'=>$rows['uid'],
                    'name'=>$name,
                    'value'=>$value,
                    'addtime'=>date("Y-m-d H:i:s"),
                    'qq'=>$this->userInfo['qq'],
                    'zid'=>ZID,
                    'zt'=>0
                ]);
            }
            $this->assign('alert', sweetAlert('温馨提示', '推送成功!', 'success'));
        }
        return $this->fetch();    
    }
    
    function zipExtract ($src, $dest)
    {
        $zip = new \ZipArchive();
        if ($zip->open($src)===true)
        {
            $zip->extractTo($dest);
            $zip->close();
            return true;
        }
        return false;
    }
    
    
	public function update()
    {
		include './application/authcode.php';
        $query=file_get_contents('http://auth.79o.ren/check.php?url='.$_SERVER['HTTP_HOST'].'&authcode='.$authcode. '&ver=' . MHTG_VER);
        if($query=json_decode($query,true)) {
            $upcode = $query['code'];
            if ($upcode == 1){
                $upmsg = '<div class="list-group-item"><div class="list-group-item"><span>'.$query['msg'].'</span></div>
              <div class="list-group-item"><span> '.$query['uplog'].'</span></div>
	</div>
                </div>
                    <form action="' . url('update',['do'=>'update']) . '" method="post" >
                                <div class="list-group-item">
                        <button type="submit" class="btn btn-primary btn-block">立即更新</button>
                    </div>
                </form>
            </div>
        </div>';
            } else {           	            
                $upmsg = '<div class="list-group-item"><div class="list-group-item"><span>'.$query['msg'].'</span></div>';
            }
        } else { 
            $upmsg = '<div class="alert alert-danger">
                <h4>服务器未响应</h4>
                </div>';
        }
        if (IS_POST && input('do') == "update"){
            $url = $query['file'];
            $RemoteFile = $url;
            $ZipFile = "update.zip";
            copy($RemoteFile,$ZipFile) or exit("<script>alert('无法下载更新包文件{$url}');history.go(-1);</script>");
            if ($this->zipExtract($ZipFile,"./")) {
                $upmsg = "程序更新成功!";
                $upcode = 0;
                unlink($ZipFile);
            } else {
                $upmsg = "无法解压文件";
                $upcode = 0;
                if (file_exists($ZipFile))
                    unlink($ZipFile);
            }
        }
        $this->assign('msg',$upmsg);
        return $this->fetch();
    }
	
    
    public function alipayset()
    {
        if(IS_POST){
            foreach(input('post.') as $k=>$value){
                Db::name('weblist')->where(['zid'=>ZID])->update([$k=>$value]);
            }
            $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('alipayset')));
        }
        return $this->fetch();
    }
    
    public function epayset()
    {
        $noepay = false;
        $epay_settle = false;
        $arr['code'] = 0;
        //初始化账号
        $epay_pid = config('web_epay_pid');
        $epay_key = config('web_epay_key');
        
        //获取结算记录
        if (input('act') == "epay_settle"){
            $epay_settle = true;
            $data=get_curl('http://pay.walpay.cn/api.php?act=settle&pid='.config('web_epay_pid').'&key='.config('web_epay_key').'&limit=20&url='.$_SERVER['HTTP_HOST']);
            $arr=json_decode($data,true);
            if($arr['code']==-2) {
                $this->assign('alert', sweetAlert('温馨提示', '易支付KEY校验失败！', 'warning'));
                exit($this->fetch('common/sweetalert'));
            }
            $this->assign('rows',$arr['data']);
        }
        //初始化
        if(isset($epay_pid) && isset($epay_key)){
            $data=get_curl('http://pay.walpay.cn/api.php?act=query&pid='.config('web_epay_pid').'&key='.config('web_epay_key').'&url='.$_SERVER['HTTP_HOST']);
            $arr=json_decode($data,true);
            if($arr['code']==-2) {
                $this->assign('alert', sweetAlert('温馨提示', '易支付KEY校验失败！', 'warning'));
                //exit($this->fetch('common/sweetalert'));
            }
        }
        if($arr['code']==1) {
            if($arr['active']==0){
                $this->assign('alert', sweetAlert('温馨提示', '该商户已被封禁!', 'warning'));
                exit($this->fetch('common/sweetalert'));
            }
        } else if ($epay_key == NULL || $epay_pid == NULL) {
            $noepay = true;
        }

        if (input('act') == "epay_creat" && IS_POST){
            if ($epay_key != NULL && $epay_pid != NULL && $noepay == false){
                $this->assign('alert', sweetAlert('温馨提示', '你已经注册过易支付账号了!如果需要重新注册，请先清除之前的易支付配置', 'warning'));
                exit($this->fetch('common/sweetalert'));
            }
            $data=get_curl('http://pay.walpay.cn/api.php?act=apply&token=417ba11d94a9a767c857be33f9d46a7a&url='.$_SERVER['HTTP_HOST']);
            $arr=json_decode($data,true);
            if($arr['code']==1) {
                Db::name('weblist')->where('zid',ZID)->update(['epay_pid'=>$arr['pid'],'epay_key'=>$arr['key']]);
                $this->assign('alert', sweetAlert('温馨提示', '你已经注册过易支付账号了!如果需要重新注册，请先清除之前的易支付配置', 'success',url('epayset')));
                exit($this->fetch('common/sweetalert'));
            }else{
                $this->assign('alert', sweetAlert('温馨提示', $arr['msg'], 'warning',url('epayset')));

                exit($this->fetch('common/sweetalert'));
            }
        }
        
        //保存收款信息
        if(input('act') == "save" && IS_POST){
            $epay_pid = input('post.epay_pid');
            $epay_key = input('post.epay_key');
            $account = input('post.epay_account');
            $username = input('post.epay_username');
            
            if (($arr['code']==1 && ($account == NULL || $username == NULL)) || $epay_key == NULL || $epay_pid == NULL){
                $this->assign('alert', sweetAlert('温馨提示', '保存错误,配置信息不能留空!', 'warning'));
                exit($this->fetch('common/sweetalert'));
            } else {
                $data=get_curl('http://pay.walpay.cn/api.php?act=change&pid='.config('web_epay_pid').'&key='.config('web_epay_key').'&account='.$account.'&username='.$username.'&url='.$_SERVER['HTTP_HOST']);
                $arr=json_decode($data,true);
                Db::name('weblist')->where('zid',ZID)->update(['epay_pid'=>$epay_pid,'epay_key'=>$epay_key]);
                if($arr['code']==1) {
                    $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('epayset')));
                    exit($this->fetch('common/sweetalert'));
                }else{
                    $this->assign('alert', sweetAlert('温馨提示', $arr['msg'], 'warning',url('epayset')));
                    exit($this->fetch('common/sweetalert'));
                }
            }
        }
						        $bgurl = "/assets/Index/images/banner".ZID.".png";
        if (!file_exists(__DIR__ . "/../../.." . $bgurl)){
            $bgurl = "/assets/Index/images/banner1.jpg";
        }
        if(IS_POST){
           if ($file = request()->file('background')){
                if(!$file->check(['ext'=>'png'])){
                    $this->assign('alert',sweetAlert('温馨提示','图片格式错误','warning',url('webset')));
                    exit($this->fetch('common/sweetalert'));
                }
                if ($file->getSize() > 3000000){
                    $this->assign('alert',sweetAlert('温馨提示','图片太大了','warning',url('webset')));
                    exit($this->fetch('common/sweetalert'));
                }
                $info = $file->move(ROOT_PATH . 'assets/Index/' . DS . 'images','banner'.ZID.'.png');
            }
            foreach(input('post.') as $k=>$value){
                if ($k == 'domain2')
                {
                    if (Db::name('weblist')->where(['domain'=>$value,'domain2'=>$value])->find())
                    {
                        continue;
                    }
                }
                Db::name('weblist')->where(['zid'=>ZID])->update([$k=>$value]);
            }
            $this->assign('alert', sweetAlert('温馨提示', '修改成功', 'success',url('epayset')));
        }
        $this->assign('bgurl',$bgurl);
        $this->assign('arr',$arr);
        $this->assign('noepay',$noepay);
        $this->assign('epay_settle',$epay_settle);
        return $this->fetch();
    }
    
    //代理级别
    public function a_level()
    {
        $edit = false;
        $where = ['zid'=>ZID];
        $act = input('act');
        $zz_vipprice = config('zz_agent_vipprice') ?: 999;
        $zz_peieprice = config('zz_agent_peieprice') ?: 999;
        $zz_vipdprice = config('zz_agent_vipdprice') ?: 999;
        $this->assign(['vipprice'=>$zz_vipprice,'peieprice'=>$zz_peieprice,'vipdprice'=>$zz_vipdprice]);
        if (IS_POST && $act == ''){
            $name = input('?post.name') ? input('post.name') : '代理';
            $level = input('?post.level') ? input('post.level/d') : 1;
            if ($level < 1){
                $level = 1;
            }
            if (Db::name('level')->where(['zid'=>ZID,'level'=>$level])->find()){
                $this->assign('alert', sweetAlert('温馨提示', '级别重复了！', 'warning',url('a_level')));
                exit($this->fetch('common/sweetalert'));
            }
            $vipprice = is_numeric(input('post.vipprice')) ? input('post.vipprice') : 999;
            $vipdprice = is_numeric(input('post.vipdprice')) ? input('post.vipdprice') : 999;
            $peieprice = is_numeric(input('post.peieprice')) ? input('post.peieprice') : 999;
            if ($vipprice < $zz_vipprice || $peieprice < $zz_peieprice || $vipdprice < $zz_vipdprice){
                
                $this->assign('alert', sweetAlert('温馨提示', '价格不能低于总站限定的价格', 'warning',url('a_level')));
                exit($this->fetch('common/sweetalert'));
            }
            $map = [
                'name'=>$name,
                'level'=>$level,
                'vipprice'=>$vipprice,
                'vipdprice'=>$vipdprice,
                'peieprice'=>$peieprice,
                'zid'=>ZID
            ];
            Db::name('level')->insert($map);
            $this->assign('alert',sweetAlert('温馨提示','添加成功','success',url()));
        }
        if ($act == "del"){
            Db::name('level')->where(['level'=>input('level/d'),'zid'=>ZID])->delete();
            Db::name('users')->where(['zid'=>ZID,'daili'=>input('level/d')])->update(['daili'=>0]);
            $this->assign('alert',sweetAlert('温馨提示','删除成功','success',url()));
        } else if ($act == "edit"){
            $level = input('level/d');
            if (!$levelRow = Db::name('level')->where(['zid'=>ZID,'level'=>$level])->find()){
                $this->assign('alert', sweetAlert('温馨提示', '不存在', 'warning',url('a_level')));
                exit($this->fetch('common/sweetalert'));
            }
            $edit = true;
            
            if (IS_POST){
                $name = input('?post.name') ? input('post.name') : '代理';
                $vipprice = is_numeric(input('post.vipprice')) ? input('post.vipprice') : 999;
                $vipdprice = is_numeric(input('post.vipdprice')) ? input('post.vipdprice') : 999;
                $peieprice = is_numeric(input('post.peieprice')) ? input('post.peieprice') : 999;
                if ($vipprice < $zz_vipprice || $peieprice < $zz_peieprice || $vipdprice < $zz_vipdprice){
                    $this->assign('alert', sweetAlert('温馨提示', '价格不能低于总站限定的价格', 'warning',url('',['act'=>'edit','level'=>$level])));
                    exit($this->fetch('common/sweetalert'));
                }
                $map = [
                    'name'=>$name,
                    'vipprice'=>$vipprice,
                    'vipdprice'=>$vipdprice,
                    'peieprice'=>$peieprice,
                ];
                Db::name('level')->where(['level'=>$level,'zid'=>ZID])->update($map);
                $this->assign('alert',sweetAlert('温馨提示','保存成功','success',url('',['act'=>'edit','level'=>$level])));
            }
            $this->assign('row',$levelRow);
        }
        $list = Db::name('level')->where($where)->paginate(10);
        $this->assign('list',$list);
        $this->assign('edit',$edit);
        return $this->fetch();
    }
    
    //代理旗下的用户
    public function a_ulist($level = 0)
    {
        if (!$levelRow = Db::name('level')->where(['zid'=>ZID,'level'=>$level])->find()){
            $this->assign('alert', sweetAlert('温馨提示', '不存在', 'warning',url('a_level')));
            exit($this->fetch('common/sweetalert'));
        }
        
        $search = '';
        $act = input('act');
        if ($act == "search"){
            $search = ['a.user|a.uid'=>['like','%'.input('get.query').'%']];
        } else if ($act == "del"){
            Db::name('users')->where(['zid'=>ZID,'uid'=>input('uid/d')])->update(['daili'=>0]);
            $this->assign('alert',sweetAlert('温馨提示','取消代理身份成功','success',url('',['level'=>$level])));
        }
        if (IS_POST){
            $uid = input('?post.uid') ? input('post.uid/d') : 0;
            if (!$urow = Db::name('users')->where(['zid'=>ZID,'uid'=>$uid])->find()){
                $this->assign('alert', sweetAlert('温馨提示', '此用户不存在', 'warning',url('ulist')));
                exit($this->fetch('common/sweetalert'));
            } else if ($urow['daili'] != 0){
                $this->assign('alert', sweetAlert('温馨提示', '此用户已有代理身份', 'warning',url('',['level'=>$urow['daili']])));
                exit($this->fetch('common/sweetalert'));
            }
            Db::name('users')->where(['zid'=>ZID,'uid'=>$uid])->update(['daili'=>$level]);
            $this->assign('alert',sweetAlert('温馨提示','添加成功','success',url('',['level'=>$level])));
        }
        $list = Db::name('users')->alias('a')->join('level b','a.daili = b.level')->where(['a.zid'=>ZID,'b.zid'=>ZID,'b.level'=>$level])->where($search)->paginate(10);
        $this->assign('list',$list);
        $this->assign('LRow',$levelRow);
        return $this->fetch();
    }
    
    public function adminlist() {
        if (ZID != 1){
            $this->assign('alert', sweetAlert('温馨提示', '无权限', 'warning'));
            exit($this->fetch('common/sweetalert'));
        }
        $list = Db::name('users')->where(['power'=>9])->where('zid','<>',ZID)->order("uid DESC")->paginate(10);
        $this->assign(['list'=>$list]);
        return $this->fetch();
    }
    
    //商品列表
    public function goodslist()
    {
        $search = '';
        $act = input('act');
        if (IS_POST && $act == "add"){
            $name = input('post.name');
            $price = input('post.price');
            if ($name == '' || $name == NULL){
                $this->assign('alert', sweetAlert('温馨提示', '商品名称不能为空', 'warning',url()));
                exit($this->fetch('common/sweetalert'));
            } else if (Db::name('goods')->where(['name'=>trim($name),'zid'=>ZID])->find()){
                $this->assign('alert', sweetAlert('温馨提示', '商品名称重复了', 'warning',url()));
                exit($this->fetch('common/sweetalert'));
            } else if ($price < 0){
                $price = 0;
            } else {
                Db::name('goods')->insert([
                    'name'=>trim($name),
                    'price'=>$price,
                    'addtime'=>date("Y-m-d H:i:s"),
                    'zid'=>ZID
                ]);
                $this->assign('alert', sweetAlert('温馨提示', '添加商品成功', 'success',url()));
            }
        } else if ($act == "del"){
            $gid = input('gid/d');
            Db::name('goods')->where(['zid'=>ZID,'id'=>$gid])->delete();
            $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success',url()));
        } else if ($act == "search"){
            $search = ['name'=>['like','%' . input('get.name') . '%']];
        }
        $list = Db::name("goods")->where(['zid'=>ZID])->where($search)->order("id DESC")->paginate(10);
        $this->assign('list',$list);
        return $this->fetch();
    }
    
    //商品卡密列表
    public function goodskm($gid = 0)
    {
        if (!Db::name('goods')->where(['zid'=>ZID,'id'=>$gid])->find()){
            $this->assign('alert', sweetAlert('温馨提示', '商品不存在', 'warning',url('goodslist')));
            exit($this->fetch('common/sweetalert'));
        }
        $search = '';
        $act = input('act');
        if ($act == "search"){
            $search = ['km|pass'=>['like','%'.input('get.query').'%']];
        } else if ($act == "del"){
            Db::name('goods_km')->where(['id'=>input('id')])->delete();
            $this->assign('alert', sweetAlert('温馨提示', '删除成功', 'success',url()));
        }
        $list = Db::name('goods_km')->alias('a')->join('goods b','a.gid = b.id')->where(['b.zid'=>ZID])->where($search)->paginate(10);
        $this->assign('list',$list);
        return $this->fetch();
    }
    
    //导入商品卡密
    public function addgoodskm()
    {
        if (IS_POST){
            $gid = input('post.gid/d',0);
            if (!Db::name('goods')->where(['zid'=>ZID])->find()){
                $this->assign('alert', sweetAlert('温馨提示', '商品不存在', 'warning',url('goodslist')));
                exit($this->fetch('common/sweetalert'));
            }
            $text = input('post.text');
            $text = daddslashes(str_replace(array("\r\n", "\r", "\n"), "[br]", $text));
            $kms = explode('[br]',$text);
            $i = 0;
            foreach ($kms as $km){
                $km = trim($km);
                if (strlen($km) > 5){
                    $km = explode('----',$km);
                    $pwd = isset($km[1])?trim($km[1]):null;
                    $km = trim($km[0]);
                    if (Db::name('goods_km')->insert([
                        'km'=>$km,
                        'pass'=>$pwd,
                        'addtime'=>date("Y-m-d H:i:s"),
                        'gid'=>$gid,
                        
                    ])){
                        $i++;
                    }
                }
            }
            $this->assign('alert',sweetAlert('温馨提示','成功导入'.$i.'张卡密','success',url('goodskm',['gid'=>$gid])));
        }
        $goodslist = Db::name('goods')->field('id,name')->where(['zid'=>ZID])->select();
        $this->assign('goodslist',$goodslist);
        return $this->fetch();
    }
    
    //编辑商品
    public function editgoods($gid = 0)
    {
        if (!$GoodsRow = Db::name('goods')->where(['zid'=>ZID,'id'=>$gid])->find()){
            $this->assign('alert', sweetAlert('温馨提示', '商品不存在', 'warning',url('goodslist')));
            exit($this->fetch('common/sweetalert'));
        }
        if (IS_POST){
            $name = input('post.name');
            $price = input('post.price',0);
            if (Db::name('goods')->where(['name'=>$name,'id'=>['<>',$gid],'zid'=>ZID])->find()){
                $this->assign('alert', sweetAlert('温馨提示', '商品名称重复了', 'warning',url('',['gid'=>$gid])));
                exit($this->fetch('common/sweetalert'));
            }
            if ($price < 0){
                $price = 999;
            }
            Db::name('goods')->where(['zid'=>ZID,'id'=>$gid])->update([
                'name'  =>  $name,
                'price' =>  $price,
            ]);
            $this->assign('alert',sweetAlert('温馨提示','保存成功','success',url('',['gid'=>$gid])));
        }
        $this->assign('row',$GoodsRow);
        return $this->fetch();
    }
    
    
}