<?php
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 快乐是福 <815856515@qq.com>
// +----------------------------------------------------------------------
// | Date: 2016/4/27
// +----------------------------------------------------------------------
//公共函数库
use think\Db;
/**
 * 创建支付宝订单
 * @param
 * 
 * 
 */
function Pay($orderid,$name,$price,$type,$mtype = 0) {
    $query = '';
    if ($mtype)
    {
        $query = ['type'=>1];
    }
    if (config('web_payapi') == 1){
        //支付宝支付信息配置
        if ($mtype == 0){
            $alipay_config = [
                'partner' => config('web_alipay_pid'),
                'seller_email' => config('web_alipay_account'),
                'key'=>config('web_alipay_key'),
                'sign_type'=>strtoupper('MD5'),
                'input_charset'=>strtolower('utf-8'),
                'cacert'=>AliPay_PATH.'cacert.pem',
                'transport'=>'http'
            ];
        } else {
            $alipay_config = [
                'partner' => config('zon_alipay_pid'),
                'seller_email' => config('zon_alipay_account'),
                'key'=>config('zon_alipay_key'),
                'sign_type'=>strtoupper('MD5'),
                'input_charset'=>strtolower('utf-8'),
                'cacert'=>AliPay_PATH.'cacert.pem',
                'transport'=>'http'
            ];
        }
        if(isMobile() && config('zz_alipay_moblie') == 1){
            $parameter = [
                "service" => "alipay.wap.create.direct.pay.by.user",
                "partner" => trim($alipay_config['partner']), //合作身份者id
                "seller_id" => trim($alipay_config['seller_email']), //收款支付宝账号
                "payment_type"	=> "1", //支付方式
                "notify_url"	=> 'http://'.$_SERVER['HTTP_HOST'].url('alipay/Alipay_notify',$query), //服务器异步通知页面路径
                "return_url"	=> 'http://'.$_SERVER['HTTP_HOST'].url('alipay/Alipay_return',$query), //页面跳转同步通知页面路径
                "out_trade_no"	=> $orderid, //商户订单号
                "subject"	=> $name, //订单名称
                "total_fee"	=> $price, //付款金额
                "_input_charset"	=> strtolower('utf-8')
            ];
        } else {
            $parameter = [
                "service" => "create_direct_pay_by_user",
                "partner" => trim($alipay_config['partner']), //合作身份者id
                "seller_id" => trim($alipay_config['seller_email']), //收款支付宝账号
                "payment_type"	=> "1", //支付方式
                "notify_url"	=> 'http://'.$_SERVER['HTTP_HOST'].url('alipay/Alipay_notify',$query), //服务器异步通知页面路径
                "return_url"	=> 'http://'.$_SERVER['HTTP_HOST'].url('alipay/Alipay_return',$query), //页面跳转同步通知页面路径
                "out_trade_no"	=> $orderid, //商户订单号
                "subject"	=> $name, //订单名称
                "total_fee"	=> $price, //付款金额
                "_input_charset"	=> strtolower('utf-8')
            ];
        }
        
        $alipaySubmit = new \AlipaySubmit($alipay_config);
        $html_text = $alipaySubmit->buildRequestForm($parameter,"get", "正在跳转到支付页面");
        return $html_text;
    } else if (config('web_payapi') == 2) {
        //易支付信息配置
        if ($mtype == 0){
            $epay_config = [
                'partner'=>config('web_epay_pid'),
                'key'=>config('web_epay_key'),
                'sign_type'=>strtoupper('MD5'),
                'input_charset'=>strtolower('utf-8'),
                'transport'=>'http',
                'apiurl'=>'http://pay.walpay.cn/'
            ];
        } else {
            $epay_config = [
                'partner'=>config('zon_epay_pid'),
                'key'=>config('zon_epay_key'),
                'sign_type'=>strtoupper('MD5'),
                'input_charset'=>strtolower('utf-8'),
                'transport'=>'http',
                'apiurl'=>'http://pay.walpay.cn/'
            ];
        }
        
        $parameter = array(
            "pid" => trim($epay_config['partner']),
            "type" => $type,
            "notify_url"	=> 'http://'.$_SERVER['HTTP_HOST'].url('Epay/Epay_notify',$query), //服务器异步通知页面路径
            "return_url"	=> 'http://'.$_SERVER['HTTP_HOST'].url('Epay/Epay_return',$query), //页面跳转同步通知页面路径
            "out_trade_no"	=> $orderid,
            "name"	=> $name,
            "money"	=> $price,
            "sitename"	=> config('web_webname')
        );
        //建立请求
        $alipaySubmit = new AlipaySubmit($epay_config);
        $html_text = $alipaySubmit->buildRequestForm($parameter,"get", "正在跳转");
        echo $html_text;
    }
}
/**
 * 获取随机字符串
 *
 * @return string
 */
function getSid()
{
    return md5(uniqid(mt_rand(), 1) . time());
}
/**
 * 获取服务器挂机数量
 */
function get_net_count($do,$net){
    
    return Db::name('qqs')->where("`{$do}net`='{$net}'")->count('qid');
}

function isMobile() {
    // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
    if (isset ($_SERVER['HTTP_X_WAP_PROFILE'])) {
        return true;
    }
    //如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
    if (isset ($_SERVER['HTTP_VIA'])) {
        //找不到为flase,否则为true
        return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
    }
    //脑残法，判断手机发送的客户端标志,兼容性有待提高
    if (isset ($_SERVER['HTTP_USER_AGENT'])) {
        $clientkeywords = array ('nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo','iphone','ipod','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile');
        // 从HTTP_USER_AGENT中查找手机浏览器的关键字
        if (preg_match("/(" . implode('|', $clientkeywords) . ")/i",strtolower($_SERVER['HTTP_USER_AGENT']))) {
            return true;
        }
    }
    //协议法，因为有可能不准确，放到最后判断
    if (isset ($_SERVER['HTTP_ACCEPT'])) {
        // 如果只支持wml并且不支持html那一定是移动设备
        // 如果支持wml和html但是wml在html之前则是移动设备
        if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
            return true;
        }
    }
    //return true;
    return false;
}
/**
 * 快捷生成sweetalert
 *
 * @param      $_title
 * @param      $_text
 * @param      $_type
 * @param null $_url
 *
 * @return string
 */
function sweetAlert($_title, $_text, $_type, $_url = null)
{
    if (empty($_url)) {
        return 'swal("' . $_title . '", "' . $_text . '", "' . $_type . '");';
    } else {
        if ($_url == 'REFERER') {
            $_url = '/';
            if (isset($_SERVER['HTTP_REFERER'])) {
                $_url = $_SERVER['HTTP_REFERER'];
            }
        }
        return 'swal({ title: "' . $_title . '",   text: "' . $_text . '",   type: "' . $_type . '",   showCancelButton: false,   confirmButtonColor: "#DD6B55",   confirmButtonText: "OK",   closeOnConfirm: false }, function(){   window.location.href="' . $_url . '"; });';
    }
}

function get_ip_city($ip)
{
    $url = 'http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=';
    @$city = get_curl($url . $ip);
    $city = json_decode($city, true);
    if ($city['city']) {
        $location = $city['province'] . $city['city'];
    } else {
        $location = $city['province'];
    }
    if ($location) {
        return $location;
    } else {
        return false;
    }
}

function get_curl($url, $post = 0, $referer = 0, $cookie = 0, $header = 0, $ua = 0, $nobaody = 0)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $klsf[] = "Accept:*";
    $klsf[] = "Accept-Encoding:gzip,deflate,sdch";
    $klsf[] = "Accept-Language:zh-CN,zh;q=0.8";
    curl_setopt($ch, CURLOPT_HTTPHEADER, $klsf);
    if ($post) {
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    }
    if ($header) {
        curl_setopt($ch, CURLOPT_HEADER, TRUE);
    }
    if ($cookie) {
        curl_setopt($ch, CURLOPT_COOKIE, $cookie);
    }
    if ($referer) {
        if ($referer == 1) {
            curl_setopt($ch, CURLOPT_REFERER, "http://m.qzone.com/infocenter?g_f=");
        } else {
            curl_setopt($ch, CURLOPT_REFERER, $referer);
        }
    }
    if ($ua) {
        curl_setopt($ch, CURLOPT_USERAGENT, $ua);
    } else {
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Linux; U; Android 4.0.4; es-mx; HTC_One_X Build/IMM76D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0');
    }
    if ($nobaody) {
        curl_setopt($ch, CURLOPT_NOBODY, 1);//主要头部
        //curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);//跟随重定向
    }
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $ret = curl_exec($ch);
    curl_close($ch);
    return $ret;

}

function daddslashes($string, $force = 0, $strip = FALSE)
{
    !defined('MAGIC_QUOTES_GPC') && define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());
    if (!MAGIC_QUOTES_GPC || $force) {
        if (is_array($string)) {
            foreach ($string as $key => $val) {
                $string[$key] = daddslashes($val, $force, $strip);
            }
        } else {
            $string = addslashes($strip ? stripslashes($string) : $string);
        }
    }
    return $string;
}




/**
 * 获取订单状态
 *
 * @param $zt
 *
 * @return string
 */
function cookieZt($zt)
{
    switch ($zt) {
        case 0:
            return '<font color="green">正常</font>';
        case 1:
            return '<font color="red">失效</font>';
        case 2:
            return '<font color="red">失效&密错||异常</font>';
        default:
            return '<font color="#ff7f50">未知</font>';
    }
}

function getZt($zt)
{
    switch ($zt) {
        case 1:
            return '<font color="green">运行中[PE]</font>';
        case 0:
            return '<font color="red">关闭</font>';
        case 2:
            return '<font color="green">运行中[PC]</font>';
        default:
            return '<font color="#ff7f50">未知</font>';
    }
}

function zt($zt)
{
    switch ($zt) {
        case 1:
            return 0;
        case 0:
            return 1;
        case 2:
            return 0;
        default:
            return 1;
    }
}




function getHtmlCode($value, $html = false)
{
    $value = stripslashes($value);
    if ($html) {
        $value = htmlspecialchars($value);
    }
    return $value;
}

function getRandStr($len = 12, $type = 0)
{
    $str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $strlen = strlen($str);
    $randstr = '';
    for ($i = 0; $i < $len; $i++) {
        $randstr .= $str[mt_rand(0, $strlen - 1)];
    }
    if ($type == 1) {
        $randstr = strtoupper($randstr);
    } elseif ($type == 2) {
        $randstr = strtolower($randstr);
    }
    return $randstr;
}

function sendEmail($to, $title, $html, $config)
{
    try {
        require_once 'util/class.phpmailer.php';
        require_once 'util/class.smtp.php';
        $mail = new PHPMailer(true);
        $mail->IsSMTP();
        $mail->CharSet = 'UTF-8'; //设置邮件的字符编码，这很重要，不然中文乱码
        $mail->SMTPAuth = true; //开启认证
        if ($config['port'] == 465) {
            $mail->SMTPSecure = 'ssl';
        }
        $mail->Port = $config['port'];
        $mail->Host = $config['host'];
        $mail->Username = $config['username'];
        $mail->Password = $config['password'];
        //$mail->IsSendmail(); //如果没有sendmail组件就注释掉，否则出现“Could not execute: /var/qmail/bin/sendmail ”的错误提示
        //$mail->AddReplyTo("email@163.com","email");//回复地址
        $mail->From = $config['username'];
        $mail->FromName = $config['nick'];
        $mail->AddAddress($to);
        $mail->Subject = $title;
        $mail->Body = $html;
        //$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; //当邮件不支持html时备用显示，可以省略
        $mail->WordWrap = 80; // 设置每行字符串的长度
        //$mail->AddAttachment("f:/test.png"); //可以添加附件
        $mail->IsHTML(true);
        $mail->Send();
        return 'success';
    } catch (phpmailerException $e) {
        return $e->errorMessage();
    }
}




function uint32val($var) {
    //将输入转换为32位无符号整数，若溢出，则只保留低32位
    if (is_string($var)) {
        if (PHP_INT_MAX > 2147483647) {
            $var = intval($var);
        } else {
            $var = floatval($var);
        }
    }
    if (!is_int($var)) {
        $var = intval($var);
    }
    if ((0 > $var) || ($var > 4294967295)) {
        $var &= 4294967295;
        if (0 > $var) {
            $var = sprintf('%u', $var);
        }
    }
    return $var;
}


function getg_tk($skey){
    $len = strlen($skey);
    $hash = 5381;
    for($i = 0; $i < $len; $i++){
        $hash += (($hash << 5) & 0xffffffff) + ord($skey[$i]);
    }
    return $hash & 0x7fffffff;//计算g_tk
}

function checkCookie($uin,$skey,$p_skey){
    $g_tk = getg_tk($p_skey);
    $url = 'http://mobile.qzone.qq.com/get_feeds?g_tk='.$g_tk.'&res_type=3&res_attach=&refresh_type=2&format=json&r=0.'.time();
    $cookie="uin=o0{$uin}; skey={$skey}; p_uin=o0{$uin}; p_skey={$p_skey};";
    $get = get_curl($url,null,0,$cookie);
    $arr = json_decode($get,true);
    if (isset($arr['code']) && $arr['code'] == 0){
        return true;
    }
    return false;
}
/*
 * 获取QQ对应提交信息
 */
function get_info($cookies,$return = NULL){
    preg_match('/skey=@(.{9});/',$cookies,$skey);
    preg_match('/superkey=(.*?);/',$cookies,$superkey);
    preg_match('/sid=(.*?);/',$cookies,$sid);
    preg_match('/p_skey=(.*?);/', $cookies, $p_skey);
    $skey = "@".$skey[1];
    $pskey = $p_skey[1];
    $sid = $sid[1];
    $superkey = $superkey[1];
    $arr = ['skey'=>$skey,'pskey'=>$pskey,'sid'=>$sid,'superkey'=>$superkey];
    if ($return){
        return $arr["{$return}"];
    } else {
        return $arr;
    }
}

function uploadimg($uin,$skey,$image,$image_size=array(),$cookies){
    $gtk = getg_tk($skey);
    $url='http://mobile.qzone.qq.com/up/cgi-bin/upload/cgi_upload_pic_v2?g_tk='.$gtk;
    $post='picture='.urlencode(base64_encode($image)).'&base64=1&hd_height='.$image_size[1].'&hd_width='.$image_size[0].'&hd_quality=90&output_type=json&preupload=1&charset=utf-8&output_charset=utf-8&logintype=sid&Exif_CameraMaker=&Exif_CameraModel=&Exif_Time=&uin='.$uin;
    $data=preg_replace("/\s/","",get_curl($url,$post,1,$cookies,0,1));
    preg_match('/_Callback\((.*)\);/',$data,$arr);
    $data=json_decode($arr[1],true);
    if($data && array_key_exists('filemd5',$data)){
        $post='output_type=json&preupload=2&md5='.$data['filemd5'].'&filelen='.$data['filelen'].'&batchid='.time().rand(100000,999999).'&currnum=0&uploadNum=1&uploadtime='.time().'&uploadtype=1&upload_hd=0&albumtype=7&big_style=1&op_src=15003&charset=utf-8&output_charset=utf-8&uin='.$uin.'&logintype=sid&refer=shuoshuo';
        $img=preg_replace("/\s/","",get_curl($url,$post,1,$cookies,0,1));
        preg_match('/_Callback\(\[(.*)\]\);/',$img,$arr);
        $data=json_decode($arr[1],true);
        if($data && array_key_exists('picinfo',$data)){
            if($data['picinfo']['albumid']!=""){
                return ''.$data['picinfo']['albumid'].','.$data['picinfo']['lloc'].','.$data['picinfo']['sloc'].','.$data['picinfo']['type'].','.$data['picinfo']['height'].','.$data['picinfo']['width'].',,,';
            }else{
                return '图片信息获取失败！';
            }
        }else{
            return '图片信息获取失败！';
        }
    }else{
        return '图片上传失败！原因：'.$data['msg'];
    }
}

function getIP(){
    if (getenv('HTTP_CLIENT_IP')) {
        $ip = getenv('HTTP_CLIENT_IP');
    }elseif (getenv('HTTP_X_FORWARDED_FOR')) {
        $ip = getenv('HTTP_X_FORWARDED_FOR');
    }elseif (getenv('HTTP_X_FORWARDED')) {
        $ip = getenv('HTTP_X_FORWARDED');
    }elseif (getenv('HTTP_FORWARDED_FOR')) {
        $ip = getenv('HTTP_FORWARDED_FOR');
    }elseif (getenv('HTTP_FORWARDED')) {
        $ip = getenv('HTTP_FORWARDED');
    }else{
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function cut_str($str,$len,$suffix="..."){
    if(function_exists('mb_substr')){
        if(strlen($str) > $len){
            $str= mb_substr($str,0,$len).$suffix;
        }
        return $str;
    }else{
        if(strlen($str) > $len){
            $str= substr($str,0,$len).$suffix;
        }
        return $str;
    }
}

function getSubstr($str, $leftStr, $rightStr)
{
    $left = strpos($str, $leftStr);
    $right = strpos($str, $rightStr,$left);
    if($left < 0 or $right < $left) return '';
    return substr($str, $left + strlen($leftStr), $right-$left-strlen($leftStr));
}

//验证是否代理
function Check_Daili($daili = 0)
{
    if ($daili){
        if (db('level')->where(['level'=>$daili,'zid'=>ZID])->find()){
            return true;
        }
        return false;
    } else {
        return false;
    }
}