/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class BlacklistedCerts {
    private static Properties props = null;
    private static String algorithm = null;
    private static final String ALGORITHM_KEY = "Algorithm";
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());

    public static void check(X509Certificate x509Certificate) throws CertificateException {
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            if (props == null) {
                BlacklistedCerts.load();
            }
            if (algorithm == null) {
                return;
            }
            String string = BlacklistedCerts.getCertificateFingerPrint(algorithm, x509Certificate);
            if (props.containsKey(string)) {
                String string2 = ResourceManager.getMessage("blacklisted.certificate");
                Trace.println(string2, TraceLevel.SECURITY);
                throw new CertificateException(string2);
            }
        }
    }

    private static void load() {
        props = new Properties();
        if (blacklistCertsFile.exists()) {
            Trace.println("Loading blacklisted.certs file: " + blacklistCertsFile, TraceLevel.SECURITY);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws Exception {
                        FileInputStream fileInputStream = null;
                        fileInputStream = new FileInputStream(blacklistCertsFile);
                        props.load(fileInputStream);
                        Object var4_2 = null;
                        if (fileInputStream == null) return null;
                        try {
                            fileInputStream.close();
                            return null;
                        }
                        catch (Exception exception) {
                            Trace.ignored(exception);
                        }
                        return null;
                        {
                            catch (Exception exception) {
                                Trace.ignored(exception);
                                Object var4_3 = null;
                                if (fileInputStream == null) return null;
                                try {
                                    fileInputStream.close();
                                    return null;
                                }
                                catch (Exception exception2) {
                                    Trace.ignored(exception2);
                                }
                                return null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            if (fileInputStream == null) throw throwable;
                            try {
                                fileInputStream.close();
                                throw throwable;
                            }
                            catch (Exception exception) {
                                Trace.ignored(exception);
                            }
                            throw throwable;
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            algorithm = props.getProperty(ALGORITHM_KEY);
            if (algorithm == null) {
                Trace.println("blacklisted.certs file contains no Algorithm property.", TraceLevel.SECURITY);
            }
        } else {
            Trace.println("No blacklisted.certs file", TraceLevel.SECURITY);
        }
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private static String getCertificateFingerPrint(String string, X509Certificate x509Certificate) {
        String string2 = "";
        try {
            byte[] byArray = x509Certificate.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = messageDigest.digest(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray2.length; ++i) {
                BlacklistedCerts.byte2hex(byArray2[i], stringBuffer);
            }
            string2 = stringBuffer.toString();
            Trace.println(algorithm + " finger print: " + string2, TraceLevel.SECURITY);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        return string2;
    }
}

