/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.utils;

import com.neuedu.educloud.common.utils.StringCodec;
import java.io.ByteArrayOutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class StringZip {
    private static final String charset = "UTF-8";

    public static String compress(String source) throws Exception {
        byte[] input = source.getBytes(charset);
        return StringZip.compress(input);
    }

    public static String compress(byte[] input) throws Exception {
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length);
        compresser.finish();
        byte[] buffer = new byte[1024];
        while (!compresser.finished()) {
            int count = compresser.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        String comp = StringCodec.base64Encoder(output, 0, output.length);
        return comp;
    }

    public static String decomp(String source) throws Exception {
        byte[] output = StringZip.decompress(source);
        String outputString = new String(output, charset);
        return outputString;
    }

    public static byte[] decompress(String source) throws Exception {
        byte[] input = StringCodec.base64Decoder(source);
        Inflater decompresser = new Inflater();
        decompresser.setInput(input);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length);
        byte[] buffer = new byte[1024];
        while (!decompresser.finished()) {
            int count = decompresser.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }
}

