/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.utils;

import java.io.ByteArrayOutputStream;

public class StringCodec {
    private static final char[] chars = new char[]{'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'A', 'C', 'B', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'p', 'd', 'o', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '4', '2', '3', '5', '6', '7', '8', '9', '_', '-'};
    private static final int fixAscii = 44;
    private static final byte[] pem_convert_array = new byte[256];

    static {
        int i = 0;
        while (i < 255) {
            StringCodec.pem_convert_array[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < chars.length) {
            StringCodec.pem_convert_array[StringCodec.chars[j]] = (byte)j;
            ++j;
        }
    }

    public static String base64Encoder(byte[] byteDigest, int offset, int count) {
        StringBuffer rs = new StringBuffer();
        int i = offset;
        while (i < count) {
            int i0 = i++;
            int i1 = i++;
            int i2 = i;
            if (i1 >= byteDigest.length) {
                byte byte0 = byteDigest[i0];
                int k = 0;
                rs.append(chars[byte0 >>> 2 & 0x3F]);
                rs.append(chars[(byte0 << 4 & 0x30) + (k >>> 4 & 0xF)]);
                rs.append(44);
                rs.append(44);
            } else if (i2 >= byteDigest.length) {
                byte byte1 = byteDigest[i0];
                byte byte3 = byteDigest[i1];
                int l = 0;
                rs.append(chars[byte1 >>> 2 & 0x3F]);
                rs.append(chars[(byte1 << 4 & 0x30) + (byte3 >>> 4 & 0xF)]);
                rs.append(chars[(byte3 << 2 & 0x3C) + (l >>> 6 & 3)]);
                rs.append(44);
            } else {
                byte byte2 = byteDigest[i0];
                byte byte4 = byteDigest[i1];
                byte byte5 = byteDigest[i2];
                rs.append(chars[byte2 >>> 2 & 0x3F]);
                rs.append(chars[(byte2 << 4 & 0x30) + (byte4 >>> 4 & 0xF)]);
                rs.append(chars[(byte4 << 2 & 0x3C) + (byte5 >>> 6 & 3)]);
                rs.append(chars[byte5 & 0x3F]);
            }
            ++i;
        }
        return rs.toString();
    }

    public static byte[] base64Decoder(String src) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] input = src.getBytes();
        byte[] decode_buffer = new byte[4];
        int i = 0;
        while (i < input.length) {
            int size = input.length - i >= 4 ? 4 : input.length - i;
            int b0 = -1;
            int b1 = -1;
            int b2 = -1;
            int b3 = -1;
            decode_buffer[0] = input[i];
            int k = 0;
            while (k < size - 1) {
                decode_buffer[k + 1] = input[++i];
                ++k;
            }
            if (size > 3 && decode_buffer[3] == 44) {
                size = 3;
            }
            if (size > 2 && decode_buffer[2] == 44) {
                size = 2;
            }
            switch (size) {
                case 4: {
                    b3 = pem_convert_array[decode_buffer[3] & 0xFF];
                }
                case 3: {
                    b2 = pem_convert_array[decode_buffer[2] & 0xFF];
                }
                case 2: {
                    b1 = pem_convert_array[decode_buffer[1] & 0xFF];
                    b0 = pem_convert_array[decode_buffer[0] & 0xFF];
                }
            }
            switch (size) {
                case 2: {
                    output.write((byte)(b0 << 2 & 0xFC | b1 >>> 4 & 3));
                    break;
                }
                case 3: {
                    output.write((byte)(b0 << 2 & 0xFC | b1 >>> 4 & 3));
                    output.write((byte)(b1 << 4 & 0xF0 | b2 >>> 2 & 0xF));
                    break;
                }
                case 4: {
                    output.write((byte)(b0 << 2 & 0xFC | b1 >>> 4 & 3));
                    output.write((byte)(b1 << 4 & 0xF0 | b2 >>> 2 & 0xF));
                    output.write((byte)(b2 << 6 & 0xC0 | b3 & 0x3F));
                }
            }
            ++i;
        }
        return output.toByteArray();
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(StringCodec.charToByte(hexChars[pos]) << 4 | StringCodec.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

