/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class FileZip {
    public static void unzip(String zipPath, String targetPath) throws Exception {
        FileZip.unzip(new File(zipPath), targetPath);
    }

    public static void unzip(File zfile, String targetPath) throws Exception {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            ZipFile zipFile = new ZipFile(zfile, 1);
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            boolean i = false;
            while (emu.hasMoreElements()) {
                int count;
                ZipEntry entry = emu.nextElement();
                String fileName = entry.getName().toLowerCase();
                bis = new BufferedInputStream(zipFile.getInputStream(entry));
                File file = new File(String.valueOf(targetPath) + fileName);
                int BUFFER = 40960;
                bos = new BufferedOutputStream(new FileOutputStream(file), BUFFER);
                byte[] data = new byte[BUFFER];
                while ((count = bis.read(data, 0, BUFFER)) != -1) {
                    ((BufferedOutputStream)bos).write(data, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
            }
            zipFile.close();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] getFileFromZip(File zfile, String filename) throws Exception {
        byte[] buf = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        try {
            ZipFile zipFile = new ZipFile(zfile, 1);
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            boolean i = false;
            while (emu.hasMoreElements()) {
                int count;
                ZipEntry entry = emu.nextElement();
                String fileName = entry.getName().toLowerCase();
                if (!fileName.equals(filename.toLowerCase())) continue;
                bis = new BufferedInputStream(zipFile.getInputStream(entry));
                int BUFFER = 40960;
                bos = new ByteArrayOutputStream();
                byte[] data = new byte[BUFFER];
                while ((count = bis.read(data, 0, BUFFER)) != -1) {
                    bos.write(data, 0, count);
                }
                buf = bos.toByteArray();
            }
            zipFile.close();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return buf;
    }

    public static void zip(String zipPath, String ... filePaths) throws Exception {
        File[] files = new File[filePaths.length];
        int i = 0;
        while (i < filePaths.length) {
            files[i] = new File(filePaths[i]);
            ++i;
        }
        FileZip.zip(new File(zipPath), files);
    }

    public static void zip(File zipPath, File ... files) throws Exception {
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipPath)));
            int BUFFER = 40960;
            byte[] data = new byte[BUFFER];
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                int count;
                File file = fileArray[n2];
                origin = new BufferedInputStream(new FileInputStream(file), BUFFER);
                ZipEntry entry = new ZipEntry(file.getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                out.flush();
                ++n2;
            }
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

