/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.utils;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class Crypto {
    private static Charset PLAIN_TEXT_ENCODING = Charset.forName("UTF-8");
    private static String CIPHER_TRANSFORMATION = "AES/CTR/NoPadding";
    private static String KEY_TYPE = "AES";
    private static int KEY_SIZE_BITS = 128;
    private SecretKey key;
    private Cipher cipher = null;
    private byte[] ivBytes = null;

    public Crypto() {
        try {
            this.cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Crypto(String keyText) {
        try {
            this.cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            this.setStringToKey(keyText);
            this.setHexToIV("2013013514202121");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Crypto(String keyText, String ivText) {
        try {
            this.cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            this.setStringToKey(keyText);
            this.setStringToIV(ivText);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getIVAsHex() {
        return Crypto.byteArrayToHexString(this.ivBytes);
    }

    public String getKeyAsHex() {
        return Crypto.byteArrayToHexString(this.key.getEncoded());
    }

    public void setStringToKey(String keyText) throws Exception {
        this.setKey(keyText.getBytes());
    }

    public void setHexToKey(String hexKey) {
        this.setKey(Crypto.hexStringToByteArray(hexKey));
    }

    private void setKey(byte[] bArray) {
        byte[] bText = new byte[KEY_SIZE_BITS / 8];
        int end = Math.min(KEY_SIZE_BITS / 8, bArray.length);
        System.arraycopy(bArray, 0, bText, 0, end);
        this.key = new SecretKeySpec(bText, KEY_TYPE);
    }

    public void setStringToIV(String ivText) {
        this.setIV(ivText.getBytes());
    }

    public void setHexToIV(String hexIV) {
        this.setIV(Crypto.hexStringToByteArray(hexIV));
    }

    private void setIV(byte[] bArray) {
        byte[] bText = new byte[KEY_SIZE_BITS / 8];
        int end = Math.min(KEY_SIZE_BITS / 8, bArray.length);
        System.arraycopy(bArray, 0, bText, 0, end);
        this.ivBytes = bText;
    }

    public String encryptCRT(String message) throws Exception {
        String hexMessage = this.encrypt(message);
        return Crypto.byteArrayToHexString(this.ivBytes).concat(hexMessage.substring(2));
    }

    public String encrypt(String message) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        this.cipher.init(1, (Key)this.key, new IvParameterSpec(this.ivBytes));
        byte[] encrypted = this.cipher.doFinal(message.getBytes(PLAIN_TEXT_ENCODING));
        String result = Crypto.byteArrayToHexString(encrypted);
        return result;
    }

    public String decryptCrt(String hexCipherText) throws Exception {
        byte[] ciphertextBytes = Crypto.hexStringToByteArray(hexCipherText);
        this.ivBytes = Arrays.copyOf(Arrays.copyOf(ciphertextBytes, 8), 16);
        this.cipher.init(1, (Key)this.key, new IvParameterSpec(this.ivBytes));
        byte[] recoveredCleartext = this.cipher.doFinal(ciphertextBytes, 8, ciphertextBytes.length - 8);
        return new String(recoveredCleartext);
    }

    public String decrypt(String hexCiphertext) throws Exception {
        byte[] dec = Crypto.hexStringToByteArray(hexCiphertext);
        this.cipher.init(2, (Key)this.key, new IvParameterSpec(this.ivBytes));
        byte[] decrypted = this.cipher.doFinal(dec);
        return new String(decrypted, PLAIN_TEXT_ENCODING);
    }

    private static String byteArrayToHexString(byte[] raw) {
        StringBuilder sb = new StringBuilder(2 + raw.length * 2);
        sb.append("0x");
        int i = 0;
        while (i < raw.length) {
            sb.append(String.format("%02X", raw[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }

    private static byte[] hexStringToByteArray(String hex) {
        Pattern replace = Pattern.compile("^0x");
        String s = replace.matcher(hex).replaceAll("");
        byte[] b = new byte[s.length() / 2];
        int i = 0;
        while (i < b.length) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
            ++i;
        }
        return b;
    }
}

