/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.storage.impl;

import com.neuedu.educloud.common.BinaryStream;
import com.neuedu.educloud.common.ConfigFactory;
import com.neuedu.educloud.common.storage.BinaryStorageAdapter;
import com.neuedu.educloud.common.storage.impl.BinaryStreamImpl;
import java.io.File;
import java.util.Date;

public class FileSystemStorageAdapterImpl
implements BinaryStorageAdapter {
    private String root = null;

    public FileSystemStorageAdapterImpl() {
        String repository = ConfigFactory.getProperty("repository.root");
        String home = ConfigFactory.getProperty("user.home");
        this.root = repository == null ? home : repository;
        this.root = this.root.endsWith("/") ? String.valueOf(this.root) + "storages" : String.valueOf(this.root) + "/storages";
    }

    @Override
    public boolean create(String binaryStreamName) throws Exception {
        File file = new File(String.valueOf(this.root) + "/" + binaryStreamName);
        File path = file.getParentFile();
        path.mkdirs();
        return file.createNewFile();
    }

    @Override
    public BinaryStream open(String binaryStreamName) throws Exception {
        File file = new File(String.valueOf(this.root) + "/" + binaryStreamName);
        if (!file.exists()) {
            return null;
        }
        return new BinaryStreamImpl(file, binaryStreamName);
    }

    @Override
    public boolean exists(String binaryStreamName) {
        File file = new File(String.valueOf(this.root) + "/" + binaryStreamName);
        return file.exists();
    }

    @Override
    public boolean delete(String binaryStreamName) throws Exception {
        File file = new File(String.valueOf(this.root) + "/" + binaryStreamName);
        return file.delete();
    }

    @Override
    public String lastModified(String binaryStreamName) {
        File file = new File(String.valueOf(this.root) + "/" + binaryStreamName);
        long times = file.lastModified();
        Date date = new Date(times);
        return dateFormat.format(date);
    }

    @Override
    public long length(String binaryStreamName) {
        File file = new File(String.valueOf(this.root) + "/" + binaryStreamName);
        return file.length();
    }
}

