/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.storage.impl;

import com.neuedu.educloud.common.CacheMap;
import com.neuedu.educloud.common.storage.impl.CacheEntity;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CacheMapImpl
implements CacheMap {
    private static final Map<String, CacheEntity> entityCaches = new ConcurrentHashMap<String, CacheEntity>();
    private Queue<String> keyQueue = new ConcurrentLinkedQueue<String>();
    private String subject = "";

    public CacheMapImpl(String subject) {
        this.subject = subject;
        this.doExpire();
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public boolean containsKey(String key) {
        CacheEntity entity;
        if (this.keyQueue.size() > 0 && (entity = entityCaches.get(key)) != null) {
            entity.resetExpiry();
        }
        return entityCaches.containsKey(key);
    }

    @Override
    public Object remove(String key) {
        this.keyQueue.remove(key);
        CacheEntity entity = entityCaches.remove(key);
        return entity.get();
    }

    @Override
    public Object get(String key) {
        if (this.keyQueue.size() > 0) {
            CacheEntity entity = entityCaches.get(key);
            if (entity == null) {
                return null;
            }
            entity.resetExpiry();
            return entity.get();
        }
        return entityCaches.get(key);
    }

    @Override
    public void add(String key, Object val) {
        CacheEntity entity = new CacheEntity(val, 0L);
        entityCaches.put(key, entity);
    }

    @Override
    public void add(String key, Object val, long expiry) {
        CacheEntity entity = new CacheEntity(val, expiry);
        entityCaches.put(key, entity);
        if (expiry > 0L) {
            this.keyQueue.add(key);
        }
    }

    private void doExpire() {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        if (!CacheMapImpl.this.keyQueue.isEmpty()) {
                            String key = (String)CacheMapImpl.this.keyQueue.peek();
                            CacheEntity entity = (CacheEntity)entityCaches.get(key);
                            if (entity.isExpiry()) {
                                key = (String)CacheMapImpl.this.keyQueue.poll();
                                entityCaches.remove(key);
                            }
                        } else {
                            1.sleep(1000L);
                            1.yield();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        1.sleep(500L);
                        1.yield();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }
}

