/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.storage.impl;

import com.neuedu.educloud.common.BinaryStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

class BinaryStreamImpl
implements BinaryStream {
    private String name = null;
    RandomAccessFile fas = null;

    public BinaryStreamImpl(File file, String name) throws Exception {
        this.name = name;
        this.fas = new RandomAccessFile(file, "rw");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long length() throws Exception {
        return this.fas.length();
    }

    @Override
    public void seek(long position) throws Exception {
        this.fas.seek(position);
    }

    @Override
    public int write(byte[] buf) throws Exception {
        this.fas.write(buf);
        return buf.length;
    }

    @Override
    public int write(byte[] buf, int off, int len) throws Exception {
        this.fas.write(buf, off, len);
        return len;
    }

    @Override
    public void write(InputStream in) throws Exception {
        byte[] buf = new byte[4096];
        int r = 0;
        while ((r = in.read(buf)) > 0) {
            this.fas.write(buf, 0, r);
        }
    }

    @Override
    public int read(byte[] buf) throws Exception {
        return this.fas.read(buf);
    }

    @Override
    public void read(OutputStream out) throws Exception {
        byte[] buf = new byte[4096];
        int r = 0;
        while ((r = this.fas.read(buf)) > 0) {
            out.write(buf, 0, r);
            out.flush();
        }
    }

    @Override
    public void close() throws Exception {
        this.fas.close();
    }
}

