/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.common.sensitiveword;

import com.neuedu.educloud.common.sensitiveword.SensitivewordLib;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SensitivewordFilter {
    public static int MinMatchType = 0;
    public static int MaxMatchType = 9;
    private String repalceString = null;
    private HashMap sensitiveWordMap = null;

    public SensitivewordFilter(SensitivewordLib slib) {
        this.repalceString = slib.getReplaceString();
        this.sensitiveWordMap = slib.getSensitiveWordMap();
    }

    public int checkSensitiveWord(String text, int beginIndex, int matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map nowMap = this.sensitiveWordMap;
        int i = beginIndex;
        while (i < text.length()) {
            word = text.charAt(i);
            if ((nowMap = (Map)nowMap.get(Character.valueOf(word))) != null) {
                ++matchFlag;
                if ("1".equals(nowMap.get("isEnd"))) {
                    flag = true;
                    if (MinMatchType == matchType) {
                        break;
                    }
                }
            } else {
                text = null;
                nowMap = null;
                break;
            }
            ++i;
        }
        if (!flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    public Set<String> getSensitiveWord(String text, int matchType) {
        HashSet<String> set = new HashSet<String>();
        int l = text.length();
        int i = 0;
        while (i < l) {
            int len = this.checkSensitiveWord(text, i, matchType);
            if (len > 0) {
                set.add(text.substring(i, i + len));
                i += len;
                continue;
            }
            ++i;
        }
        text = null;
        return set;
    }

    public String replaceSensitiveWord(String text, int matchType) {
        int l = text.length();
        int i = 0;
        while (i < l) {
            int len = this.checkSensitiveWord(text, i, matchType);
            if (len > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(text.substring(0, i));
                sb.append(this.repalceString.substring(0, len));
                sb.append(text.substring(i + len));
                text = sb.toString();
                i += len;
                continue;
            }
            ++i;
        }
        return text;
    }

    public static void main(String[] args) throws Exception {
        LineNumberReader reader = null;
        long l0 = System.currentTimeMillis();
        SensitivewordLib sl = new SensitivewordLib();
        reader = new LineNumberReader(new InputStreamReader(SensitivewordFilter.class.getResourceAsStream("/sensitiveword.txt"), "utf-8"));
        String word = null;
        while ((word = reader.readLine()) != null) {
            if ("".equals(word.trim())) continue;
            sl.add(word);
        }
        sl.build();
        SensitivewordFilter sf = new SensitivewordFilter(sl);
        System.out.println(" load=" + (System.currentTimeMillis() - l0));
        String text = "";
        long l1 = System.currentTimeMillis();
        String new_text = sf.replaceSensitiveWord(text, MaxMatchType);
        System.out.println(" time=" + (System.currentTimeMillis() - l1));
        System.out.println("o=" + text + "\n" + "n=" + new_text);
    }
}

