/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.xmpp;

import com.neuedu.educloud.api.xmpp.GetItemsRequest;
import com.neuedu.educloud.api.xmpp.IsSubscribeExtension;
import com.neuedu.educloud.api.xmpp.ItemsExtension;
import com.neuedu.educloud.api.xmpp.Metadata;
import com.neuedu.educloud.api.xmpp.SetExtension;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.SyncPacketSend;

public class XmsNode {
    private LeafNode leafNode = null;
    private Connection connection = null;
    private String to = null;

    XmsNode(LeafNode leafNode, Connection connection, String toAddress) {
        this.leafNode = leafNode;
        this.connection = connection;
        this.to = toAddress;
    }

    public String getId() {
        return this.leafNode.getId();
    }

    public void addItemEventListener(ItemEventListener listener) {
        this.leafNode.addItemEventListener(listener);
    }

    public void removeItemEventListener(ItemEventListener listener) {
        this.leafNode.removeItemEventListener(listener);
    }

    public void addItemDeleteListener(ItemDeleteListener listener) {
        this.leafNode.addItemDeleteListener(listener);
    }

    public void removeItemDeleteListener(ItemDeleteListener listener) {
        this.leafNode.removeItemDeleteListener(listener);
    }

    public boolean isSubscribed(String jid) throws XMPPException {
        String nodeName = this.leafNode.getId();
        IsSubscribeExtension ext = new IsSubscribeExtension(jid, nodeName);
        PubSub request = new PubSub();
        request.setType(IQ.Type.SET);
        request.setTo(this.to);
        request.addExtension((PacketExtension)ext);
        PubSub packet = (PubSub)SyncPacketSend.getReply((Connection)this.connection, (Packet)request);
        Subscription subscription = (Subscription)packet.getExtension(PubSubElementType.SUBSCRIPTION);
        Subscription.State state = subscription.getState();
        return state == Subscription.State.subscribed;
    }

    public Subscription subscribe(String jid) throws XMPPException {
        return this.leafNode.subscribe(jid);
    }

    public void unsubscribe(String jid) throws XMPPException {
        this.leafNode.unsubscribe(jid);
    }

    public void publish() {
        this.leafNode.publish();
    }

    public <T extends Item> void publish(T item) {
        this.leafNode.publish(item);
    }

    public <T extends Item> void publish(Collection<T> items) {
        this.leafNode.publish(items);
    }

    public DiscoverItems discoverItems() throws XMPPException {
        return this.leafNode.discoverItems();
    }

    public DiscoverInfo discoverInfo() throws XMPPException {
        return this.leafNode.discoverInfo();
    }

    public <T extends Item> List<T> getItems() throws XMPPException {
        return this.leafNode.getItems();
    }

    public <T extends Item> List<T> getItems(Collection<String> ids) throws XMPPException {
        return this.leafNode.getItems(ids);
    }

    public <T extends Item> List<T> getItems(int maxItems, Metadata handler) throws XMPPException {
        String nodeName = this.leafNode.getId();
        GetItemsRequest ext = new GetItemsRequest(nodeName, maxItems, null, null);
        PubSub request = new PubSub();
        request.setType(IQ.Type.GET);
        request.setTo(this.to);
        request.addExtension((PacketExtension)ext);
        PubSub result = (PubSub)SyncPacketSend.getReply((Connection)this.connection, (Packet)request);
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        if (handler != null) {
            SetExtension setElem = (SetExtension)result.getExtension("set", "http://jabber.org/protocol/pubsub");
            handler.setCount(setElem.getCount());
            handler.setFirstId(setElem.getFirstId());
            handler.setFirstIndex(setElem.getFirstIndex());
            handler.setLastId(setElem.getLastId());
        }
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(String beforeId, int maxItems, Metadata handler) throws XMPPException {
        String nodeName = this.leafNode.getId();
        GetItemsRequest ext = new GetItemsRequest(nodeName, maxItems, beforeId, null);
        PubSub request = new PubSub();
        request.setType(IQ.Type.GET);
        request.setTo(this.to);
        request.addExtension((PacketExtension)ext);
        PubSub result = (PubSub)SyncPacketSend.getReply((Connection)this.connection, (Packet)request);
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        if (handler != null) {
            SetExtension setElem = (SetExtension)result.getExtension("set", "http://jabber.org/protocol/pubsub");
            handler.setCount(setElem.getCount());
            handler.setFirstId(setElem.getFirstId());
            handler.setFirstIndex(setElem.getFirstIndex());
            handler.setLastId(setElem.getLastId());
        }
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(int maxItems, String afterId, Metadata handler) throws XMPPException {
        String nodeName = this.leafNode.getId();
        GetItemsRequest ext = new GetItemsRequest(nodeName, maxItems, null, afterId);
        PubSub request = new PubSub();
        request.setType(IQ.Type.GET);
        request.setTo(this.to);
        request.addExtension((PacketExtension)ext);
        PubSub result = (PubSub)SyncPacketSend.getReply((Connection)this.connection, (Packet)request);
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        if (handler != null) {
            SetExtension setElem = (SetExtension)result.getExtension("set", "http://jabber.org/protocol/pubsub");
            handler.setCount(setElem.getCount());
            handler.setFirstId(setElem.getFirstId());
            handler.setFirstIndex(setElem.getFirstIndex());
            handler.setLastId(setElem.getLastId());
        }
        return itemsElem.getItems();
    }
}

