/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.xmpp;

import com.neuedu.educloud.api.xmpp.CharReplace;
import com.neuedu.educloud.api.xmpp.ClientEventListener;
import com.neuedu.educloud.api.xmpp.ClientPublishEvent;
import com.neuedu.educloud.api.xmpp.ItemProvider;
import com.neuedu.educloud.api.xmpp.ItemsExtension;
import com.neuedu.educloud.api.xmpp.ItemsProvider;
import com.neuedu.educloud.api.xmpp.SetProvider;
import com.neuedu.educloud.api.xmpp.SysMessage;
import com.neuedu.educloud.api.xmpp.XmsNode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.Header;
import org.jivesoftware.smackx.packet.HeadersExtension;
import org.jivesoftware.smackx.provider.DataFormProvider;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.provider.FormNodeProvider;
import org.jivesoftware.smackx.pubsub.provider.SubscriptionProvider;

public final class XmsClient {
    protected ConcurrentHashMap<ClientEventListener, PacketListener> itemEventToListenerMap = new ConcurrentHashMap();
    private static XmsClient _client;
    private Connection connection = null;
    private String domain = "rdyun.com";
    private String user = null;
    private String passwd = null;

    static {
        SetProvider setProvider = new SetProvider();
        ProviderManager.getInstance().addExtensionProvider("set", "http://jabber.org/protocol/pubsub", (Object)setProvider);
        ItemProvider itemProvider = new ItemProvider();
        ProviderManager.getInstance().addExtensionProvider("item", "http://jabber.org/protocol/pubsub", (Object)itemProvider);
        ProviderManager.getInstance().addExtensionProvider("item", "http://jabber.org/protocol/pubsub#event", (Object)itemProvider);
        ItemsProvider itemsProvider = new ItemsProvider();
        ProviderManager.getInstance().addExtensionProvider("items", "http://jabber.org/protocol/pubsub", (Object)itemsProvider);
        ProviderManager.getInstance().addExtensionProvider("items", "http://jabber.org/protocol/pubsub#event", (Object)itemsProvider);
        FormNodeProvider formNodeProvider = new FormNodeProvider();
        ProviderManager.getInstance().addExtensionProvider("options", "http://jabber.org/protocol/pubsub", (Object)formNodeProvider);
        ProviderManager.getInstance().addExtensionProvider("options", "http://jabber.org/protocol/pubsub#event", (Object)formNodeProvider);
        SubscriptionProvider subscriptionProvider = new SubscriptionProvider();
        ProviderManager.getInstance().addExtensionProvider("subscription", "http://jabber.org/protocol/pubsub", (Object)subscriptionProvider);
        DataFormProvider dataFormProvider = new DataFormProvider();
        ProviderManager.getInstance().addExtensionProvider("x", "jabber:x:data", (Object)dataFormProvider);
        _client = null;
    }

    public static XmsClient getXmsClient(String server, int port) {
        if (_client == null) {
            _client = new XmsClient(server, port);
        }
        return _client;
    }

    public static XmsClient getXmsClient(Hashtable<String, String> props) {
        if (_client == null) {
            String server = props.get("xmpp.connection.server");
            String port = props.get("xmpp.connection.port");
            String compression = props.get("xmpp.connection.compression");
            String sasl_authentication = props.get("xmpp.connection.sasl_authentication");
            String domain = props.get("xmpp.connection.domain");
            String user = props.get("xmpp.admin.user");
            String passwd = props.get("xmpp.admin.passwd");
            _client = new XmsClient(server, Integer.valueOf(port), Boolean.valueOf(compression), Boolean.valueOf(sasl_authentication));
            _client.setDomain(domain);
            _client.setUser(user);
            _client.setPasswd(passwd);
        }
        return _client;
    }

    XmsClient(String server, int port) {
        ConnectionConfiguration config = new ConnectionConfiguration(server, port);
        this.connection = new XMPPConnection(config);
    }

    XmsClient(String server, int port, boolean compression, boolean sasl_authentication) {
        ConnectionConfiguration config = new ConnectionConfiguration(server, port);
        if ("true".equals(compression)) {
            config.setCompressionEnabled(true);
        }
        if ("true".equals(sasl_authentication)) {
            config.setSASLAuthenticationEnabled(true);
        }
        this.connection = new XMPPConnection(config);
    }

    public XmsClient(Connection conn) {
        this.connection = conn;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void connect() throws XMPPException {
        this.connection.connect();
        this.connection.login(this.user, this.passwd);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void send(String to_userId, SysMessage message) {
        if (message == null || to_userId == null) {
            throw new RuntimeException("Parameter is null.");
        }
        if ("".equals(to_userId)) {
            throw new RuntimeException("Parameter is \"\".");
        }
        Message msg = new Message();
        msg.setType(Message.Type.normal);
        msg.setTo(String.valueOf(to_userId) + "@" + this.domain);
        msg.setBody(message.toString());
        msg.setSubject(message.getSubject());
        this.connection.sendPacket((Packet)msg);
    }

    public void send(String to_userId, String subject, String message) {
        if ("sys-msg".equals(subject)) {
            throw new RuntimeException("Subject error.");
        }
        if (message == null || to_userId == null || subject == null) {
            throw new RuntimeException("Parameter is null.");
        }
        if ("".equals(message) || "".equals(to_userId) || "".equals(subject)) {
            throw new RuntimeException("Parameter is \"\".");
        }
        Message msg = new Message();
        msg.setType(Message.Type.normal);
        msg.setTo(String.valueOf(to_userId) + "@" + this.domain);
        message = CharReplace.replaceSpecialChar(message);
        msg.setBody(message);
        msg.setSubject(subject);
        this.connection.sendPacket((Packet)msg);
    }

    public void sendPacket(Message packet) {
        this.connection.sendPacket((Packet)packet);
    }

    public XmsNode findNode(String nodeName) throws XMPPException {
        String toAddress = "pubsub." + this.domain;
        PubSubManager mgr = new PubSubManager(this.connection, toAddress);
        LeafNode leafNode = (LeafNode)mgr.getNode(nodeName);
        XmsNode xmsNode = new XmsNode(leafNode, this.connection, toAddress);
        return xmsNode;
    }

    public void addClientEventListener(ClientEventListener listener) {
        ClientEventTranslator conListener = new ClientEventTranslator(listener);
        this.itemEventToListenerMap.put(listener, conListener);
        this.connection.addPacketListener((PacketListener)conListener, (PacketFilter)new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeClientEventListener(ClientEventListener listener) {
        PacketListener conListener = this.itemEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.connection.removePacketListener(conListener);
        }
    }

    private static List<String> getSubscriptionIds(Packet packet) {
        HeadersExtension headers = (HeadersExtension)packet.getExtension("headers", "http://jabber.org/protocol/shim");
        ArrayList<String> values = null;
        if (headers != null) {
            values = new ArrayList<String>(headers.getHeaders().size());
            for (Header header : headers.getHeaders()) {
                values.add(header.getValue());
            }
        }
        return values;
    }

    public class ClientEventTranslator
    implements PacketListener {
        private ClientEventListener listener;

        public ClientEventTranslator(ClientEventListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Packet packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
            DelayInformation delay = (DelayInformation)packet.getExtension("delay", "urn:xmpp:delay");
            if (delay == null) {
                delay = (DelayInformation)packet.getExtension("x", "jabber:x:delay");
            }
            String nodeTitle = itemsElem.getNodeTitle();
            ClientPublishEvent<? extends PacketExtension> eventItems = new ClientPublishEvent<PacketExtension>(itemsElem.getNode(), itemsElem.getNodeTitle(), itemsElem.getItems(), XmsClient.getSubscriptionIds(packet), delay == null ? null : delay.getStamp());
            this.listener.handlePublishedItems(eventItems);
        }
    }

    class EventContentFilter
    implements PacketFilter {
        private String firstElement;
        private String secondElement;

        EventContentFilter(String elementName) {
            this.firstElement = elementName;
        }

        EventContentFilter(String firstLevelEelement, String secondLevelElement) {
            this.firstElement = firstLevelEelement;
            this.secondElement = secondLevelElement;
        }

        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            if (event == null) {
                return false;
            }
            NodeExtension embedEvent = event.getEvent();
            if (embedEvent == null) {
                return false;
            }
            if (embedEvent.getElementName().equals(this.firstElement)) {
                List secondLevelList;
                if (this.secondElement == null) {
                    return true;
                }
                if (embedEvent instanceof EmbeddedPacketExtension && (secondLevelList = ((EmbeddedPacketExtension)embedEvent).getExtensions()).size() > 0 && ((PacketExtension)secondLevelList.get(0)).getElementName().equals(this.secondElement)) {
                    return true;
                }
            }
            return false;
        }
    }
}

