/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.xmpp;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.Item;

public class PayloadItem<E extends PacketExtension>
extends Item {
    private E payload;
    private String publishedDate;

    public PayloadItem(String itemId, E payloadExt) {
        super(itemId);
        if (payloadExt == null) {
            throw new IllegalArgumentException("payload cannot be 'null'");
        }
        this.payload = payloadExt;
    }

    public PayloadItem(String itemId, String publishedDate, E payloadExt) {
        super(itemId);
        this.publishedDate = publishedDate;
        if (payloadExt == null) {
            throw new IllegalArgumentException("payload cannot be 'null'");
        }
        this.payload = payloadExt;
    }

    public E getPayload() {
        return this.payload;
    }

    public String getPublishedDate() {
        return this.publishedDate;
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder("<item");
        if (this.getId() != null) {
            builder.append(" id='");
            builder.append(this.getId());
            builder.append("'");
        }
        if (this.publishedDate != null) {
            builder.append(" publishedDate='");
            builder.append(this.publishedDate);
            builder.append("'");
        }
        builder.append(">");
        builder.append(this.payload.toXML());
        builder.append("</item>");
        return builder.toString();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + " | Content [" + this.toXML() + "]";
    }
}

