/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.xmpp;

import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class ItemsExtension
extends NodeExtension
implements EmbeddedPacketExtension {
    protected ItemsElementType type;
    private String nodeTitle;
    protected Boolean notify;
    protected List<? extends PacketExtension> items;

    public ItemsExtension(ItemsElementType itemsType, String nodeId, String nodeTitle, List<? extends PacketExtension> items) {
        super(itemsType.getNodeElement(), nodeId);
        this.type = itemsType;
        this.nodeTitle = nodeTitle;
        this.items = items;
    }

    public ItemsExtension(String nodeId, List<? extends PacketExtension> items, boolean notify) {
        super(ItemsElementType.retract.getNodeElement(), nodeId);
        this.type = ItemsElementType.retract;
        this.items = items;
        this.notify = notify;
    }

    public ItemsElementType getItemsElementType() {
        return this.type;
    }

    public List<PacketExtension> getExtensions() {
        return this.getItems();
    }

    public List<? extends PacketExtension> getItems() {
        return this.items;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public String getNodeTitle() {
        return this.nodeTitle;
    }

    public String toXML() {
        if (this.items == null || this.items.size() == 0) {
            return super.toXML();
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.getElementName());
        builder.append(" node='");
        builder.append(this.getNode());
        if (this.notify != null) {
            builder.append("' ");
            builder.append(this.type.getElementAttribute());
            builder.append("='");
            builder.append(this.notify.equals(Boolean.TRUE) ? 1 : 0);
            builder.append("'>");
        } else {
            builder.append("'>");
            for (PacketExtension packetExtension : this.items) {
                builder.append(packetExtension.toXML());
            }
        }
        builder.append("</");
        builder.append(this.getElementName());
        builder.append(">");
        return builder.toString();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "Content [" + this.toXML() + "]";
    }

    public static enum ItemsElementType {
        items(PubSubElementType.ITEMS, "max_items"),
        retract(PubSubElementType.RETRACT, "notify");

        private PubSubElementType elem;
        private String att;

        private ItemsElementType(PubSubElementType nodeElement, String attribute) {
            this.elem = nodeElement;
            this.att = attribute;
        }

        public PubSubElementType getNodeElement() {
            return this.elem;
        }

        public String getElementAttribute() {
            return this.att;
        }
    }
}

