/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.oauth;

import com.neuedu.educloud.api.ApiException;
import com.neuedu.educloud.api.http.HttpResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class AccessTokenResponse {
    private Map<String, Object> params = null;
    public int responseCode = -1;
    public String accessToken = null;
    public String refreshToken = null;
    public int expiresIn = 0;
    public long deadTimeMillis = -1L;
    public String userId = null;
    public String error = null;
    public boolean hasError = false;
    public boolean isExpiredToken = false;

    AccessTokenResponse(HttpResponse httpres) throws ApiException {
        this.responseCode = httpres.getResponseCode();
        this.parseResponse(httpres);
    }

    private void parseResponse(HttpResponse httpres) throws ApiException {
        try {
            String jsonBody = httpres.getContent("utf-8");
            this.params = new HashMap<String, Object>();
            JSONObject obj = new JSONObject(jsonBody);
            Iterator it = obj.keys();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof String)) continue;
                String key = (String)o;
                this.params.put(key, obj.get(key));
            }
            Object success = this.params.get("success");
            if (success.equals(Boolean.FALSE)) {
                this.hasError = true;
                JSONObject jsono = (JSONObject)this.params.get("result");
                this.error = (String)jsono.get("error");
                if (this.error.equals("expired_token")) {
                    this.isExpiredToken = true;
                }
            } else {
                this.accessToken = (String)this.params.get("access_token");
                this.refreshToken = (String)this.params.get("refresh_token");
                this.userId = (String)this.params.get("uid");
                this.expiresIn = (Integer)this.params.get("expires_in");
                this.deadTimeMillis = System.currentTimeMillis() + (long)(this.expiresIn * 1000);
            }
        }
        catch (JSONException e) {
            throw ApiException.error(1282, e);
        }
    }

    public Object getProperty(String key) {
        return this.params.get(key);
    }
}

