/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.http;

import com.neuedu.educloud.api.ApiException;
import com.neuedu.educloud.api.http.HttpRequest;
import com.neuedu.educloud.api.http.HttpRequestFactory;
import com.neuedu.educloud.api.http.HttpTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public final class UrlConnectionTransport
extends HttpTransport
implements Cloneable {
    private URLConnection httpconn = null;
    private String keystoreFile = null;
    private String keystorePass = null;
    private String truststoreFile = null;
    private String truststorePass = null;

    @Override
    public void setKeystore(String keystoreFile, String keystorePass) {
        this.setKeystore(keystoreFile, keystorePass, keystoreFile, keystorePass);
    }

    @Override
    public void setKeystore(String keystoreFile, String keystorePass, String truststoreFile, String truststorePass) {
        this.keystoreFile = keystoreFile;
        this.keystorePass = keystorePass;
        this.truststoreFile = truststoreFile;
        this.truststorePass = truststorePass;
    }

    @Override
    public HttpRequestFactory createRequestFactory(String accessToken) throws ApiException {
        try {
            UrlConnectionTransport trans = (UrlConnectionTransport)this.clone();
            HttpRequestFactory hrf = new HttpRequestFactory(accessToken, trans);
            return hrf;
        }
        catch (CloneNotSupportedException e) {
            throw ApiException.error(263, e);
        }
    }

    @Override
    public HttpRequestFactory createRequestFactory() throws ApiException {
        try {
            UrlConnectionTransport trans = (UrlConnectionTransport)this.clone();
            HttpRequestFactory hrf = new HttpRequestFactory(trans);
            return hrf;
        }
        catch (CloneNotSupportedException e) {
            throw ApiException.error(263, e);
        }
    }

    @Override
    HttpRequest buildRequest(String url, String method, String contentType, String ... headers) throws ApiException {
        boolean isSecurity = false;
        try {
            String surl = url.toLowerCase();
            isSecurity = surl.startsWith("https://");
            if (isSecurity) {
                this.initHttpsUrlConnection();
            }
            URL oURL = new URL(url);
            URLConnection c = oURL.openConnection();
            this.httpconn = isSecurity ? (HttpsURLConnection)c : (HttpURLConnection)c;
            this.httpconn.addRequestProperty("Content-Type", contentType);
            if (headers != null) {
                int i = 0;
                while (i < headers.length) {
                    this.httpconn.addRequestProperty(headers[i], headers[++i]);
                    ++i;
                }
            }
            ((HttpURLConnection)this.httpconn).setRequestMethod(method);
            return new HttpRequest(this);
        }
        catch (Exception e) {
            throw ApiException.error(257, e);
        }
    }

    @Override
    InputStream getInputStream() throws ApiException {
        try {
            return this.httpconn.getInputStream();
        }
        catch (IOException e) {
            throw ApiException.error(260, e);
        }
    }

    @Override
    void connect() throws ApiException {
        try {
            this.httpconn.connect();
        }
        catch (IOException e) {
            throw ApiException.error(258, e);
        }
    }

    @Override
    OutputStream getOutputStream() throws ApiException {
        try {
            this.httpconn.setDoOutput(true);
            return this.httpconn.getOutputStream();
        }
        catch (IOException e) {
            throw ApiException.error(259, e);
        }
    }

    @Override
    int getResponseCode() throws ApiException {
        try {
            return ((HttpURLConnection)this.httpconn).getResponseCode();
        }
        catch (IOException e) {
            throw ApiException.error(259, e);
        }
    }

    @Override
    InputStream getErrorStream() throws ApiException {
        try {
            return ((HttpURLConnection)this.httpconn).getErrorStream();
        }
        catch (Exception e) {
            throw ApiException.error(262, e);
        }
    }

    @Override
    String getCookies() throws ApiException {
        return this.httpconn.getRequestProperty("JSESSIONID");
    }

    @Override
    String getContextType() throws ApiException {
        return this.httpconn.getContentType();
    }

    private KeyStore getKeyStore(String password, String keyStorePath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = null;
        try (InputStream is = null;){
            ks = KeyStore.getInstance("JKS");
            is = UrlConnectionTransport.class.getResourceAsStream(keyStorePath);
            ks.load(is, password.toCharArray());
        }
        return ks;
    }

    private SSLContext getSSLContext() throws Exception {
        System.setProperty("javax.net.ssl.keyStore", this.keystoreFile);
        System.setProperty("javax.net.ssl.keyStorePassword", this.keystorePass);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = this.getKeyStore(this.keystorePass, this.keystoreFile);
        keyManagerFactory.init(keyStore, this.keystorePass.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = this.getKeyStore(this.truststorePass, this.truststoreFile);
        trustManagerFactory.init(trustStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }

    private void initHttpsUrlConnection() throws Exception {
        SSLContext sslContext = null;
        HostnameVerifier hnv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return hostname.equalsIgnoreCase(session.getPeerHost());
            }
        };
        sslContext = this.getSSLContext();
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hnv);
    }
}

