/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.http;

import com.neuedu.educloud.api.ApiException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class HttpResponse {
    private int responseCode = 200;
    private String cookies = "";
    private String contentType = "";
    private InputStream is = null;

    HttpResponse(InputStream is, int responseCode, String cookies, String contentType) {
        this.is = is;
        this.responseCode = responseCode;
        this.cookies = cookies;
        this.contentType = contentType;
    }

    public String getCookies() {
        return this.cookies;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getContent(String charset) throws ApiException {
        StringBuilder sb;
        try {
            if (charset == null) {
                int cs0 = this.contentType.indexOf("charset");
                charset = cs0 > 0 ? this.contentType.substring(cs0 + 7).split("=")[1].trim() : "utf-8";
            }
            sb = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(this.is, charset);){
                int l;
                char[] tmp = new char[4096];
                while ((l = reader.read(tmp)) != -1) {
                    sb.append(tmp, 0, l);
                }
            }
        }
        catch (Exception e) {
            throw ApiException.error(1025, e);
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        return this.is;
    }
}

