/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.api.http;

import com.neuedu.educloud.api.ApiException;
import com.neuedu.educloud.api.http.HttpRequest;
import com.neuedu.educloud.api.http.HttpTransport;
import java.io.IOException;
import java.io.OutputStream;

public final class HttpRequestFactory {
    private static final String ContentType_Form = "application/x-www-form-urlencoded";
    private String accessToken = null;
    private HttpTransport httptrans = null;

    public HttpRequestFactory(HttpTransport transport) {
        this.httptrans = transport;
    }

    HttpRequestFactory(String accessToken, HttpTransport transport) {
        this.httptrans = transport;
        this.accessToken = accessToken;
    }

    public HttpRequest buildPostRequest(String url, byte[] data) throws ApiException {
        return this.buildPostRequest(url, data, ContentType_Form, null);
    }

    public HttpRequest buildPostRequest(String url, byte[] data, String contentType, String ... headers) throws ApiException {
        return this.buildPostRequest(url, data, 0, data == null ? 0 : data.length, contentType, headers);
    }

    public HttpRequest buildPostRequest(String url, byte[] data, int off, int len, String contentType, String ... headers) throws ApiException {
        String[] params = this.fillToken(headers);
        HttpRequest hreq = this.httptrans.buildRequest(url, "POST", contentType, params);
        if (data != null) {
            OutputStream ost = this.httptrans.getOutputStream();
            try {
                ost.write(data, off, len);
                ost.close();
            }
            catch (IOException e) {
                throw ApiException.error(513, e);
            }
        }
        return hreq;
    }

    public HttpRequest buildPutRequest(String url, byte[] data) throws ApiException {
        return this.buildPostRequest(url, data, ContentType_Form, null);
    }

    public HttpRequest buildPutRequest(String url, byte[] data, String contentType, String ... headers) throws ApiException {
        return this.buildPutRequest(url, data, 0, data == null ? 0 : data.length, contentType, headers);
    }

    public HttpRequest buildPutRequest(String url, byte[] data, int off, int len, String contentType, String ... headers) throws ApiException {
        String[] params = this.fillToken(headers);
        HttpRequest hreq = this.httptrans.buildRequest(url, "PUT", contentType, params);
        if (data != null) {
            OutputStream ost = this.httptrans.getOutputStream();
            try {
                ost.write(data, off, len);
                ost.close();
            }
            catch (IOException e) {
                throw ApiException.error(513, e);
            }
        }
        return hreq;
    }

    public HttpRequest buildGetRequest(String url) throws ApiException {
        return this.buildGetRequest(url, ContentType_Form, null);
    }

    public HttpRequest buildGetRequest(String url, String contentType, String ... headers) throws ApiException {
        String[] params = this.fillToken(headers);
        HttpRequest hreq = this.httptrans.buildRequest(url, "GET", contentType, params);
        return hreq;
    }

    public HttpRequest buildDeleteRequest(String url) throws ApiException {
        return this.buildGetRequest(url, ContentType_Form, null);
    }

    public HttpRequest buildDeleteRequest(String url, String contentType, String ... headers) throws ApiException {
        String[] params = this.fillToken(headers);
        HttpRequest hreq = this.httptrans.buildRequest(url, "DELETE", contentType, params);
        return hreq;
    }

    private String[] fillToken(String[] headers) {
        String[] params = null;
        if (this.accessToken != null) {
            params = headers != null ? new String[headers.length + 2] : new String[]{"Authorization", "Bearer " + this.accessToken};
            if (headers != null) {
                System.arraycopy(headers, 0, params, 2, headers.length);
            }
        } else {
            params = headers;
        }
        return params;
    }
}

