/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.layout.Region;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class PieChart
extends Chart {
    private static final int MIN_PIE_RADIUS = 25;
    private int defaultColorIndex = 0;
    private static final double LABEL_TICK_GAP = 6.0;
    private static final double LABEL_BALL_RADIUS = 2.0;
    private double centerX;
    private double centerY;
    private double pieRadius;
    private Data begin = null;
    private final Path labelLinePath = new Path();
    private Legend legend = new Legend();
    private Data dataItemBeingRemoved = null;
    private Timeline dataRemoveTimeline = null;
    private final ListChangeListener<Data> dataChangeListener = new ListChangeListener<Data>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public void onChanged(ListChangeListener.Change<? extends Data> change) {
            while (change.next()) {
                int n;
                for (n = change.getFrom(); n < change.getTo(); ++n) {
                    void var3_6;
                    ((Data)PieChart.this.getData().get(n)).setChart(PieChart.this);
                    if (PieChart.this.begin == null) {
                        PieChart.this.begin = (Data)PieChart.this.getData().get(n);
                        PieChart.this.begin.next = null;
                        continue;
                    }
                    if (n == 0) {
                        ((Data)PieChart.this.getData().get(0)).next = PieChart.this.begin;
                        PieChart.this.begin = (Data)PieChart.this.getData().get(0);
                        continue;
                    }
                    Data data = PieChart.this.begin;
                    for (int i = 0; i < n - 1; ++i) {
                        Data data2 = ((Data)var3_6).next;
                    }
                    ((Data)PieChart.this.getData().get(n)).next = ((Data)var3_6).next;
                    ((Data)var3_6).next = (Data)PieChart.this.getData().get(n);
                }
                for (Data data : change.getRemoved()) {
                    PieChart.this.dataItemRemoved(data);
                }
                for (n = change.getFrom(); n < change.getTo(); ++n) {
                    Data data = (Data)PieChart.this.getData().get(n);
                    PieChart.this.dataItemAdded(n, data);
                }
                if (change.getRemoved().size() <= 0 && change.getFrom() >= change.getTo()) continue;
                PieChart.this.updateLegend();
            }
            PieChart.this.requestChartLayout();
        }
    };
    private ObjectProperty<ObservableList<Data>> data = new ObjectPropertyBase<ObservableList<Data>>(){
        private ObservableList<Data> old;

        @Override
        protected void invalidated() {
            ObservableList observableList = (ObservableList)this.getValue();
            if (this.old != null) {
                this.old.removeListener(PieChart.this.dataChangeListener);
            }
            if (observableList != null) {
                observableList.addListener(PieChart.this.dataChangeListener);
            }
            if (this.old != null || observableList != null) {
                int n;
                final List list = this.old != null ? this.old : Collections.emptyList();
                int n2 = n = observableList != null ? observableList.size() : 0;
                if (n > 0 || !list.isEmpty()) {
                    PieChart.this.dataChangeListener.onChanged(new NonIterableChange<Data>(0, n, observableList){

                        @Override
                        public List<Data> getRemoved() {
                            return list;
                        }

                        @Override
                        public boolean wasPermutated() {
                            return false;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
            } else if (this.old != null && this.old.size() > 0) {
                PieChart.this.dataChangeListener.onChanged(new NonIterableChange<Data>(0, 0, observableList){

                    @Override
                    public List<Data> getRemoved() {
                        return old;
                    }

                    @Override
                    public boolean wasPermutated() {
                        return false;
                    }

                    @Override
                    protected int[] getPermutation() {
                        return new int[0];
                    }
                });
            }
            this.old = observableList;
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "data";
        }
    };
    private DoubleProperty startAngle = new StyleableDoubleProperty(0.0){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "startAngle";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.START_ANGLE;
        }
    };
    private BooleanProperty clockwise = new StyleableBooleanProperty(true){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "clockwise";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.CLOCKWISE;
        }
    };
    private DoubleProperty labelLineLength = new StyleableDoubleProperty(20.0){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "labelLineLength";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.LABEL_LINE_LENGTH;
        }
    };
    private BooleanProperty labelsVisible = new StyleableBooleanProperty(true){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "labelsVisible";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.LABELS_VISIBLE;
        }
    };

    public final ObservableList<Data> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<Data> observableList) {
        this.data.setValue(observableList);
    }

    public final ObjectProperty<ObservableList<Data>> dataProperty() {
        return this.data;
    }

    public final double getStartAngle() {
        return this.startAngle.getValue();
    }

    public final void setStartAngle(double d) {
        this.startAngle.setValue(d);
    }

    public final DoubleProperty startAngleProperty() {
        return this.startAngle;
    }

    public final void setClockwise(boolean bl) {
        this.clockwise.setValue(bl);
    }

    public final boolean isClockwise() {
        return this.clockwise.getValue();
    }

    public final BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    public final double getLabelLineLength() {
        return this.labelLineLength.getValue();
    }

    public final void setLabelLineLength(double d) {
        this.labelLineLength.setValue(d);
    }

    public final DoubleProperty labelLineLengthProperty() {
        return this.labelLineLength;
    }

    public final void setLabelsVisible(boolean bl) {
        this.labelsVisible.setValue(bl);
    }

    public final boolean getLabelsVisible() {
        return this.labelsVisible.getValue();
    }

    public final BooleanProperty labelsVisibleProperty() {
        return this.labelsVisible;
    }

    public PieChart() {
        this(FXCollections.observableArrayList());
    }

    public PieChart(ObservableList<Data> observableList) {
        this.getChartChildren().add(this.labelLinePath);
        this.labelLinePath.getStyleClass().add("chart-pie-label-line");
        this.setLegend(this.legend);
        this.setData(observableList);
    }

    private void dataNameChanged(Data data) {
        this.requestChartLayout();
    }

    private void dataPieValueChanged(Data data) {
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentPieValueProperty(), data.getCurrentPieValue())), new KeyFrame(Duration.millis(500.0), new KeyValue(data.currentPieValueProperty(), data.getPieValue(), Interpolator.EASE_BOTH)));
        } else {
            data.setCurrentPieValue(data.getPieValue());
        }
    }

    private Node createArcRegion(int n, Data data) {
        Node node = data.getNode();
        if (node == null) {
            node = new Region();
            node.setPickOnBounds(false);
            data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-pie", "data" + n, data.defaultColorStyleString});
        if (data.getPieValue() < 0.0) {
            node.getStyleClass().add("negative");
        }
        return node;
    }

    private Text createPieLabel(int n, Data data) {
        Text text = data.textNode;
        text.setText(data.getName());
        return text;
    }

    private void dataItemAdded(int n, final Data data) {
        data.defaultColorStyleString = "default-color" + this.defaultColorIndex % 8;
        ++this.defaultColorIndex;
        Node node = this.createArcRegion(n, data);
        final Text text = this.createPieLabel(n, data);
        data.getChart().getChartChildren().add(node);
        if (this.shouldAnimate()) {
            if (this.dataRemoveTimeline != null && this.dataRemoveTimeline.getStatus().equals((Object)Animation.Status.RUNNING) && this.dataItemBeingRemoved == data) {
                this.dataRemoveTimeline.stop();
                this.dataRemoveTimeline = null;
                this.getChartChildren().remove(data.textNode);
                this.getChartChildren().remove(node);
                this.removeDataItemRef(data);
            }
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentPieValueProperty(), data.getCurrentPieValue()), new KeyValue(data.radiusMultiplierProperty(), data.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    text.setOpacity(0.0);
                    if (data.getChart() == null) {
                        data.setChart(PieChart.this);
                    }
                    data.getChart().getChartChildren().add(text);
                    FadeTransition fadeTransition = new FadeTransition(Duration.millis(150.0), text);
                    fadeTransition.setToValue(1.0);
                    fadeTransition.play();
                }
            }, new KeyValue(data.currentPieValueProperty(), data.getPieValue(), Interpolator.EASE_BOTH), new KeyValue(data.radiusMultiplierProperty(), 1, Interpolator.EASE_BOTH)));
        } else {
            this.getChartChildren().add(text);
            data.setRadiusMultiplier(1.0);
            data.setCurrentPieValue(data.getPieValue());
        }
    }

    private void removeDataItemRef(Data data) {
        if (this.begin == data) {
            this.begin = data.next;
        } else {
            Data data2 = this.begin;
            while (data2 != null && data2.next != data) {
                data2 = data2.next;
            }
            if (data2 != null) {
                data2.next = data.next;
            }
        }
    }

    private Timeline createDataRemoveTimeline(final Data data) {
        final Node node = data.getNode();
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(data.currentPieValueProperty(), data.getCurrentPieValue()), new KeyValue(data.radiusMultiplierProperty(), data.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                PieChart.this.getChartChildren().remove(node);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(150.0), data.textNode);
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        PieChart.this.getChartChildren().remove(data.textNode);
                        data.setChart(null);
                        PieChart.this.removeDataItemRef(data);
                    }
                });
                fadeTransition.play();
            }
        }, new KeyValue(data.currentPieValueProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(data.radiusMultiplierProperty(), 0))});
        return timeline;
    }

    private void dataItemRemoved(Data data) {
        Node node = data.getNode();
        if (this.shouldAnimate()) {
            this.dataRemoveTimeline = this.createDataRemoveTimeline(data);
            this.dataItemBeingRemoved = data;
            this.animate(this.dataRemoveTimeline);
        } else {
            this.getChartChildren().remove(data.textNode);
            this.getChartChildren().remove(node);
            data.setChart(null);
            this.removeDataItemRef(data);
        }
    }

    @Override
    protected void layoutChartChildren(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        int n;
        this.centerX = d3 / 2.0 + d2;
        this.centerY = d4 / 2.0 + d;
        double d9 = 0.0;
        Data data = this.begin;
        while (data != null) {
            d9 += Math.abs(data.getCurrentPieValue());
            data = data.next;
        }
        double d10 = d9 != 0.0 ? 360.0 / d9 : 0.0;
        this.labelLinePath.getElements().clear();
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double d15 = 1.0;
        ArrayList<LabelLayoutInfo> arrayList = null;
        boolean bl = this.getLabelsVisible();
        if (this.getLabelsVisible()) {
            dArray = new double[this.getDataSize()];
            dArray2 = new double[this.getDataSize()];
            dArray3 = new double[this.getDataSize()];
            arrayList = new ArrayList<LabelLayoutInfo>();
            n = 0;
            double d16 = this.getStartAngle();
            Data data2 = this.begin;
            while (data2 != null) {
                data2.textNode.getTransforms().clear();
                double d17 = this.isClockwise() ? -d10 * Math.abs(data2.getCurrentPieValue()) : d10 * Math.abs(data2.getCurrentPieValue());
                dArray3[n] = PieChart.normalizeAngle(d16 + d17 / 2.0);
                d8 = PieChart.calcX(dArray3[n], this.getLabelLineLength(), 0.0);
                double d18 = PieChart.calcY(dArray3[n], this.getLabelLineLength(), 0.0);
                dArray[n] = d8;
                dArray2[n] = d18;
                if (d8 < 0.0) {
                    d11 = Math.min(d11, d8 - data2.textNode.getLayoutBounds().getWidth() - 6.0);
                } else {
                    d13 = Math.max(d13, d8 + data2.textNode.getLayoutBounds().getWidth() + 6.0);
                }
                if (d18 > 0.0) {
                    d14 = Math.max(d14, d18 + data2.textNode.getLayoutBounds().getMaxY());
                } else {
                    d12 = Math.min(d12, d18 + data2.textNode.getLayoutBounds().getMinY());
                }
                d16 += d17;
                ++n;
                data2 = data2.next;
            }
            double d19 = Math.max(Math.abs(d11), Math.abs(d13)) * 2.0;
            d7 = Math.max(Math.abs(d12), Math.abs(d14)) * 2.0;
            this.pieRadius = Math.min(d3 - d19, d4 - d7) / 2.0;
            if (this.pieRadius < 25.0) {
                d6 = d3 - 25.0 - 25.0;
                d5 = d4 - 25.0 - 25.0;
                d15 = Math.min(d6 / d19, d5 / d7);
                if (this.begin == null && d15 < 0.7 || this.begin.textNode.getFont().getSize() * d15 < 9.0) {
                    bl = false;
                    d15 = 1.0;
                } else {
                    this.pieRadius = 25.0;
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = dArray[i] * d15;
                        dArray2[i] = dArray2[i] * d15;
                    }
                }
            }
        }
        if (!bl) {
            this.pieRadius = Math.min(d3, d4) / 2.0;
        }
        if (this.getChartChildren().size() > 0) {
            n = 0;
            Data data3 = this.begin;
            while (data3 != null) {
                data3.textNode.setVisible(bl);
                if (bl) {
                    double d20 = this.isClockwise() ? -d10 * Math.abs(data3.getCurrentPieValue()) : d10 * Math.abs(data3.getCurrentPieValue());
                    boolean bl2 = !(dArray3[n] > -90.0) || !(dArray3[n] < 90.0);
                    d7 = PieChart.calcX(dArray3[n], this.pieRadius, this.centerX);
                    d6 = PieChart.calcY(dArray3[n], this.pieRadius, this.centerY);
                    d5 = bl2 ? dArray[n] + d7 - data3.textNode.getLayoutBounds().getMaxX() - 6.0 : dArray[n] + d7 - data3.textNode.getLayoutBounds().getMinX() + 6.0;
                    double d21 = dArray2[n] + d6 - data3.textNode.getLayoutBounds().getMinY() / 2.0 - 2.0;
                    double d22 = d7 + dArray[n];
                    double d23 = d6 + dArray2[n];
                    LabelLayoutInfo labelLayoutInfo = new LabelLayoutInfo(d7, d6, d22, d23, d5, d21, data3.textNode, Math.abs(d20));
                    arrayList.add(labelLayoutInfo);
                    if (d15 < 1.0) {
                        data3.textNode.getTransforms().add(new Scale(d15, d15, bl2 ? data3.textNode.getLayoutBounds().getWidth() : 0.0, 0.0));
                    }
                }
                ++n;
                data3 = data3.next;
            }
            this.resolveCollision(arrayList);
            double d24 = this.getStartAngle();
            Object object = this.begin;
            while (object != null) {
                Node node = ((Data)object).getNode();
                Arc arc = null;
                if (node != null && node instanceof Region) {
                    Region region = (Region)node;
                    if (region.impl_getShape() == null) {
                        arc = new Arc();
                        region.impl_setShape(arc);
                    } else {
                        arc = (Arc)region.impl_getShape();
                    }
                    region.impl_setShape(null);
                    region.impl_setShape(arc);
                    region.impl_setScaleShape(false);
                    region.impl_setPositionShape(false);
                }
                d8 = this.isClockwise() ? -d10 * Math.abs(((Data)object).getCurrentPieValue()) : d10 * Math.abs(((Data)object).getCurrentPieValue());
                arc.setStartAngle(d24);
                arc.setLength(d8);
                arc.setType(ArcType.ROUND);
                arc.setRadiusX(this.pieRadius * ((Data)object).getRadiusMultiplier());
                arc.setRadiusY(this.pieRadius * ((Data)object).getRadiusMultiplier());
                node.setLayoutX(this.centerX);
                node.setLayoutY(this.centerY);
                d24 += d8;
                object = ((Data)object).next;
            }
            if (arrayList != null) {
                for (LabelLayoutInfo labelLayoutInfo : arrayList) {
                    if (!labelLayoutInfo.text.isVisible()) continue;
                    this.drawLabelLinePath(labelLayoutInfo);
                }
            }
        }
    }

    private void resolveCollision(ArrayList<LabelLayoutInfo> arrayList) {
        int n = this.begin != null ? (int)this.begin.textNode.getLayoutBounds().getHeight() : 0;
        int n2 = 0;
        for (int i = 1; arrayList != null && i < arrayList.size(); ++i) {
            LabelLayoutInfo labelLayoutInfo = arrayList.get(n2);
            LabelLayoutInfo labelLayoutInfo2 = arrayList.get(i);
            if (labelLayoutInfo.text.isVisible() && labelLayoutInfo2.text.isVisible() && (this.fuzzyGT(labelLayoutInfo2.textY, labelLayoutInfo.textY) ? this.fuzzyLT(labelLayoutInfo2.textY - (double)n - labelLayoutInfo.textY, 2.0) : this.fuzzyLT(labelLayoutInfo.textY - (double)n - labelLayoutInfo2.textY, 2.0)) && (this.fuzzyGT(labelLayoutInfo.textX, labelLayoutInfo2.textX) ? this.fuzzyLT(labelLayoutInfo.textX - labelLayoutInfo2.textX, labelLayoutInfo2.text.prefWidth(-1.0)) : this.fuzzyLT(labelLayoutInfo2.textX - labelLayoutInfo.textX, labelLayoutInfo.text.prefWidth(-1.0)))) {
                if (this.fuzzyLT(labelLayoutInfo.size, labelLayoutInfo2.size)) {
                    labelLayoutInfo.text.setVisible(false);
                    n2 = i;
                    continue;
                }
                labelLayoutInfo2.text.setVisible(false);
                continue;
            }
            n2 = i;
        }
    }

    private int fuzzyCompare(double d, double d2) {
        double d3 = 1.0E-5;
        return Math.abs(d - d2) < d3 ? 0 : (d < d2 ? -1 : 1);
    }

    private boolean fuzzyGT(double d, double d2) {
        return this.fuzzyCompare(d, d2) == 1;
    }

    private boolean fuzzyLT(double d, double d2) {
        return this.fuzzyCompare(d, d2) == -1;
    }

    private void drawLabelLinePath(LabelLayoutInfo labelLayoutInfo) {
        labelLayoutInfo.text.setLayoutX(labelLayoutInfo.textX);
        labelLayoutInfo.text.setLayoutY(labelLayoutInfo.textY);
        this.labelLinePath.getElements().add(new MoveTo(labelLayoutInfo.startX, labelLayoutInfo.startY));
        this.labelLinePath.getElements().add(new LineTo(labelLayoutInfo.endX, labelLayoutInfo.endY));
        this.labelLinePath.getElements().add(new MoveTo(labelLayoutInfo.endX - 2.0, labelLayoutInfo.endY));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX, labelLayoutInfo.endY - 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX + 2.0, labelLayoutInfo.endY, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX, labelLayoutInfo.endY + 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX - 2.0, labelLayoutInfo.endY, false, true));
        this.labelLinePath.getElements().add(new ClosePath());
    }

    private void updateLegend() {
        this.legend.setVertical(this.getLegendSide().equals((Object)Side.LEFT) || this.getLegendSide().equals((Object)Side.RIGHT));
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (Data data : this.getData()) {
                Legend.LegendItem legendItem = new Legend.LegendItem(data.getName());
                legendItem.getSymbol().getStyleClass().addAll((Collection<String>)data.getNode().getStyleClass());
                legendItem.getSymbol().getStyleClass().add("pie-legend-symbol");
                this.legend.getItems().add(legendItem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private int getDataSize() {
        int n = 0;
        Data data = this.begin;
        while (data != null) {
            ++n;
            data = data.next;
        }
        return n;
    }

    private static double calcX(double d, double d2, double d3) {
        return d3 + d2 * Math.cos(Math.toRadians(-d));
    }

    private static double calcY(double d, double d2, double d3) {
        return d3 + d2 * Math.sin(Math.toRadians(-d));
    }

    private static double normalizeAngle(double d) {
        double d2 = d % 360.0;
        if (d2 <= -180.0) {
            d2 += 360.0;
        }
        if (d2 > 180.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return PieChart.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<PieChart, Boolean> CLOCKWISE = new StyleableProperty<PieChart, Boolean>("-fx-clockwise", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(PieChart pieChart) {
                return pieChart.clockwise == null || !pieChart.clockwise.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(PieChart pieChart) {
                return pieChart.clockwiseProperty();
            }
        };
        private static final StyleableProperty<PieChart, Boolean> LABELS_VISIBLE = new StyleableProperty<PieChart, Boolean>("-fx-pie-label-visible", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(PieChart pieChart) {
                return pieChart.labelsVisible == null || !pieChart.labelsVisible.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(PieChart pieChart) {
                return pieChart.labelsVisibleProperty();
            }
        };
        private static final StyleableProperty<PieChart, Number> LABEL_LINE_LENGTH = new StyleableProperty<PieChart, Number>("-fx-label-line-length", (StyleConverter)SizeConverter.getInstance(), (Number)20.0){

            @Override
            public boolean isSettable(PieChart pieChart) {
                return pieChart.labelLineLength == null || !pieChart.labelLineLength.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(PieChart pieChart) {
                return pieChart.labelLineLengthProperty();
            }
        };
        private static final StyleableProperty<PieChart, Number> START_ANGLE = new StyleableProperty<PieChart, Number>("-fx-start-angle", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(PieChart pieChart) {
                return pieChart.startAngle == null || !pieChart.startAngle.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(PieChart pieChart) {
                return pieChart.startAngleProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Chart.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, CLOCKWISE, LABELS_VISIBLE, LABEL_LINE_LENGTH, START_ANGLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    public static final class Data {
        private Text textNode = new Text();
        private Data next = null;
        private String defaultColorStyleString;
        private ReadOnlyObjectWrapper<PieChart> chart = new ReadOnlyObjectWrapper(this, "chart");
        private StringProperty name = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                if (Data.this.getChart() != null) {
                    Data.this.getChart().dataNameChanged(Data.this);
                }
            }

            @Override
            public Object getBean() {
                return Data.this;
            }

            @Override
            public String getName() {
                return "name";
            }
        };
        private DoubleProperty pieValue = new DoublePropertyBase(){

            @Override
            protected void invalidated() {
                if (Data.this.getChart() != null) {
                    Data.this.getChart().dataPieValueChanged(Data.this);
                }
            }

            @Override
            public Object getBean() {
                return Data.this;
            }

            @Override
            public String getName() {
                return "pieValue";
            }
        };
        private DoubleProperty currentPieValue = new SimpleDoubleProperty(this, "currentPieValue");
        private DoubleProperty radiusMultiplier = new SimpleDoubleProperty(this, "radiusMultiplier");
        private ObjectProperty<Node> node = new SimpleObjectProperty<Node>(this, "node");

        public final PieChart getChart() {
            return (PieChart)this.chart.getValue();
        }

        private void setChart(PieChart pieChart) {
            this.chart.setValue(pieChart);
        }

        public final ReadOnlyObjectProperty<PieChart> chartProperty() {
            return this.chart.getReadOnlyProperty();
        }

        public final void setName(String string) {
            this.name.setValue(string);
        }

        public final String getName() {
            return this.name.getValue();
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final double getPieValue() {
            return this.pieValue.getValue();
        }

        public final void setPieValue(double d) {
            this.pieValue.setValue(d);
        }

        public final DoubleProperty pieValueProperty() {
            return this.pieValue;
        }

        private double getCurrentPieValue() {
            return this.currentPieValue.getValue();
        }

        private void setCurrentPieValue(double d) {
            this.currentPieValue.setValue(d);
        }

        private DoubleProperty currentPieValueProperty() {
            return this.currentPieValue;
        }

        private double getRadiusMultiplier() {
            return this.radiusMultiplier.getValue();
        }

        private void setRadiusMultiplier(double d) {
            this.radiusMultiplier.setValue(d);
        }

        private DoubleProperty radiusMultiplierProperty() {
            return this.radiusMultiplier;
        }

        public Node getNode() {
            return (Node)this.node.getValue();
        }

        private void setNode(Node node) {
            this.node.setValue(node);
        }

        private ObjectProperty<Node> nodeProperty() {
            return this.node;
        }

        public Data(String string, double d) {
            this.setName(string);
            this.setPieValue(d);
            this.textNode.getStyleClass().addAll((String[])new String[]{"text", "chart-pie-label"});
        }

        public String toString() {
            return "Data[" + this.getName() + "," + this.getPieValue() + "]";
        }
    }

    static final class LabelLayoutInfo {
        double startX;
        double startY;
        double endX;
        double endY;
        double textX;
        double textY;
        Text text;
        double size;

        public LabelLayoutInfo(double d, double d2, double d3, double d4, double d5, double d6, Text text, double d7) {
            this.startX = d;
            this.startY = d2;
            this.endX = d3;
            this.endY = d4;
            this.textX = d5;
            this.textY = d6;
            this.text = text;
            this.size = d7;
        }
    }
}

