/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Map;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.FieldAndMethods;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.JavaMembers;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.MemberBox;
import sun.org.mozilla.javascript.internal.NativeArray;
import sun.org.mozilla.javascript.internal.NativeJavaArray;
import sun.org.mozilla.javascript.internal.NativeJavaMethod;
import sun.org.mozilla.javascript.internal.NativeJavaObject;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final String javaClassPropertyName = "__javaObject__";
    private Map<String, FieldAndMethods> staticFieldAndMethods;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scriptable, Class<?> clazz) {
        this.parent = scriptable;
        this.javaObject = clazz;
        this.initMembers();
    }

    @Override
    protected void initMembers() {
        Class clazz = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(this.parent, clazz, clazz, false);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, clazz, true);
    }

    @Override
    public String getClassName() {
        return "JavaClass";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, true) || javaClassPropertyName.equals(string);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Class<?> clazz;
        if (string.equals("prototype")) {
            return null;
        }
        if (this.staticFieldAndMethods != null && (clazz = this.staticFieldAndMethods.get(string)) != null) {
            return clazz;
        }
        if (this.members.has(string, true)) {
            return this.members.get(this, string, this.javaObject, true);
        }
        if (javaClassPropertyName.equals(string)) {
            clazz = Context.getContext();
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
            return ((Context)((Object)clazz)).getWrapFactory().wrap((Context)((Object)clazz), scriptable2, this.javaObject, ScriptRuntime.ClassClass);
        }
        clazz = NativeJavaClass.findNestedClass(this.getClassObject(), string);
        if (clazz != null) {
            NativeJavaClass nativeJavaClass = new NativeJavaClass(ScriptableObject.getTopLevelScope(this), clazz);
            nativeJavaClass.setParentScope(this);
            return nativeJavaClass;
        }
        throw this.members.reportMemberNotFound(string);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        this.members.put(this, string, this.javaObject, object, true);
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class<?> getClassObject() {
        return (Class)super.unwrap();
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof Scriptable) {
            Class<?> clazz = this.getClassObject();
            Scriptable scriptable3 = (Scriptable)objectArray[0];
            do {
                Object object;
                if (!(scriptable3 instanceof Wrapper) || !clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) continue;
                return scriptable3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return this.construct(context, scriptable, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        String string;
        Class<?> clazz;
        block5: {
            clazz = this.getClassObject();
            int n = clazz.getModifiers();
            if (!Modifier.isInterface(n) && !Modifier.isAbstract(n)) {
                MemberBox[] memberBoxArray = this.members.ctors;
                int n2 = NativeJavaMethod.findFunction(context, memberBoxArray, objectArray);
                if (n2 < 0) {
                    String string2 = NativeJavaMethod.scriptSignature(objectArray);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", clazz.getName(), string2);
                }
                return NativeJavaClass.constructSpecific(context, scriptable, objectArray, memberBoxArray[n2]);
            }
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
            string = "";
            try {
                Object object = scriptable2.get("JavaAdapter", scriptable2);
                if (object != NOT_FOUND) {
                    Function function = (Function)object;
                    Object[] objectArray2 = new Object[]{this, objectArray[0]};
                    return function.construct(context, scriptable2, objectArray2);
                }
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) break block5;
                string = string3;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", string, clazz.getName());
    }

    static Scriptable constructSpecific(Context context, Scriptable scriptable, Object[] object, MemberBox memberBox) {
        String string;
        int n;
        Class<?> clazz;
        Object object2;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        Class<?>[] classArray = memberBox.argTypes;
        if (memberBox.vararg) {
            Object object3;
            object2 = new Object[classArray.length];
            for (int i = 0; i < classArray.length - 1; ++i) {
                object2[i] = Context.jsToJava(object[i], classArray[i]);
            }
            if (((Object[])object).length == classArray.length && (object[((Object[])object).length - 1] == null || object[((Object[])object).length - 1] instanceof NativeArray || object[((Object[])object).length - 1] instanceof NativeJavaArray)) {
                object3 = Context.jsToJava(object[((Object[])object).length - 1], classArray[classArray.length - 1]);
            } else {
                clazz = classArray[classArray.length - 1].getComponentType();
                object3 = Array.newInstance(clazz, ((Object[])object).length - classArray.length + 1);
                for (int i = 0; i < Array.getLength(object3); ++i) {
                    Object object4 = Context.jsToJava(object[classArray.length - 1 + i], clazz);
                    Array.set(object3, i, object4);
                }
            }
            object2[classArray.length - 1] = object3;
            object = object2;
        } else {
            object2 = object;
            for (int i = 0; i < ((Object[])object).length; ++i) {
                clazz = object[i];
                Object object5 = Context.jsToJava(clazz, classArray[i]);
                if (object5 == clazz) continue;
                if (object == object2) {
                    object = (Object[])object2.clone();
                }
                object[i] = object5;
            }
        }
        object2 = System.getSecurityManager();
        if (object2 != null && (n = (string = memberBox.getName()).lastIndexOf(46)) != -1) {
            ((SecurityManager)object2).checkPackageAccess(string.substring(0, n));
        }
        Object object6 = memberBox.newInstance((Object[])object);
        return context.getWrapFactory().wrapNewObject(context, scriptable2, object6);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof Wrapper && !(scriptable instanceof NativeJavaClass)) {
            Object object = ((Wrapper)((Object)scriptable)).unwrap();
            return this.getClassObject().isInstance(object);
        }
        return false;
    }

    private static Class<?> findNestedClass(Class<?> clazz, String string) {
        String string2 = clazz.getName() + '$' + string;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return Kit.classOrNull(string2);
        }
        return Kit.classOrNull(classLoader, string2);
    }
}

