/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.upload;

import com.neuedu.educloud.tools.core.LoggerDialog;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.upload.Communicator;
import com.neuedu.educloud.tools.upload.DataPackager;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Map;
import javax.swing.JList;

public class Uploader
implements Runnable {
    private JList list;
    private Resource res;
    private boolean pause = false;
    private DataPackager pkg = null;
    private Communicator comm = null;

    public Uploader(JList list, Map<String, String> configs, Resource res) {
        this.pkg = new DataPackager(res);
        this.comm = new Communicator(configs);
        this.list = list;
        this.res = res;
    }

    @Override
    public void run() {
        try {
            try {
                this.res.setStatus(Resource.PACKAGING);
                this.list.repaint();
                this.pkg.pack();
                this.res.setStatus(Resource.UPLOADING);
                this.list.repaint();
                int length = this.pkg.length();
                int oldLength = this.res.getLength();
                int off = this.res.getSended();
                if (off == oldLength || length != oldLength) {
                    off = 0;
                }
                this.res.setLength(length);
                byte[] buf = new byte[64000];
                int r = 0;
                this.pkg.open();
                this.comm.open();
                if (this.res.getResId() == null || "".equals(this.res.getResId())) {
                    this.comm.newResource(this.res);
                }
                String rules = this.findRules();
                while ((r = this.pkg.read(buf, off)) > 0) {
                    if (this.pause || !this.comm.sendResource(buf, off, r, this.res, rules)) break;
                    this.res.setSended(off += r);
                    this.list.repaint();
                }
                if (this.res.getSended() == this.res.getLength()) {
                    this.res.setStatus(Resource.UPLOADED);
                    this.list.repaint();
                }
            }
            catch (Exception e) {
                this.res.setStatus(Resource.ERROR);
                this.res.setMsg(e.getMessage());
                this.list.repaint();
                LoggerDialog.logger(e, null);
                if (this.pkg != null) {
                    this.pkg.close();
                }
                if (this.comm != null) {
                    this.comm.close();
                }
            }
        }
        finally {
            if (this.pkg != null) {
                this.pkg.close();
            }
            if (this.comm != null) {
                this.comm.close();
            }
        }
    }

    public void pause() {
        this.pause = true;
    }

    private String findRules() throws Exception {
        RandomAccessFile paper = null;
        File file = new File("works/" + this.res.getId() + "/paper.json");
        try {
            if (file.exists()) {
                paper = new RandomAccessFile(file, "r");
                long length = paper.length();
                paper.seek(length - 200L);
                byte[] buf = new byte[200];
                paper.read(buf);
                String info = new String(buf, "utf-8");
                int begin = info.indexOf("\"rules\":");
                String string = info = info.substring(begin + 8);
                return string;
            }
        }
        finally {
            if (paper != null) {
                try {
                    paper.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }
}

