/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.upload;

import com.neuedu.educloud.api.http.HttpRequest;
import com.neuedu.educloud.api.http.HttpRequestFactory;
import com.neuedu.educloud.api.http.HttpResponse;
import com.neuedu.educloud.api.http.UrlConnectionTransport;
import com.neuedu.educloud.api.oauth.AccessTokenRequest;
import com.neuedu.educloud.api.oauth.AccessTokenResponse;
import com.neuedu.educloud.api.oauth.OAuth2Params;
import com.neuedu.educloud.api.oauth.OAuth2URL;
import com.neuedu.educloud.tools.core.Resource;
import java.net.URLEncoder;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;

public class Communicator {
    private HttpRequestFactory secfactory = null;
    private String dasUrl = null;
    private String rssUrl = null;
    private String keyFile = null;
    private String keyPass = null;
    private String user = null;
    private String passwd = null;

    public Communicator(Map<String, String> configs) {
        this.dasUrl = configs.get("dasPointEnd");
        this.rssUrl = configs.get("rssPointEnd");
        this.keyFile = configs.get("dasKeystoreFile");
        this.keyPass = configs.get("dasKeystorePass");
        this.user = configs.get("user");
        this.passwd = configs.get("passwd");
    }

    public void open() throws Exception {
        UrlConnectionTransport trans = new UrlConnectionTransport();
        trans.setKeystore(this.keyFile, this.keyPass);
        HttpRequestFactory factory = trans.createRequestFactory();
        String dasEndPoint = String.valueOf(this.dasUrl) + "ecdas";
        String client_id = "neuedu-cloud-resource-tools";
        String callback_url = dasEndPoint;
        String accessTokenUrl = OAuth2URL.getAccessTokenRequestUrl((String)dasEndPoint, (String)client_id, (String)callback_url);
        String params = OAuth2Params.getParamsByPass((String)this.user, (String)this.passwd);
        AccessTokenResponse tokenResponse = AccessTokenRequest.getAccessToken((HttpRequestFactory)factory, (String)accessTokenUrl, (String)params);
        String accessToken = null;
        if (tokenResponse.hasError) {
            throw new Exception(tokenResponse.error);
        }
        accessToken = tokenResponse.accessToken;
        this.secfactory = trans.createRequestFactory(accessToken);
    }

    public void close() {
        this.secfactory = null;
        this.dasUrl = null;
        this.rssUrl = null;
        this.keyFile = null;
        this.keyPass = null;
        this.user = null;
        this.passwd = null;
    }

    public void newResource(Resource res) throws Exception {
        String rssEndPoint = String.valueOf(this.rssUrl) + "ecrss/resource";
        String filename = URLEncoder.encode(res.getName(), "utf-8");
        HttpRequest httpreq = this.secfactory.buildGetRequest(rssEndPoint, "application/x-www-form-urlencoded", new String[]{"File-Name", filename, "File-Size", String.valueOf(res.getLength())});
        HttpResponse httpres = httpreq.execute();
        if (httpres.getResponseCode() == 200) {
            String content = httpres.getContent("utf-8");
            JSONObject obj = new JSONObject(content);
            Object success = obj.get("success");
            if (success.equals(Boolean.TRUE)) {
                JSONObject jsono = (JSONObject)obj.get("result");
                String id = (String)jsono.get("id");
                String md5 = (String)jsono.get("md5");
                Integer position = (Integer)jsono.get("position");
                res.setMd5(md5);
                res.setResId(id);
                res.setSended(position);
            }
        } else {
            throw new Exception(httpres.getContent("utf-8"));
        }
    }

    public boolean sendResource(byte[] buf, int seek, int len, Resource res, String rules) throws Exception {
        String rssEndPoint = String.valueOf(this.rssUrl) + "ecrss/resource/" + res.getResId();
        String contentRange = String.valueOf(seek) + "-" + (seek + len) + "/" + res.getLength();
        String fileName = URLEncoder.encode(res.getName(), "utf-8");
        String md5 = URLEncoder.encode(res.getMd5(), "utf-8");
        String desc = res.getDescription() != null ? URLEncoder.encode(res.getDescription(), "utf-8") : "";
        String type2 = "";
        if (res.getType() == Resource.COURSE_TYPE) {
            type2 = "COURSE";
        } else if (res.getType() == Resource.EXAM_TYPE) {
            type2 = "EXAM";
        } else if (res.getType() == Resource.EVALUATION_TYPE) {
            type2 = "EVALUATION";
        } else if (res.getType() == Resource.SURVEY_TYPE) {
            type2 = "SURVEY";
        }
        HttpRequest httpreq = this.secfactory.buildPostRequest(rssEndPoint, buf, 0, len, "application/octet-stream", new String[]{"Content-Range", contentRange, "Type-Code", type2, "File-Name", fileName, "File-Md5", md5, "Description", desc, "Course-Length", String.valueOf(res.getAlltime()), "Question-Num", String.valueOf(res.getQueNum()), "Rules", rules, "Publish-Range", res.getOrgId()});
        HttpResponse httpres = httpreq.execute();
        int code = httpres.getResponseCode();
        return code == 200;
    }
}

