/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper.model;

import com.neuedu.educloud.tools.paper.model.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class Question {
    private String id = UUID.randomUUID().toString();
    private String type;
    private String body;
    private List<String> images;
    private String answer;
    private String hard = "\u4e00\u822c";
    private float score = 1.0f;
    private String analyse;
    private String tags;
    private List<Item> items;

    public Question() {
    }

    public Question(JSONObject jsonq) throws Exception {
        Object os;
        this.id = jsonq.getString("id");
        this.type = jsonq.getString("type");
        this.body = jsonq.getString("body");
        if (this.body.equals(JSONObject.NULL)) {
            this.body = null;
        }
        this.answer = jsonq.getString("answer");
        if (this.answer.equals(JSONObject.NULL)) {
            this.answer = null;
        }
        this.hard = jsonq.getString("hard");
        if (this.hard.equals(JSONObject.NULL)) {
            this.hard = null;
        }
        if (!(os = jsonq.get("score")).equals(JSONObject.NULL)) {
            this.score = Float.valueOf(os.toString()).floatValue();
        }
        this.analyse = jsonq.getString("analyse");
        if (this.analyse.equals(JSONObject.NULL)) {
            this.analyse = null;
        }
        this.tags = jsonq.getString("tags");
        if (this.tags.equals(JSONObject.NULL)) {
            this.tags = null;
        }
        this.images = new ArrayList<String>();
        JSONArray jsonimgs = jsonq.getJSONArray("images");
        int i = 0;
        while (i < jsonimgs.length()) {
            String img = jsonimgs.getString(i);
            this.images.add(img);
            ++i;
        }
        this.items = new ArrayList<Item>();
        JSONArray jsonitems = jsonq.getJSONArray("items");
        int i2 = 0;
        while (i2 < jsonitems.length()) {
            JSONObject jsonitem = jsonitems.getJSONObject(i2);
            Item item = new Item(jsonitem);
            this.items.add(item);
            ++i2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<String> getImages() {
        return this.images;
    }

    public String getImage(int index) {
        String img = null;
        if (this.images != null && this.images.size() > index) {
            img = this.images.get(index);
        }
        return img;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public void addImages(int index, String img) {
        if (this.images == null) {
            this.images = new ArrayList<String>();
        }
        if (this.images.size() > index) {
            this.images.remove(index);
            this.images.add(index, img);
        } else {
            this.images.add(img);
        }
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getHard() {
        return this.hard;
    }

    public void setHard(String hard) {
        this.hard = hard;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getAnalyse() {
        return this.analyse;
    }

    public void setAnalyse(String analyse) {
        this.analyse = analyse;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Item getItem(int index) {
        Item item = null;
        if (this.items != null && this.items.size() > index) {
            item = this.items.get(index);
        }
        return item;
    }

    public String getItemDescription(int index) {
        Item item = null;
        if (this.items != null && this.items.size() > index) {
            item = this.items.get(index);
        }
        if (item != null) {
            return item.getDescription();
        }
        return null;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void addItem(int index, Item item) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        item.setValue(index + 1);
        if (this.items.size() > index) {
            this.items.remove(index);
            this.items.add(index, item);
        } else {
            this.items.add(item);
        }
    }

    public String toString() {
        int i;
        StringBuffer json = new StringBuffer();
        json.append('{');
        json.append('\"').append("id").append('\"').append(':').append('\"').append(this.getId()).append('\"').append(',');
        json.append('\"').append("type").append('\"').append(':').append('\"').append(this.getType()).append('\"').append(',');
        json.append('\"').append("body").append('\"').append(':').append('\"').append(this.getBody()).append('\"').append(',');
        json.append('\"').append("images").append('\"').append(':').append('[');
        if (this.images != null && this.images.size() > 0) {
            json.append('\"').append(this.images.get(0)).append('\"');
            i = 1;
            while (i < this.images.size()) {
                json.append(',').append('\"').append(this.images.get(i)).append('\"');
                ++i;
            }
        }
        json.append(']').append(',');
        this.appendAttribute(json, "answer", this.getAnswer(), false);
        this.appendAttribute(json, "hard", this.getHard(), false);
        this.appendAttribute(json, "score", Float.valueOf(this.getScore()), false);
        this.appendAttribute(json, "analyse", this.getAnalyse(), false);
        this.appendAttribute(json, "tags", this.getTags(), false);
        json.append('\"').append("items").append('\"').append(':').append('[');
        if (this.items != null && this.items.size() > 0) {
            json.append(this.items.get(0).toString());
            i = 1;
            while (i < this.items.size()) {
                json.append(',').append(this.items.get(i).toString());
                ++i;
            }
        }
        json.append(']');
        return json.append('}').toString();
    }

    private void appendAttribute(StringBuffer json, String key, Object value, boolean isEnd) {
        json.append('\'').append(key).append('\'').append(':');
        if (value == null) {
            json.append(JSONObject.NULL);
        } else if (value instanceof String) {
            json.append('\"').append(value).append('\"');
        } else {
            json.append(value);
        }
        if (!isEnd) {
            json.append(',');
        }
    }

    public static enum qtype {
        Selection,
        Choice,
        Matching,
        TrueFalse,
        Other;

    }
}

