/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper.model;

import com.neuedu.educloud.tools.paper.model.ModelChangedEvent;
import com.neuedu.educloud.tools.paper.model.ModelChangedListener;
import com.neuedu.educloud.tools.paper.model.Question;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class Paper {
    private String id = UUID.randomUUID().toString();
    private String name;
    private String type;
    private String catalog;
    private String description;
    private String target;
    private Float max;
    private Float pass;
    private String enter;
    private String repeat = "Always";
    private String startTime;
    private String overTime;
    private String reply = "All";
    private String review = "Always";
    private List<Question> questions = new ArrayList<Question>();
    private ModelChangedListener listener = null;

    public Paper() {
    }

    public Paper(JSONObject jsonobj) throws Exception {
        this.id = jsonobj.getString("id");
        this.name = jsonobj.getString("name");
        this.type = jsonobj.getString("type");
        this.description = jsonobj.getString("desc");
        Object mo = jsonobj.get("max");
        if (!mo.equals(JSONObject.NULL)) {
            this.max = Float.valueOf(mo.toString());
        }
        JSONArray jsonques = jsonobj.getJSONArray("questions");
        this.questions = new ArrayList<Question>();
        int i = 0;
        while (i < jsonques.length()) {
            JSONObject jsonq = jsonques.getJSONObject(i);
            Question ques = new Question(jsonq);
            this.questions.add(ques);
            ++i;
        }
        JSONObject rules = jsonobj.getJSONObject("rules");
        if (rules != null) {
            Object po = rules.get("pass");
            if (!po.equals(JSONObject.NULL)) {
                this.pass = Float.valueOf(po.toString());
            }
            this.enter = rules.getString("enter");
            this.repeat = rules.getString("repeat");
            this.startTime = rules.getString("startTime");
            this.overTime = rules.getString("overTime");
            this.reply = rules.getString("reply");
            this.review = rules.getString("review");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Float getMax() {
        return this.max;
    }

    public void setMax(Float max) {
        this.max = max;
    }

    public Float getPass() {
        return this.pass;
    }

    public void setPass(Float pass) {
        this.pass = pass;
    }

    public String getEnter() {
        return this.enter;
    }

    public void setEnter(String enter) {
        this.enter = enter;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getOverTime() {
        return this.overTime;
    }

    public void setOverTime(String overTime) {
        this.overTime = overTime;
    }

    public String getReply() {
        return this.reply;
    }

    public void setReply(String reply) {
        this.reply = reply;
    }

    public String getReview() {
        return this.review;
    }

    public void setReview(String review) {
        this.review = review;
    }

    public void addChangedListener(ModelChangedListener listener) {
        this.listener = listener;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public int getQueNum() {
        return this.questions.size();
    }

    public void add(int index, Question que) {
        this.questions.add(que);
        if (this.listener != null) {
            ModelChangedEvent e = new ModelChangedEvent(3);
            e.setNewValue(que);
            e.setIndex(index);
            this.listener.onAdd(e);
        }
    }

    public Question remove(int index) {
        Question q = this.questions.remove(index - 1);
        if (this.listener != null) {
            ModelChangedEvent e = new ModelChangedEvent(7);
            e.setOldValue(q);
            e.setIndex(index);
            this.listener.onRemove(e);
        }
        return q;
    }

    public void update(int index, Question que) {
        Question oldQ = this.questions.remove(index);
        this.questions.add(index, que);
        if (this.listener != null) {
            ModelChangedEvent e = new ModelChangedEvent(5);
            e.setOldValue(oldQ);
            e.setNewValue(que);
            e.setIndex(index);
            this.listener.onUpdate(e);
        }
    }

    public void dispatchChangedEvent() {
        ModelChangedEvent e = new ModelChangedEvent(0);
        e.setNewValue(this);
        this.listener.onUpdate(e);
    }

    public String toString() {
        StringBuffer json = new StringBuffer();
        json.append('{');
        json.append('\"').append("id").append('\"').append(':').append('\"').append(this.getId()).append('\"').append(',');
        json.append('\"').append("name").append('\"').append(':').append('\"').append(this.getName()).append('\"').append(',');
        json.append('\"').append("type").append('\"').append(':').append('\"').append(this.getType()).append('\"').append(',');
        json.append('\"').append("author").append('\"').append(':').append('\"').append('\"').append(',');
        json.append('\"').append("catalog").append('\"').append(':').append('\"').append('\"').append(',');
        this.appendAttribute(json, "desc", this.getDescription(), false);
        json.append('\"').append("target").append('\"').append(':').append('\"').append('\"').append(',');
        this.appendAttribute(json, "max", this.getMax(), false);
        json.append('\"').append("questions").append('\"').append(':').append('[');
        if (this.questions.size() > 0) {
            json.append(this.questions.get(0).toString());
            int i = 1;
            while (i < this.questions.size()) {
                json.append(',');
                json.append(this.questions.get(i).toString());
                ++i;
            }
        }
        json.append(']').append(',');
        json.append('\"').append("rules").append('\"').append(':').append('{');
        this.appendAttribute(json, "pass", this.getPass(), false);
        this.appendAttribute(json, "enter", this.getEnter(), false);
        this.appendAttribute(json, "repeat", this.getRepeat(), false);
        this.appendAttribute(json, "startTime", this.getStartTime(), false);
        this.appendAttribute(json, "overTime", this.getOverTime(), false);
        this.appendAttribute(json, "reply", this.getReply(), false);
        this.appendAttribute(json, "review", this.getReview(), true);
        json.append('}');
        return json.append("}").toString();
    }

    private void appendAttribute(StringBuffer json, String key, Object value, boolean isEnd) {
        json.append('\'').append(key).append('\'').append(':');
        if (value == null) {
            json.append("null");
        } else if (value instanceof String) {
            json.append('\"').append(value).append('\"');
        } else {
            json.append(value);
        }
        if (!isEnd) {
            json.append(',');
        }
    }
}

