/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper;

import com.neuedu.educloud.tools.core.LoggerDialog;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class UIHelper {
    private static int left_x = 10;
    private static int top_y = 10;
    private static int row_height = 22;
    private static int row_space = 5;
    private static int col_space = 5;
    private static int label_width = 80;

    public static final JTextField newTextField(final String tip, final String property_name, final PropertyChangeListener listener, String defaultValue) {
        JTextField textField = new JTextField();
        if (defaultValue != null) {
            textField.setText(defaultValue);
            textField.setForeground(Color.black);
            textField.setBorder(BorderFactory.createEmptyBorder());
        } else {
            textField.setText(tip);
            textField.setForeground(Color.lightGray);
            textField.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    Document doc = e.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    if (!text.equals(tip)) {
                        PropertyChangeEvent evt = new PropertyChangeEvent(doc, property_name, null, text);
                        listener.propertyChange(evt);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    Document doc = e.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    if (!text.equals(tip)) {
                        PropertyChangeEvent evt = new PropertyChangeEvent(doc, property_name, null, text);
                        listener.propertyChange(evt);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField jf = (JTextField)e.getComponent();
                jf.setBorder(BorderFactory.createLineBorder(Color.black));
                if (jf.getText() != null && tip.equals(jf.getText())) {
                    jf.setText("");
                    jf.setForeground(Color.black);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextField jf = (JTextField)e.getComponent();
                if (jf.getText() != null && "".equals(jf.getText())) {
                    jf.setText(tip);
                    jf.setForeground(Color.lightGray);
                    jf.setBorder(BorderFactory.createLineBorder(Color.lightGray));
                } else {
                    jf.setBorder(BorderFactory.createEmptyBorder());
                    jf.setForeground(Color.black);
                }
            }
        });
        return textField;
    }

    public static final JLabel newImageLabel(String tip, final JPanel parent, final String property_name, final PropertyChangeListener listener, final String imageName, final String paperId, int labelWidth, int labelHeight) {
        File imgFile;
        JLabel imageLabel = new JLabel(tip);
        imageLabel.setSize(labelWidth, labelHeight);
        imageLabel.setForeground(Color.lightGray);
        imageLabel.setHorizontalAlignment(0);
        imageLabel.setBorder(BorderFactory.createEtchedBorder());
        if (paperId != null && (imgFile = new File("works/" + paperId + "/" + imageName)).exists()) {
            try {
                BufferedImage biImg = ImageIO.read(imgFile);
                Image image = biImg.getScaledInstance(labelWidth, labelHeight, 1);
                ImageIcon icon = new ImageIcon(image);
                imageLabel.setIcon(icon);
                imageLabel.setText("");
                imageLabel.validate();
                imageLabel.setBorder(BorderFactory.createEmptyBorder());
            }
            catch (Exception e) {
                LoggerDialog.logger(e, "Open Image Error.");
            }
        }
        imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JLabel jf = (JLabel)e.getSource();
                if (e.getClickCount() == 2) {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser();
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("JPG Images", "jpg");
                    chooser.setFileFilter(filter);
                    String name = imageName;
                    if (name == null) {
                        name = String.valueOf(UUID.randomUUID().toString()) + ".jpg";
                    }
                    if ((returnVal = chooser.showOpenDialog(parent)) == 0) {
                        try {
                            File file = chooser.getSelectedFile();
                            File dir = new File("works/" + paperId);
                            BufferedImage bi = ImageIO.read(file);
                            if (!dir.exists()) {
                                ImageIO.write((RenderedImage)bi, "jpg", new File("works/temp/" + name));
                            } else {
                                ImageIO.write((RenderedImage)bi, "jpg", new File("works/" + paperId + "/" + name));
                            }
                            Image image = bi.getScaledInstance(jf.getWidth(), jf.getHeight(), 1);
                            ImageIcon icon = new ImageIcon(image);
                            jf.setIcon(icon);
                            jf.setText("");
                            jf.validate();
                        }
                        catch (Exception e1) {
                            LoggerDialog.logger(e1, "Open Selected Image Error.");
                        }
                        PropertyChangeEvent evt = new PropertyChangeEvent(jf, property_name, null, name);
                        listener.propertyChange(evt);
                    }
                }
            }
        });
        return imageLabel;
    }

    public static final JScrollPane newTextArea(final String tip, final String property_name, final PropertyChangeListener listener, String defaultValue) {
        JScrollPane scroll = new JScrollPane();
        scroll.setBorder(BorderFactory.createEmptyBorder());
        scroll.setAutoscrolls(true);
        JTextArea textArea = new JTextArea();
        if (defaultValue != null) {
            textArea.setText(defaultValue);
            textArea.setForeground(Color.black);
            textArea.setBorder(BorderFactory.createEmptyBorder());
        } else {
            textArea.setText(tip);
            textArea.setForeground(Color.lightGray);
            textArea.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        textArea.setLineWrap(true);
        textArea.setAutoscrolls(true);
        textArea.setBackground(Color.white);
        textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    Document doc = e.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    if (!text.equals(tip)) {
                        PropertyChangeEvent evt = new PropertyChangeEvent(doc, property_name, null, text);
                        listener.propertyChange(evt);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    Document doc = e.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    if (!text.equals(tip)) {
                        PropertyChangeEvent evt = new PropertyChangeEvent(doc, property_name, null, text);
                        listener.propertyChange(evt);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextArea jf = (JTextArea)e.getComponent();
                jf.setBorder(BorderFactory.createLineBorder(Color.black));
                if (jf.getText() != null && tip.equals(jf.getText())) {
                    jf.setText("");
                    jf.setForeground(Color.black);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea jf = (JTextArea)e.getComponent();
                if (jf.getText() != null && "".equals(jf.getText())) {
                    jf.setText(tip);
                    jf.setForeground(Color.lightGray);
                    jf.setBorder(BorderFactory.createLineBorder(Color.lightGray));
                } else {
                    jf.setBorder(BorderFactory.createEmptyBorder());
                    jf.setForeground(Color.black);
                }
            }
        });
        scroll.setViewportView(textArea);
        return scroll;
    }

    public static JPanel newSelect(final String property_name, final PropertyChangeListener listener, final String message, final String title, final Object[] selectionValues, final String defaultValue) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBackground(Color.white);
        final JLabel label = new JLabel(defaultValue);
        label.setBounds(0, 0, 140, 22);
        JButton btn = new JButton("...");
        btn.setBounds(145, 0, 20, 22);
        panel.add(label);
        panel.add(btn);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object selVal = JOptionPane.showInputDialog(label, message, title, 1, null, selectionValues, defaultValue);
                label.setText((String)selVal);
                PropertyChangeEvent evt = new PropertyChangeEvent(label, property_name, null, selVal);
                listener.propertyChange(evt);
            }
        });
        return panel;
    }

    public static void fillComponent(JPanel container, JComponent comp, int comp_width, String comp_label, int row_in_container) {
        int yy = top_y + (row_height + row_space) * (row_in_container - 1);
        if (comp_label != null) {
            JLabel jlabel = new JLabel(comp_label);
            jlabel.setBounds(left_x, yy, label_width, row_height);
            container.add(jlabel);
        }
        comp.setBounds(left_x + label_width + col_space, yy, comp_width, row_height);
        container.add(comp);
    }
}

