/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper;

import com.neuedu.educloud.tools.paper.ItemPage;
import com.neuedu.educloud.tools.paper.UIHelper;
import com.neuedu.educloud.tools.paper.model.Paper;
import com.neuedu.educloud.tools.paper.model.PaperRules;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TitlePage
implements ItemPage,
PropertyChangeListener {
    private Paper paper;
    private JLabel label = new JLabel("\u5c01\u9762");
    private JPanel panel = new JPanel();
    private JPanel attrs = new JPanel();
    private boolean initialized = false;

    public TitlePage(Paper paper) {
        this.paper = paper;
        this.label.setName(paper.getId());
        this.panel.setName(paper.getId());
    }

    @Override
    public String getId() {
        return this.paper.getId();
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public JPanel getPanel() {
        if (!this.initialized) {
            this.panel.setLayout(null);
            this.initialized = true;
            JLabel picLabel = UIHelper.newImageLabel("\u53cc\u51fb\u9009\u62e9\u5c01\u9762\u56fe\u7247", this.panel, "picture", this, "1.jpg", this.paper.getId(), 320, 240);
            picLabel.setLocation(140, 60);
            this.panel.add(picLabel);
            JTextField nameField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u5377\u540d\u79f0", "paper_name", this, this.paper.getName());
            if (this.panel.getName() != null) {
                nameField.setText(this.paper.getName());
            }
            nameField.setHorizontalAlignment(0);
            nameField.setBounds(new Rectangle(155, 305, 290, 40));
            this.panel.add(nameField);
        }
        return this.panel;
    }

    @Override
    public JPanel getAttrs() {
        if (this.attrs.getComponentCount() == 0) {
            this.attrs.setLayout(null);
            this.attrs.setBackground(Color.white);
            JLabel typeLabel = new JLabel(this.paper.getType());
            UIHelper.fillComponent(this.attrs, typeLabel, 80, "\u8bd5\u5377\u7c7b\u578b:", 1);
            JTextField descField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u5377\u63cf\u8ff0", "paper_desc", this, this.paper.getDescription());
            UIHelper.fillComponent(this.attrs, descField, 500, "\u8bd5\u5377\u63cf\u8ff0:", 2);
            if ("EXAM".equals(this.paper.getType())) {
                JTextField maxField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u5377\u603b\u5206", "paper_max", this, this.paper.getMax() != null ? "" + this.paper.getMax() : null);
                UIHelper.fillComponent(this.attrs, maxField, 200, "\u8bd5\u5377\u603b\u5206:", 3);
                JTextField passField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u5377\u53ca\u683c\u5206", "paper_pass", this, this.paper.getPass() != null ? "" + this.paper.getPass() : null);
                UIHelper.fillComponent(this.attrs, passField, 200, "\u8bd5\u5377\u53ca\u683c\u5206:", 4);
                JTextField bTimeField = UIHelper.newTextField("\u8f93\u5165\u5f00\u59cb\u65f6\u95f4, yyyy-mm-dd hh:mi:ss", "paper_btime", this, this.paper.getStartTime());
                UIHelper.fillComponent(this.attrs, bTimeField, 200, "\u5f00\u59cb\u65f6\u95f4:", 5);
                JTextField oTimeField = UIHelper.newTextField("\u8f93\u5165\u622a\u6b62\u65f6\u95f4, yyyy-mm-dd hh:mi:ss", "paper_otime", this, this.paper.getOverTime());
                UIHelper.fillComponent(this.attrs, oTimeField, 200, "\u622a\u6b62\u65f6\u95f4:", 6);
                Object[] repeats = PaperRules.repeatRules.values().toArray();
                String key1 = this.paper.getRepeat() != null ? this.paper.getRepeat() : "Always";
                JPanel reRulePanel = UIHelper.newSelect("paper_repeat", this, "\u9009\u62e9\u91cd\u590d\u8bbf\u95ee\u89c4\u5219", "\u91cd\u590d\u8bbf\u95ee\u89c4\u5219", repeats, PaperRules.repeatRules.get(key1));
                UIHelper.fillComponent(this.attrs, reRulePanel, 300, "\u91cd\u590d\u8bbf\u95ee\u89c4\u5219:", 7);
                Object[] replys = PaperRules.replyRules.values().toArray();
                String key2 = this.paper.getReply() != null ? this.paper.getReply() : "All";
                JPanel bkRulePanel = UIHelper.newSelect("paper_reply", this, "\u9009\u62e9\u7b54\u5377\u56de\u4f20\u89c4\u5219", "\u7b54\u5377\u56de\u4f20\u89c4\u5219", replys, PaperRules.replyRules.get(key2));
                UIHelper.fillComponent(this.attrs, bkRulePanel, 300, "\u7b54\u5377\u56de\u4f20\u89c4\u5219:", 8);
                Object[] reviews = PaperRules.reviewRules.values().toArray();
                String key3 = this.paper.getReview() != null ? this.paper.getReview() : "Always";
                JPanel vaRulePanel = UIHelper.newSelect("paper_review", this, "\u9009\u62e9\u67e5\u770b\u89e3\u6790\u89c4\u5219", "\u67e5\u770b\u89e3\u6790\u89c4\u5219", reviews, PaperRules.reviewRules.get(key3));
                UIHelper.fillComponent(this.attrs, vaRulePanel, 300, "\u67e5\u770b\u89e3\u6790\u89c4\u5219:", 9);
            }
        }
        return this.attrs;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object val = evt.getNewValue();
        val = ((String)val).replaceAll("\"", "'");
        if ("paper_name".equals(propertyName)) {
            this.paper.setName((String)val);
        } else if ("paper_desc".equals(propertyName)) {
            this.paper.setDescription((String)val);
        } else if ("paper_max".equals(propertyName)) {
            this.paper.setMax(Float.valueOf((String)val));
        } else if ("paper_pass".equals(propertyName)) {
            float pss = Float.valueOf((String)val).floatValue();
            if (pss < this.paper.getMax().floatValue()) {
                this.paper.setPass(Float.valueOf(pss));
            } else {
                JOptionPane.showMessageDialog(this.attrs, "\u53ca\u683c\u5206\u6570\u5e94\u8be5\u5c0f\u4e8e\u8bd5\u5377\u603b\u5206\u6570.");
            }
        } else if ("paper_btime".equals(propertyName)) {
            this.paper.setStartTime((String)val);
        } else if ("paper_otime".equals(propertyName)) {
            this.paper.setOverTime((String)val);
        } else if ("paper_repeat".equals(propertyName)) {
            String code = PaperRules.value2code((String)val, PaperRules.repeatRules);
            this.paper.setRepeat(code);
        } else if ("paper_reply".equals(propertyName)) {
            String code = PaperRules.value2code((String)val, PaperRules.replyRules);
            this.paper.setReply(code);
        } else if ("paper_review".equals(propertyName)) {
            String code = PaperRules.value2code((String)val, PaperRules.reviewRules);
            this.paper.setReview(code);
        }
    }
}

