/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper;

import com.neuedu.educloud.tools.paper.DrawPanel;
import com.neuedu.educloud.tools.paper.ItemPage;
import com.neuedu.educloud.tools.paper.UIHelper;
import com.neuedu.educloud.tools.paper.model.Item;
import com.neuedu.educloud.tools.paper.model.Paper;
import com.neuedu.educloud.tools.paper.model.Question;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class QuesPage
implements ItemPage,
PropertyChangeListener {
    private Question que = null;
    private JLabel label = new JLabel();
    private JPanel panel = new JPanel();
    private JPanel attrs = new JPanel();
    private boolean initialized = false;
    private String paperType = null;
    private String paperId = null;
    private String[] left_mks = new String[]{"A", "B", "C", "D"};
    private String[] right_mks = new String[]{"1", "2", "3", "4"};

    public QuesPage(Question q, Paper model) {
        this.que = q;
        this.label.setName(q.getId());
        this.panel.setName(q.getId());
        this.paperType = model.getType();
        this.paperId = model.getId();
    }

    @Override
    public String getId() {
        return this.que.getId();
    }

    @Override
    public JLabel getLabel() {
        this.label.setText("\u8bd5\u9898" + this.que.getId());
        return this.label;
    }

    @Override
    public JPanel getPanel() {
        if (!this.initialized) {
            this.panel.setLayout(null);
            this.initialized = true;
            JLabel queId = new JLabel("ID:" + this.que.getId());
            queId.setBounds(new Rectangle(10, 5, 300, 20));
            queId.setForeground(Color.lightGray);
            this.panel.add(queId);
            if (this.que.getType() == null) {
                String[] btnsText = null;
                btnsText = "EXAM".equals(this.paperType) ? new String[]{"\u5355\u9009", "\u591a\u9009", "\u5339\u914d", "\u5224\u65ad"} : new String[]{"\u5355\u9009", "\u591a\u9009", "\u5339\u914d", "\u5224\u65ad", "\u7b80\u8ff0"};
                int i = 0;
                while (i < btnsText.length) {
                    JButton btn = new JButton(btnsText[i]);
                    if (btnsText.length == 4) {
                        btn.setBounds(125 + 90 * i, 180, 80, 40);
                    } else {
                        btn.setBounds(80 + 90 * i, 180, 80, 40);
                    }
                    btn.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            JButton btn = (JButton)e.getSource();
                            int i = 1;
                            while (i < btn.getParent().getComponentCount()) {
                                Component comp = btn.getParent().getComponent(i);
                                comp.setVisible(false);
                                ++i;
                            }
                            QuesPage.this.viewQues(btn.getText());
                        }
                    });
                    this.panel.add(btn);
                    ++i;
                }
            } else {
                this.viewQues(null);
            }
        }
        return this.panel;
    }

    private void viewQues(String text) {
        JScrollPane quesBody = UIHelper.newTextArea("\u8bf7\u8f93\u5165\u8bd5\u9898\u9898\u5e72", "que_body", this, this.que.getBody());
        quesBody.setBounds(new Rectangle(10, 30, 580, 110));
        this.panel.add(quesBody);
        JLabel image_a = UIHelper.newImageLabel("\u53cc\u51fb\u6dfb\u52a0\u56fe\u7247", this.panel, "image1", this, this.que.getImage(0), this.paperId, 120, 90);
        image_a.setLocation(10, 145);
        this.panel.add(image_a);
        JLabel image_b = UIHelper.newImageLabel("\u53cc\u51fb\u6dfb\u52a0\u56fe\u7247", this.panel, "image2", this, this.que.getImage(1), this.paperId, 120, 90);
        image_b.setLocation(140, 145);
        this.panel.add(image_b);
        if ("\u5355\u9009".equals(text) || "Selection".equals(this.que.getType())) {
            this.que.setType(Question.qtype.Selection.name());
            JLabel qtype2 = new JLabel("\u5355\u9009\u9898");
            qtype2.setBounds(540, 5, 40, 20);
            this.panel.add(qtype2);
            ButtonGroup bgrp = new ButtonGroup();
            int i = 0;
            while (i < 4) {
                JRadioButton radio_a = new JRadioButton();
                radio_a.setText(this.left_mks[i]);
                int y = 240 + 24 * i;
                radio_a.setBounds(10, y, 40, 22);
                bgrp.add(radio_a);
                this.panel.add(radio_a);
                JTextField textField_a = UIHelper.newTextField("\u8f93\u5165\u9009\u9879", "item_" + i, this, this.que.getItemDescription(i));
                textField_a.setBounds(50, y, 300, 22);
                this.panel.add(textField_a);
                if (this.paperType.equals("EXAM")) {
                    String aa = this.que.getAnswer();
                    if (aa != null && this.left_mks[i].equals(aa)) {
                        radio_a.setSelected(true);
                    }
                    radio_a.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            JRadioButton radio = (JRadioButton)evt.getSource();
                            if (radio.isSelected()) {
                                String radioText = radio.getText();
                                QuesPage.this.que.setAnswer(radioText);
                            }
                        }
                    });
                }
                ++i;
            }
        } else if ("\u591a\u9009".equals(text) || "Choice".equals(this.que.getType())) {
            this.que.setType(Question.qtype.Choice.name());
            JLabel qtype3 = new JLabel("\u591a\u9009\u9898");
            qtype3.setBounds(540, 5, 40, 20);
            this.panel.add(qtype3);
            int i = 0;
            while (i < 4) {
                JCheckBox radio_a = new JCheckBox();
                radio_a.setText(this.left_mks[i]);
                if (this.paperType.equals("EXAM") && this.que.getAnswer() != null && this.que.getAnswer().indexOf(this.left_mks[i]) >= 0) {
                    radio_a.setSelected(true);
                }
                int y = 240 + 24 * i;
                radio_a.setBounds(10, y, 40, 22);
                this.panel.add(radio_a);
                JTextField textField_a = UIHelper.newTextField("\u8f93\u5165\u9009\u9879", "item_" + i, this, this.que.getItemDescription(i));
                textField_a.setBounds(50, y, 300, 22);
                this.panel.add(textField_a);
                if (this.paperType.equals("EXAM")) {
                    radio_a.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            JCheckBox ckbox = (JCheckBox)evt.getSource();
                            String newAns = null;
                            String oldAns = QuesPage.this.que.getAnswer();
                            String ckboxText = ckbox.getText();
                            if (ckbox.isSelected()) {
                                if (oldAns != null && oldAns.length() > 0) {
                                    oldAns = String.valueOf(oldAns) + "," + ckboxText;
                                    newAns = QuesPage.sortChoice(oldAns);
                                } else {
                                    newAns = ckboxText;
                                }
                            } else {
                                int left = oldAns.indexOf(ckboxText);
                                if (left > 0) {
                                    newAns = oldAns.substring(0, left - 1);
                                    newAns = String.valueOf(newAns) + oldAns.substring(left + ckboxText.length());
                                } else {
                                    newAns = ckboxText.equals(oldAns) ? "" : oldAns.substring(ckboxText.length() + 1);
                                }
                            }
                            QuesPage.this.que.setAnswer(newAns);
                        }
                    });
                }
                ++i;
            }
        } else if ("\u5224\u65ad".equals(text) || "TrueFalse".equals(this.que.getType())) {
            this.que.setType(Question.qtype.TrueFalse.name());
            JLabel qtype4 = new JLabel("\u5224\u65ad\u9898");
            qtype4.setBounds(540, 5, 40, 20);
            this.panel.add(qtype4);
            ButtonGroup bgrp = new ButtonGroup();
            JRadioButton radio_a = new JRadioButton();
            radio_a.setText("\u6b63\u786e");
            radio_a.setBounds(10, 240, 100, 22);
            bgrp.add(radio_a);
            this.panel.add(radio_a);
            JRadioButton radio_b = new JRadioButton();
            radio_b.setText("\u9519\u8bef");
            radio_b.setBounds(10, 264, 100, 22);
            bgrp.add(radio_b);
            this.panel.add(radio_b);
            Item item_ok = new Item();
            item_ok.setId("\u6b63\u786e");
            item_ok.setType(Item.type.Select.name());
            item_ok.setDescription("\u6b63\u786e");
            this.que.addItem(1, item_ok);
            Item item_er = new Item();
            item_er.setId("\u9519\u8bef");
            item_er.setType(Item.type.Select.name());
            item_er.setDescription("\u9519\u8bef");
            this.que.addItem(2, item_ok);
            if (this.paperType.equals("EXAM")) {
                String a = this.que.getAnswer();
                if (a != null && a.equals("\u6b63\u786e")) {
                    radio_a.setSelected(true);
                } else if (a != null && a.equals("\u9519\u8bef")) {
                    radio_b.setSelected(true);
                }
                radio_a.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JRadioButton radio = (JRadioButton)evt.getSource();
                        if (radio.isSelected()) {
                            QuesPage.this.que.setAnswer("\u6b63\u786e");
                        }
                    }
                });
                radio_b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JRadioButton radio = (JRadioButton)evt.getSource();
                        if (radio.isSelected()) {
                            QuesPage.this.que.setAnswer("\u9519\u8bef");
                        }
                    }
                });
            }
        } else if ("\u5339\u914d".equals(text) || "Matching".equals(this.que.getType())) {
            this.que.setType(Question.qtype.Matching.name());
            JLabel qtype5 = new JLabel("\u5339\u914d\u9898");
            qtype5.setBounds(540, 5, 40, 20);
            this.panel.add(qtype5);
            int i = 0;
            while (i < 4) {
                JLabel label_a = new JLabel();
                label_a.setText(this.left_mks[i]);
                int y = 240 + 24 * i;
                label_a.setBounds(10, y, 20, 22);
                this.panel.add(label_a);
                JTextField textField_a = UIHelper.newTextField("\u8f93\u5165\u5339\u914d\u6e90", "item_" + i, this, this.que.getItemDescription(i));
                textField_a.setBounds(30, y, 150, 22);
                this.panel.add(textField_a);
                ++i;
            }
            DrawPanel draw = new DrawPanel();
            draw.addAnswerListener(this);
            draw.setAnswer(this.que.getAnswer());
            draw.setBounds(180, 240, 200, 94);
            this.panel.add(draw);
            int i2 = 0;
            while (i2 < 4) {
                JLabel label_a = new JLabel();
                label_a.setText(this.right_mks[i2]);
                int y = 240 + 24 * i2;
                label_a.setBounds(380, y, 20, 22);
                this.panel.add(label_a);
                JTextField textField_a = UIHelper.newTextField("\u8f93\u5165\u76ee\u6807\u9879", "item_" + (i2 + 4), this, this.que.getItemDescription(i2 + 4));
                textField_a.setBounds(400, y, 150, 22);
                this.panel.add(textField_a);
                ++i2;
            }
        } else {
            this.que.setType(Question.qtype.Other.name());
            JLabel qtype6 = new JLabel("\u7b80\u8ff0\u9898");
            qtype6.setBounds(540, 5, 40, 20);
            this.panel.add(qtype6);
        }
        this.panel.repaint();
    }

    @Override
    public JPanel getAttrs() {
        if (this.attrs.getComponentCount() == 0) {
            this.attrs.setLayout(null);
            this.attrs.setBackground(Color.white);
            if ("EXAM".equals(this.paperType)) {
                JTextField scoreField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u9898\u5206\u503c", "que_score", this, String.valueOf(this.que.getScore()));
                UIHelper.fillComponent(this.attrs, scoreField, 200, "\u8bd5\u9898\u5206\u503c:", 1);
                JTextField analyseField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u9898\u89e3\u6790", "que_analyse", this, this.que.getAnalyse());
                UIHelper.fillComponent(this.attrs, analyseField, 500, "\u8bd5\u9898\u89e3\u6790:", 2);
                Object[] hards = new String[]{"\u5f88\u5bb9\u6613", "\u5bb9\u6613", "\u4e00\u822c", "\u56f0\u96be", "\u5f88\u56f0\u96be"};
                JPanel hardPanel = UIHelper.newSelect("que_hard", this, "\u9009\u62e9\u8bd5\u9898\u96be\u5ea6", "\u8bd5\u9898\u96be\u5ea6", hards, this.que.getHard());
                UIHelper.fillComponent(this.attrs, hardPanel, 300, "\u8bd5\u9898\u96be\u5ea6:", 3);
                JTextField tagsField = UIHelper.newTextField("\u8f93\u5165\u8bd5\u9898\u77e5\u8bc6\u70b9, \u591a\u4e2a\u77e5\u8bc6\u70b9\u4e4b\u95f4\u4f7f\u7528\u9017\u53f7\u5206\u9694.", "que_tags", this, this.que.getTags());
                UIHelper.fillComponent(this.attrs, tagsField, 500, "\u8bd5\u9898\u77e5\u8bc6\u70b9:", 4);
            }
        }
        return this.attrs;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object val = evt.getNewValue();
        val = ((String)val).replaceAll("\"", "'");
        if ("que_body".equals(propertyName)) {
            this.que.setBody((String)val);
        } else if (propertyName.startsWith("image")) {
            if ("image1".equals(propertyName)) {
                this.que.addImages(0, (String)val);
            } else {
                this.que.addImages(1, (String)val);
            }
        } else if (propertyName.startsWith("item")) {
            String[] pp = propertyName.split("_");
            Item item = new Item();
            int index = 0;
            if ("Selection".equals(this.que.getType())) {
                index = Integer.valueOf(pp[1]);
                item.setId(this.left_mks[index]);
                item.setType(Item.type.Select.name());
                item.setDescription((String)val);
            } else if ("Choice".equals(this.que.getType())) {
                index = Integer.valueOf(pp[1]);
                item.setId(this.left_mks[index]);
                item.setType(Item.type.Choice.name());
                item.setDescription((String)val);
            } else if ("Matching".equals(this.que.getType())) {
                index = Integer.valueOf(pp[1]);
                if (index < 4) {
                    item.setId(this.left_mks[index]);
                    item.setType(Item.type.Source.name());
                } else {
                    item.setId(this.right_mks[index - 4]);
                    item.setType(Item.type.Target.name());
                }
                item.setDescription((String)val);
            }
            this.que.addItem(index, item);
        } else if ("que_answer".equals(propertyName)) {
            this.que.setAnswer((String)val);
        } else if ("que_score".equals(propertyName)) {
            this.que.setScore(Float.valueOf((String)val).floatValue());
        } else if ("que_analyse".equals(propertyName)) {
            this.que.setAnalyse((String)val);
        } else if ("que_hard".equals(propertyName)) {
            this.que.setHard((String)val);
        } else if ("que_tags".equals(propertyName)) {
            this.que.setTags((String)val);
        }
    }

    static String sortChoice(String old) {
        Object[] marks = old.split(",");
        Arrays.sort(marks);
        StringBuffer sb = new StringBuffer((String)marks[0]);
        int i = 1;
        while (i < marks.length) {
            sb.append(',').append((String)marks[i]);
            ++i;
        }
        return sb.toString();
    }
}

