/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper;

import com.neuedu.educloud.tools.core.LoggerDialog;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.paper.ItemPage;
import com.neuedu.educloud.tools.paper.QuesPage;
import com.neuedu.educloud.tools.paper.TitlePage;
import com.neuedu.educloud.tools.paper.model.ModelChangedEvent;
import com.neuedu.educloud.tools.paper.model.ModelChangedListener;
import com.neuedu.educloud.tools.paper.model.Paper;
import com.neuedu.educloud.tools.paper.model.Question;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JViewport;

public class PaperRender
implements ModelChangedListener {
    private Paper model = null;
    private Resource resource = null;
    private List<ItemPage> items = new ArrayList<ItemPage>();
    private List<String> qids = new ArrayList<String>();
    private JPanel naviPanel;
    private JPanel questionPanel;
    private JPanel attributePanel;
    private Dimension labelSize;
    private Dimension panelSize;
    private int lastSelect = -1;
    private JPopupMenu popupMenu = new JPopupMenu("Popup");
    private JMenuItem binsertItem = new JMenuItem("\u63d2\u5165\u4e0a\u9875");
    private JMenuItem ainsertItem = new JMenuItem("\u63d2\u5165\u4e0b\u9875");
    private JMenuItem deleteItem = new JMenuItem("\u5220\u9664");
    private JToolBar toolBar = new JToolBar();
    private JButton bInsBtn = new JButton();
    private JButton aInsBtn = new JButton();
    private JButton rmBtn = new JButton();
    private JButton saveBtn = new JButton();

    public PaperRender(JPanel toolPanel, JPanel naviPanel, JPanel questionPanel, JPanel attributePanel, Resource res) {
        this.resource = res;
        this.naviPanel = naviPanel;
        this.questionPanel = questionPanel;
        this.attributePanel = attributePanel;
        this.labelSize = new Dimension(80, 60);
        this.panelSize = new Dimension(600, 360);
        this.binsertItem.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/ques_bins.png")));
        this.binsertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaperRender.this.onPopupItemClicked(e);
            }
        });
        this.ainsertItem.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/ques_ains.png")));
        this.ainsertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaperRender.this.onPopupItemClicked(e);
            }
        });
        this.deleteItem.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/ques_del.png")));
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaperRender.this.onPopupItemClicked(e);
            }
        });
        this.popupMenu.add(this.binsertItem);
        this.popupMenu.add(this.ainsertItem);
        this.popupMenu.add(new JPopupMenu.Separator());
        this.popupMenu.add(this.deleteItem);
        this.bInsBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/ques_bins.png")));
        this.bInsBtn.setToolTipText("\u5728\u524d\u9762\u63d2\u5165\u65b0\u7684\u8bd5\u9898");
        this.bInsBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PaperRender.this.lastSelect > 0) {
                    PaperRender.this.insertQuestion(PaperRender.this.lastSelect);
                }
            }
        });
        this.bInsBtn.setFocusable(false);
        this.aInsBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/ques_ains.png")));
        this.aInsBtn.setToolTipText("\u5728\u540e\u9762\u63d2\u5165\u65b0\u7684\u8bd5\u9898");
        this.aInsBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PaperRender.this.insertQuestion(PaperRender.this.lastSelect + 1);
            }
        });
        this.aInsBtn.setFocusable(false);
        this.rmBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/ques_del.png")));
        this.rmBtn.setToolTipText("\u5220\u9664\u8bd5\u9898");
        this.rmBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PaperRender.this.lastSelect > 0) {
                    PaperRender.this.removeQuestion(PaperRender.this.lastSelect);
                }
            }
        });
        this.rmBtn.setFocusable(false);
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/save.png")));
        this.saveBtn.setToolTipText("\u4fdd\u5b58\u8bd5\u5377");
        this.saveBtn.setFocusable(false);
        this.saveBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block13: {
                    FilterOutputStream dos = null;
                    try {
                        try {
                            File fff = null;
                            fff = PaperRender.this.resource == null ? new File("works/temp/paper.json") : new File("works/" + PaperRender.this.resource.getId() + "/paper.json");
                            if (fff.exists()) {
                                fff.delete();
                            }
                            fff.createNewFile();
                            dos = new DataOutputStream(new FileOutputStream(fff));
                            String json = PaperRender.this.model.toString();
                            dos.write(json.getBytes("utf-8"));
                            ((DataOutputStream)dos).flush();
                            dos.close();
                        }
                        catch (Exception ioe) {
                            LoggerDialog.logger(ioe, "\u8bd5\u5377\u751f\u6210\u9519\u8bef");
                            if (dos == null) break block13;
                            try {
                                dos.close();
                            }
                            catch (Exception de) {
                                de.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (dos != null) {
                            try {
                                dos.close();
                            }
                            catch (Exception de) {
                                de.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        this.toolBar.add(this.saveBtn);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.bInsBtn);
        this.toolBar.add(this.aInsBtn);
        this.toolBar.add(this.rmBtn);
        toolPanel.add((Component)this.toolBar, "Center");
    }

    public void setModel(Paper model) {
        this.model = model;
        this.model.addChangedListener(this);
    }

    public void render() {
        TitlePage titlePage = new TitlePage(this.model);
        this.items.add(titlePage);
        this.qids.add(titlePage.getId());
        List<Question> questions = this.model.getQuestions();
        for (Question q : questions) {
            QuesPage quesPage = new QuesPage(q, this.model);
            this.items.add(quesPage);
            this.qids.add(quesPage.getId());
        }
        for (ItemPage page : this.items) {
            JLabel label = this.findLabel(page);
            this.naviPanel.add(label);
            JPanel panel = this.findPanel(page);
            this.questionPanel.add(panel);
        }
    }

    public void select(int index) {
        if (this.lastSelect > -1 && this.lastSelect < this.items.size()) {
            ItemPage lastPage = this.items.get(this.lastSelect);
            lastPage.getLabel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white, 5), BorderFactory.createLineBorder(Color.black)));
            this.lastSelect = -1;
        }
        ItemPage page = this.items.get(index);
        page.getLabel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white, 5), BorderFactory.createLineBorder(Color.orange)));
        String id = page.getLabel().getName();
        int inx = this.findQuestionIndex(id);
        JViewport scroll = (JViewport)this.questionPanel.getParent();
        Rectangle cRect = scroll.getViewRect();
        int tY = inx * this.panelSize.height;
        Rectangle aRect = new Rectangle(cRect.x, tY - cRect.y, this.panelSize.width, this.panelSize.height);
        scroll.scrollRectToVisible(aRect);
        this.attributePanel.removeAll();
        JPanel attributes = page.getAttrs();
        if (attributes != null) {
            this.attributePanel.add((Component)attributes, "Center");
        }
        this.attributePanel.validate();
        this.attributePanel.updateUI();
        this.lastSelect = index;
    }

    private void onLabelClicked(MouseEvent evt) {
        JLabel label = (JLabel)evt.getSource();
        String id = label.getName();
        int index = this.findQuestionIndex(id);
        this.select(index);
    }

    private void onPanelClicked(MouseEvent evt) {
        JPanel panel = (JPanel)evt.getSource();
        String id = panel.getName();
        int index = this.findQuestionIndex(id);
        this.select(index);
    }

    private void onPopupItemClicked(ActionEvent evt) {
        JMenuItem item = (JMenuItem)evt.getSource();
        if (item.equals(this.ainsertItem)) {
            this.insertQuestion(this.lastSelect + 1);
        } else if (item.equals(this.binsertItem)) {
            this.insertQuestion(this.lastSelect);
            ++this.lastSelect;
        } else {
            this.removeQuestion(this.lastSelect);
        }
    }

    private void insertQuestion(int index) {
        Question que = new Question();
        this.model.add(index, que);
    }

    private void removeQuestion(int index) {
        this.model.remove(index);
    }

    private JPanel findPanel(ItemPage page) {
        JPanel panel = page.getPanel();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.questionPanel.getBackground(), 5), BorderFactory.createEtchedBorder()));
        panel.setBackground(Color.white);
        panel.setAlignmentX(0.5f);
        panel.setMaximumSize(this.panelSize);
        panel.setMinimumSize(this.panelSize);
        panel.setPreferredSize(this.panelSize);
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PaperRender.this.onPanelClicked(e);
            }
        });
        return panel;
    }

    private JLabel findLabel(ItemPage page) {
        JLabel label = page.getLabel();
        label.setHorizontalAlignment(0);
        label.setBackground(Color.lightGray);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white, 5), BorderFactory.createLineBorder(Color.black)));
        label.setAlignmentX(0.5f);
        label.setMaximumSize(this.labelSize);
        label.setMinimumSize(this.labelSize);
        label.setPreferredSize(this.labelSize);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PaperRender.this.onLabelClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    if (PaperRender.this.lastSelect > 0) {
                        PaperRender.this.binsertItem.setEnabled(true);
                        PaperRender.this.deleteItem.setEnabled(true);
                    } else {
                        PaperRender.this.binsertItem.setEnabled(false);
                        PaperRender.this.deleteItem.setEnabled(false);
                    }
                    PaperRender.this.ainsertItem.setEnabled(true);
                    PaperRender.this.popupMenu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }
        });
        return label;
    }

    private int findQuestionIndex(String id) {
        int i = 0;
        while (i < this.qids.size()) {
            if (this.qids.get(i).equals(id)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void onAdd(ModelChangedEvent e) {
        Question nq = (Question)e.getNewValue();
        String id = nq.getId();
        int index = e.getIndex();
        QuesPage page = new QuesPage(nq, this.model);
        this.items.add(index, page);
        this.qids.add(index, id);
        JLabel label = this.findLabel(page);
        this.naviPanel.add((Component)label, index);
        JPanel panel = this.findPanel(page);
        this.questionPanel.add((Component)panel, index);
        this.naviPanel.validate();
        this.questionPanel.validate();
        JViewport nscroll = (JViewport)this.naviPanel.getParent();
        nscroll.validate();
        JViewport scroll = (JViewport)this.questionPanel.getParent();
        scroll.validate();
        if (this.lastSelect == index) {
            ++this.lastSelect;
        }
        this.select(index);
    }

    @Override
    public void onUpdate(ModelChangedEvent e) {
    }

    @Override
    public void onRemove(ModelChangedEvent e) {
        int index = e.getIndex();
        ItemPage page = this.items.remove(index);
        this.qids.remove(index);
        this.naviPanel.remove(page.getLabel());
        this.questionPanel.remove(page.getPanel());
        this.naviPanel.validate();
        this.naviPanel.repaint();
        this.questionPanel.validate();
        JViewport nscroll = (JViewport)this.naviPanel.getParent();
        nscroll.validate();
        JViewport scroll = (JViewport)this.questionPanel.getParent();
        scroll.validate();
        this.lastSelect = -1;
        if (index > 1) {
            this.select(index - 1);
        } else {
            this.select(0);
        }
    }
}

