/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper;

import com.neuedu.educloud.tools.ResourceMaker;
import com.neuedu.educloud.tools.core.LoggerDialog;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.paper.PaperRender;
import com.neuedu.educloud.tools.paper.model.Paper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.codehaus.jettison.json.JSONObject;

public class PaperEditor {
    private boolean isShow = false;
    private ResourceMaker parent;
    private JDialog editor;
    private Paper paperModel;
    private Resource res = null;

    public PaperEditor(ResourceMaker frame) {
        this.parent = frame;
    }

    public boolean isShow() {
        return this.isShow;
    }

    public void show() {
        this.editor = new JDialog(this.parent);
        this.editor.setResizable(false);
        this.editor.setLayout(new BorderLayout());
        this.editor.setTitle("\u8bd5\u5377\u7f16\u8f91\u5668");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.editor.setSize(800, 600);
        this.editor.setLocation(dimension.width / 2 - 400, dimension.height / 2 - 300);
        this.editor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                block19: {
                    FilterOutputStream dos = null;
                    try {
                        try {
                            File fff = null;
                            fff = PaperEditor.this.res == null ? new File("works/temp/paper.json") : new File("works/" + PaperEditor.this.res.getId() + "/paper.json");
                            if (fff.exists()) {
                                fff.delete();
                            }
                            fff.createNewFile();
                            dos = new DataOutputStream(new FileOutputStream(fff));
                            String json = PaperEditor.this.paperModel.toString();
                            dos.write(json.getBytes("utf-8"));
                            ((DataOutputStream)dos).flush();
                            dos.close();
                            if (PaperEditor.this.res == null) {
                                Resource res = new Resource(PaperEditor.this.paperModel.getId());
                                res.setName(PaperEditor.this.paperModel.getName());
                                res.setDescription(PaperEditor.this.paperModel.getDescription());
                                res.setQueNum(PaperEditor.this.paperModel.getQueNum());
                                if ("EXAM".equals(PaperEditor.this.paperModel.getType())) {
                                    res.setType(Resource.EXAM_TYPE);
                                } else if ("EVALUATION".equals(PaperEditor.this.paperModel.getType())) {
                                    res.setType(Resource.EVALUATION_TYPE);
                                } else {
                                    res.setType(Resource.SURVEY_TYPE);
                                }
                                res.setStatus(Resource.SAVED);
                                PaperEditor.this.parent.generateResource(res);
                            } else {
                                PaperEditor.this.res.setName(PaperEditor.this.paperModel.getName());
                                PaperEditor.this.res.setDescription(PaperEditor.this.paperModel.getDescription());
                                PaperEditor.this.res.setQueNum(PaperEditor.this.paperModel.getQueNum());
                                PaperEditor.this.parent.refreshResource(PaperEditor.this.res);
                            }
                            PaperEditor.this.isShow = false;
                            PaperEditor.this.editor.setVisible(false);
                            PaperEditor.this.editor.dispose();
                        }
                        catch (Exception ioe) {
                            LoggerDialog.logger(ioe, "\u8bd5\u5377\u751f\u6210\u9519\u8bef");
                            if (dos == null) break block19;
                            try {
                                dos.close();
                            }
                            catch (Exception de) {
                                de.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (dos != null) {
                            try {
                                dos.close();
                            }
                            catch (Exception de) {
                                de.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        this.isShow = true;
        Object paperType = null;
        if (this.paperModel.getType() == null) {
            paperType = JOptionPane.showInputDialog(this.parent, "\u9009\u62e9\u8bd5\u5377\u7c7b\u578b", "\u8bd5\u5377\u5236\u4f5c", 1, null, new String[]{"\u8003\u8bd5", "\u8bc4\u4f30", "\u8c03\u67e5"}, "\u8003\u8bd5");
        }
        if (paperType != null || this.paperModel.getType() != null) {
            JPanel toolPanel = new JPanel();
            toolPanel.setLayout(new BorderLayout());
            this.editor.add((Component)toolPanel, "North");
            Dimension dim1 = new Dimension(120, 600);
            JScrollPane leftPane = new JScrollPane();
            leftPane.setBorder(BorderFactory.createEmptyBorder());
            leftPane.setColumnHeaderView(new JLabel(" \u5bfc\u822a"));
            leftPane.setHorizontalScrollBarPolicy(31);
            leftPane.setPreferredSize(dim1);
            JPanel naviPanel = new JPanel();
            naviPanel.setLayout(new BoxLayout(naviPanel, 1));
            naviPanel.setBackground(Color.white);
            leftPane.setViewportView(naviPanel);
            this.editor.add((Component)leftPane, "West");
            JSplitPane mainPane = new JSplitPane();
            mainPane.setBorder(BorderFactory.createEtchedBorder());
            mainPane.setOrientation(0);
            JScrollPane questionPane = new JScrollPane();
            questionPane.setHorizontalScrollBarPolicy(31);
            questionPane.setColumnHeaderView(new JLabel(" \u5c01\u9762 / \u8bd5\u9898"));
            questionPane.setBorder(BorderFactory.createEmptyBorder());
            JPanel questionPanel = new JPanel();
            questionPanel.setLayout(new BoxLayout(questionPanel, 1));
            questionPane.setViewportView(questionPanel);
            mainPane.setTopComponent(questionPane);
            mainPane.setDividerLocation(400);
            JScrollPane attributePane = new JScrollPane();
            attributePane.setColumnHeaderView(new JLabel(" \u5c5e\u6027"));
            attributePane.setHorizontalScrollBarPolicy(31);
            attributePane.setBorder(BorderFactory.createEmptyBorder());
            JPanel attributePanel = new JPanel();
            attributePanel.setLayout(new BorderLayout());
            attributePane.setViewportView(attributePanel);
            mainPane.setBottomComponent(attributePane);
            if (paperType != null) {
                if ("\u8003\u8bd5".equals(paperType)) {
                    this.paperModel.setType("EXAM");
                } else if ("\u8bc4\u4f30".equals(paperType)) {
                    this.paperModel.setType("EVALUATION");
                } else {
                    this.paperModel.setType("SURVEY");
                }
            }
            PaperRender prender = new PaperRender(toolPanel, naviPanel, questionPanel, attributePanel, this.res);
            prender.setModel(this.paperModel);
            prender.render();
            prender.select(0);
            this.editor.add((Component)mainPane, "Center");
            this.editor.setVisible(true);
        } else {
            this.editor.setVisible(false);
            this.isShow = false;
            this.editor.dispose();
        }
    }

    public void newPaper() {
        this.paperModel = new Paper();
        this.res = null;
        this.show();
    }

    public void editPaper(Resource res) {
        this.res = res;
        this.loadModel();
        this.show();
    }

    private void loadModel() {
        block12: {
            FileInputStream fis = null;
            try {
                try {
                    File paper = null;
                    paper = this.res == null ? new File("works/temp/paper.json") : new File("works/" + this.res.getId() + "/paper.json");
                    fis = new FileInputStream(paper);
                    byte[] b = new byte[fis.available()];
                    fis.read(b);
                    String json = new String(b, "utf-8");
                    fis.close();
                    fis = null;
                    JSONObject jsonobj = new JSONObject(json);
                    this.paperModel = new Paper(jsonobj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fis == null) break block12;
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

