/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.paper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class DrawPanel
extends JLabel {
    private static final long serialVersionUID = 91911L;
    private Map map = new HashMap();
    private boolean repaintAnswer = false;
    private String[] left_names = new String[]{"A", "B", "C", "D"};
    private String[] right_names = new String[]{"1", "2", "3", "4"};
    private int x0 = 2;
    private int x1 = 182;
    private int[] ys = new int[4];
    private PropertyChangeListener listener;
    private JLabel firstLabel = null;
    private JLabel secondLabel = null;

    public void addAnswerListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(Color.white);
        int i = 0;
        while (i < 4) {
            JLabel label_a = new JLabel();
            label_a.setName(String.valueOf(i));
            label_a.setBackground(Color.lightGray);
            label_a.setBorder(BorderFactory.createEtchedBorder());
            this.ys[i] = 3 + 24 * i;
            label_a.setBounds(this.x0, this.ys[i], 16, 16);
            this.add(label_a);
            label_a.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JLabel label = (JLabel)e.getSource();
                    DrawPanel.this.doLine(label);
                }
            });
            ++i;
        }
        i = 0;
        while (i < 4) {
            JLabel label_1 = new JLabel();
            label_1.setName(String.valueOf(i));
            label_1.setBackground(Color.lightGray);
            label_1.setBorder(BorderFactory.createEtchedBorder());
            label_1.setBounds(this.x1, this.ys[i], 16, 16);
            this.add(label_1);
            label_1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JLabel label = (JLabel)e.getSource();
                    DrawPanel.this.doLine(label);
                }
            });
            ++i;
        }
        if (this.map != null && !this.map.isEmpty()) {
            this.drawLine(g);
            this.repaintAnswer = false;
        }
    }

    public String getAnswer() {
        StringBuffer sb = new StringBuffer();
        sb.append("A-").append((String)this.map.get("A")).append(",");
        sb.append("B-").append((String)this.map.get("B")).append(",");
        sb.append("C-").append((String)this.map.get("C")).append(",");
        sb.append("D-").append((String)this.map.get("D"));
        return sb.toString();
    }

    public void setAnswer(String answer) {
        if (answer != null && !"".equals(answer) && !"null".equals(answer)) {
            String[] ans;
            String[] stringArray = ans = answer.split(",");
            int n = ans.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] kv = s.split("-");
                this.map.put(kv[0], kv[1]);
                ++n2;
            }
        }
        this.repaintAnswer = true;
    }

    private void drawLine(Graphics g) {
        for (String key : this.map.keySet()) {
            String val = (String)this.map.get(key);
            int left = Arrays.binarySearch(this.left_names, key);
            int right = Arrays.binarySearch(this.right_names, val);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.red);
            g2d.drawLine(this.x0 + 8, this.ys[left] + 8, this.x1 + 8, this.ys[right] + 8);
        }
    }

    private void dispatch() {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "que_answer", null, this.getAnswer());
        this.listener.propertyChange(evt);
    }

    private void doLine(JLabel label) {
        block17: {
            int x;
            block14: {
                String oldval;
                String oldkey;
                block16: {
                    int cur;
                    block15: {
                        Color bgcolor = label.getBackground();
                        x = label.getX();
                        if (bgcolor == Color.blue) break block14;
                        if (this.firstLabel != null && this.firstLabel.getX() == x) {
                            this.firstLabel.setBackground(Color.lightGray);
                            this.firstLabel = label;
                        } else if (this.secondLabel != null && this.secondLabel.getX() == x) {
                            this.secondLabel.setBackground(Color.lightGray);
                            this.secondLabel = label;
                        }
                        cur = Integer.valueOf(label.getName());
                        oldkey = null;
                        oldval = null;
                        if (label.getX() != this.x0) break block15;
                        oldkey = this.left_names[cur];
                        if (!this.map.containsKey(oldkey)) break block16;
                        oldval = (String)this.map.get(oldkey);
                        break block16;
                    }
                    oldval = this.right_names[cur];
                    for (String k : this.map.keySet()) {
                        String v = (String)this.map.get(k);
                        if (!v.equals(oldval)) continue;
                        oldkey = k;
                        break;
                    }
                }
                if (oldkey != null && oldval != null) {
                    Graphics2D g2d = (Graphics2D)this.getGraphics();
                    g2d.setColor(Color.white);
                    g2d.drawLine(this.x0 + 8, this.ys[Arrays.binarySearch(this.left_names, oldkey)] + 8, this.x1 + 8, this.ys[Arrays.binarySearch(this.right_names, oldval)] + 8);
                    this.map.remove(oldkey);
                }
                label.setBackground(Color.blue);
                if (this.firstLabel == null) {
                    this.firstLabel = label;
                } else {
                    this.secondLabel = label;
                }
                if (this.firstLabel != null && this.secondLabel != null) {
                    int left = Integer.valueOf(this.firstLabel.getName());
                    int right = Integer.valueOf(this.secondLabel.getName());
                    String key = null;
                    String val = null;
                    if (this.firstLabel.getX() < this.secondLabel.getX()) {
                        key = this.left_names[left];
                        val = this.right_names[right];
                    } else {
                        key = this.left_names[right];
                        val = this.right_names[left];
                    }
                    this.map.put(key, val);
                    if (this.map.size() == 4) {
                        this.dispatch();
                    }
                    Graphics2D g2d = (Graphics2D)this.getGraphics();
                    g2d.setColor(Color.red);
                    g2d.drawLine(this.firstLabel.getX() + 8, this.ys[left] + 8, this.secondLabel.getX() + 8, this.ys[right] + 8);
                    this.firstLabel.setBackground(Color.lightGray);
                    this.secondLabel.setBackground(Color.lightGray);
                    this.firstLabel = null;
                    this.secondLabel = null;
                }
                break block17;
            }
            label.setBackground(Color.lightGray);
            if (this.firstLabel != null && this.firstLabel.getX() == x) {
                this.firstLabel = null;
            } else if (this.secondLabel != null && this.secondLabel.getX() == x) {
                this.secondLabel = null;
            }
        }
    }
}

