/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.export;

import com.neuedu.educloud.tools.core.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ScormPackager {
    private RandomAccessFile fas = null;
    private Resource res = null;
    private File zipFile = null;

    public ScormPackager(Resource res) {
        this.res = res;
    }

    public void zip(String outPath) throws Exception {
        this.zipFile = new File(String.valueOf(outPath) + "/" + this.res.getId() + ".zip");
        if (this.zipFile.exists()) {
            this.zipFile.delete();
        }
        this.zipFile.createNewFile();
        this.zip(this.zipFile, "works/" + this.res.getId(), "templets/" + this.res.getId());
    }

    private void zip(File zipFile, String srcFolder, String scormFiles) throws Exception {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        try {
            if (!srcFolder.endsWith("/")) {
                srcFolder = String.valueOf(srcFolder) + "/";
            }
            if (!scormFiles.endsWith("/")) {
                scormFiles = String.valueOf(scormFiles) + "/";
            }
            fileWriter = new FileOutputStream(zipFile);
            zip = new ZipOutputStream(fileWriter);
            this.addFolderToZip(srcFolder, "", zip);
            this.addFolderToZip(scormFiles, "", zip);
            zip.flush();
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void addFileToZip(String base, String srcFile, ZipOutputStream zip) throws Exception {
        int len;
        File file = new File(String.valueOf(base) + srcFile);
        if (file.getName().equals("audio.wav")) {
            return;
        }
        byte[] buf = new byte[1024];
        FileInputStream in = new FileInputStream(file);
        zip.putNextEntry(new ZipEntry(srcFile));
        while ((len = in.read(buf)) > 0) {
            zip.write(buf, 0, len);
        }
        in.close();
    }

    private void addFolderToZip(String base, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(String.valueOf(base) + srcFolder);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.addFileToZip(base, String.valueOf(srcFolder) + file.getName(), zip);
            } else {
                this.addFolderToZip(base, String.valueOf(srcFolder) + file.getName() + "/", zip);
            }
            ++n2;
        }
    }

    public void open() throws Exception {
        this.fas = new RandomAccessFile(this.zipFile, "r");
    }

    public void close() {
        if (this.fas != null) {
            try {
                this.fas.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int read(byte[] buf, int off) throws Exception {
        int r = 0;
        this.fas.seek(off);
        r = this.fas.read(buf);
        return r;
    }

    public int length() {
        return Long.valueOf(this.zipFile.length()).intValue();
    }
}

