/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.export;

import com.neuedu.educloud.tools.core.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ScormMaker {
    private Resource res = null;
    private String outdir = null;

    public ScormMaker(Resource res) {
        this.res = res;
        this.outdir = "templets/" + res.getId();
        File dir = new File(this.outdir);
        dir.mkdirs();
    }

    public void make() throws Exception {
        if (this.res.getType() == Resource.COURSE_TYPE) {
            this.makeCourse();
        } else {
            this.makePaper();
        }
    }

    private void makeCourse() throws Exception {
        File tmps = new File("templets/default.zip");
        this.unzipTmpls(tmps, this.outdir);
        File imsmanifest = new File(String.valueOf(this.outdir) + "/imsmanifest.xml");
        StringBuffer ims = new StringBuffer();
        ims.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><manifest identifier=\"SingleCourseManifest\" version=\"1.1\" xmlns=\"http://www.imsproject.org/xsd/imscp_rootv1p1p2\" xmlns:adlcp=\"http://www.adlnet.org/xsd/adlcp_rootv1p2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.imsproject.org/xsd/imscp_rootv1p1p2 imscp_rootv1p1p2.xsd http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd http://www.adlnet.org/xsd/adlcp_rootv1p2 adlcp_rootv1p2.xsd\">");
        ims.append("<organizations default=\"ORG-").append(this.res.getId()).append("\"><organization identifier=\"ORG-").append(this.res.getId()).append("\"><title>").append(this.res.getName()).append("</title><item identifier=\"ITEM-").append(this.res.getId()).append("\" isvisible=\"true\" identifierref=\"RES-").append(this.res.getId()).append("\"><title>").append(this.res.getName()).append("</title></item><metadata><schema>ADL SCORM</schema><schemaversion>1.2</schemaversion></metadata></organization></organizations>");
        ims.append("<resources><resource identifier=\"RES-").append(this.res.getId()).append("\" type=\"webcontent\" adlcp:scormtype=\"sco\" href=\"index.html\"><file href=\"index.html\" /></resource></resources></manifest>");
        FileOutputStream fos_imsmanifest = null;
        try {
            fos_imsmanifest = new FileOutputStream(imsmanifest);
            fos_imsmanifest.write(ims.toString().getBytes("utf-8"));
            fos_imsmanifest.flush();
        }
        finally {
            if (fos_imsmanifest != null) {
                try {
                    fos_imsmanifest.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        long alltimes = this.res.getAlltime();
        long[] times = this.loadTimes();
        File htmlfile = new File(String.valueOf(this.outdir) + "/index.html");
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE html><html lang=\"zh\"><head><meta charset=\"utf-8\"><title>").append(this.res.getName()).append("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"skins/layout.css\"><link rel=\"stylesheet\" type=\"text/css\" href=\"skins/audio.css\"><script type=\"text/javascript\" src=\"scripts/emptyapi.js\"></script><script type=\"text/javascript\" src=\"scripts/apiwrapper.js\"></script><script type=\"text/javascript\" src=\"scripts/scofunctions.js\"></script><script type=\"text/javascript\" src=\"scripts/timesheets.js\"></script></head>").append("<body class=\"audioPlayer\"><div id=\"demo\"><div class=\"highlight\"><div id=\"media\" data-timecontainer=\"excl\" data-mediasync=\"audio\" data-dur=\"").append(this.formatTimes(alltimes)).append("\" >");
        int i = 0;
        while (i < times.length) {
            html.append("<div id=\"section").append(i).append("\" data-begin=\"").append(this.formatTimes(times[i])).append("\" ");
            if (i == 0) {
                html.append("data-onbegin=\"loadPage()\"");
            } else if (i == times.length - 1) {
                html.append("data-onend=\"unloadPage('completed')\"");
            }
            html.append("><img style=\"float: left;\" src=\"").append(i + 1).append(".jpg\"/></div>");
            ++i;
        }
        html.append("</div><div id=\"mediaController\"><audio id=\"audioPlayer\" controls autoplay preload=\"auto\"><source src=\"audio.ogg\" type=\"audio/ogg\" /><source src=\"audio.mp3\" type=\"audio/mpeg\" /></audio></div></div></div></body><script type=\"text/javascript\" src=\"scripts/tracing.js\"></script></html>");
        FileOutputStream fos_html = null;
        try {
            fos_html = new FileOutputStream(htmlfile);
            fos_html.write(html.toString().getBytes("utf-8"));
            fos_html.flush();
        }
        finally {
            if (fos_html != null) {
                try {
                    fos_html.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void clear() {
        File dir = new File(this.outdir);
        dir.delete();
    }

    private void unzipTmpls(File zfile, String targetPath) throws Exception {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            ZipFile zipFile = new ZipFile(zfile, 1);
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            boolean i = false;
            while (emu.hasMoreElements()) {
                int count;
                ZipEntry entry = emu.nextElement();
                String fileName = entry.getName().toLowerCase();
                boolean isDir = entry.isDirectory();
                bis = new BufferedInputStream(zipFile.getInputStream(entry));
                File file = new File(String.valueOf(targetPath) + "/" + fileName);
                if (isDir) {
                    file.mkdir();
                    continue;
                }
                int BUFFER = 40960;
                bos = new BufferedOutputStream(new FileOutputStream(file), BUFFER);
                byte[] data = new byte[BUFFER];
                while ((count = bis.read(data, 0, BUFFER)) != -1) {
                    ((BufferedOutputStream)bos).write(data, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
                bos = null;
            }
            zipFile.close();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String formatTimes(long alltime) {
        int time = Long.valueOf(alltime).intValue();
        int seconds = time / 1000;
        int h = seconds / 3600;
        int fmah = seconds - h * 3600;
        int m = fmah / 60;
        int s = fmah - m * 60;
        int ss = time % 1000;
        StringBuffer sb = new StringBuffer();
        sb.append(h < 10 ? "0" : "").append(h).append(':').append(m < 10 ? "0" : "").append(m).append(':').append(s < 10 ? "0" : "").append(s);
        if (ss > 0) {
            sb.append(".").append(ss < 10 ? "00" : (ss < 100 ? "0" : "")).append(ss);
        }
        return sb.toString();
    }

    private long[] loadTimes() throws Exception {
        File tf = new File("works/" + this.res.getId() + "/time.txt");
        long[] points = null;
        try (FilterInputStream reader = null;){
            reader = new DataInputStream(new FileInputStream(tf));
            String tt = ((DataInputStream)reader).readLine();
            String[] tps = tt.split(",");
            points = new long[tps.length];
            int i = 0;
            while (i < tps.length) {
                points[i] = Long.valueOf(tps[i]);
                ++i;
            }
        }
        return points;
    }

    private void makePaper() throws Exception {
    }
}

