/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.export;

import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.course.Wav2Ogg;
import com.neuedu.educloud.tools.export.ScormMaker;
import com.neuedu.educloud.tools.export.ScormPackager;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;

public class ScormExport {
    private JDialog export;
    private Resource res;
    private String exportPath;
    JProgressBar generateProgress;
    JLabel generateLabel;

    public ScormExport(JFrame parent, Resource res) {
        this.res = res;
        this.export = new JDialog(parent);
        this.export.setSize(300, 200);
        this.export.setTitle("\u5bfc\u51fa:" + res.getName());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.export.setLocation(dimension.width / 2 - 150, dimension.height / 2 - 100);
        this.initPane();
        this.export.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ScormExport.this.export.setVisible(false);
                ScormExport.this.export.dispose();
            }
        });
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int intRetVal = fc.showOpenDialog(this.export);
        if (intRetVal == 0) {
            this.exportPath = fc.getSelectedFile().getPath();
            this.export.setVisible(true);
            this.startExport();
        }
    }

    private void initPane() {
        JRootPane panel = this.export.getRootPane();
        this.generateProgress = new JProgressBar();
        this.generateProgress.setStringPainted(true);
        this.generateLabel = new JLabel();
        panel.setMinimumSize(new Dimension(300, 60));
        panel.setPreferredSize(new Dimension(300, 60));
        this.generateLabel.setText("\u6b63\u5728\u751f\u6210\u6587\u4ef6,\u8bf7\u7b49\u5f85");
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generateProgress, -1, 276, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.generateLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.generateLabel).addGap(18, 18, 18).addComponent(this.generateProgress, -2, -1, -2).addContainerGap(75, Short.MAX_VALUE)));
    }

    private void startExport() {
        try {
            this.generateProgress.setMinimum(0);
            this.generateLabel.setText("[1/4]\u6b63\u5728\u751f\u6210\u8bed\u97f3\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            String outdir = "works/" + this.res.getId();
            this.generateProgress.setValue(5);
            try {
                Wav2Ogg.writeFile(String.valueOf(outdir) + "/audio.wav", String.valueOf(outdir) + "/audio.ogg");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            this.generateProgress.setValue(20);
            this.generateLabel.setText("[2/4]\u6b63\u5728\u751f\u6210SCORM\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            ScormMaker mkr = new ScormMaker(this.res);
            mkr.make();
            this.generateProgress.setValue(40);
            this.generateLabel.setText("[3/4]\u6b63\u5728\u5bfc\u51fa,\u8bf7\u7b49\u5f85");
            ScormPackager pkc = new ScormPackager(this.res);
            pkc.zip(this.exportPath);
            this.generateProgress.setValue(80);
            this.generateLabel.setText("[4/4]\u6e05\u7406\u4e34\u65f6\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            mkr.clear();
            this.generateProgress.setValue(100);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.generateLabel.setText("[Error]" + e.getMessage());
        }
        this.generateLabel.setText("\u5bfc\u51fa\u5b8c\u6210\u3002");
    }
}

