/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import com.neuedu.educloud.tools.core.LoggerDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.xiph.libogg.ogg_packet;
import org.xiph.libogg.ogg_page;
import org.xiph.libogg.ogg_stream_state;
import org.xiph.libvorbis.vorbis_block;
import org.xiph.libvorbis.vorbis_comment;
import org.xiph.libvorbis.vorbis_dsp_state;
import org.xiph.libvorbis.vorbis_info;
import org.xiph.libvorbis.vorbisenc;

public class Wav2Ogg {
    private static vorbisenc encoder;
    private static ogg_stream_state os;
    private static ogg_page og;
    private static ogg_packet op;
    private static vorbis_info vi;
    private static vorbis_comment vc;
    private static vorbis_dsp_state vd;
    private static vorbis_block vb;
    private static int READ;
    private static byte[] readbuffer;
    private static int page_count;
    private static int block_count;

    static {
        READ = 1024;
        readbuffer = new byte[READ * 4 + 44];
        page_count = 0;
        block_count = 0;
    }

    private static AudioFormat getInStreamFormat(String filename) {
        AudioFormat sourceFormat;
        block12: {
            File file = new File(filename);
            AudioInputStream ais = null;
            sourceFormat = null;
            try {
                try {
                    ais = AudioSystem.getAudioInputStream(file);
                    sourceFormat = ais.getFormat();
                }
                catch (Exception e) {
                    LoggerDialog.logger(e, null);
                    if (ais == null) break block12;
                    try {
                        ais.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (ais != null) {
                    try {
                        ais.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return sourceFormat;
    }

    public static void writeFile(String inFilename, String outFilename) {
        block31: {
            AudioFormat sourceFormat = Wav2Ogg.getInStreamFormat(inFilename);
            boolean eos = false;
            vi = new vorbis_info();
            encoder = new vorbisenc();
            int frameRate = Float.valueOf(sourceFormat.getFrameRate()).intValue();
            if (!encoder.vorbis_encode_init_vbr(vi, sourceFormat.getChannels(), frameRate, 0.3f)) {
                LoggerDialog.logger(null, "Failed to Initialize vorbisenc");
                return;
            }
            vc = new vorbis_comment();
            vc.vorbis_comment_add_tag("ENCODER", "Java Vorbis Encoder");
            vd = new vorbis_dsp_state();
            if (!vd.vorbis_analysis_init(vi)) {
                return;
            }
            vb = new vorbis_block(vd);
            Random generator = new Random();
            os = new ogg_stream_state(generator.nextInt(256));
            ogg_packet header = new ogg_packet();
            ogg_packet header_comm = new ogg_packet();
            ogg_packet header_code = new ogg_packet();
            vd.vorbis_analysis_headerout(vc, header, header_comm, header_code);
            os.ogg_stream_packetin(header);
            os.ogg_stream_packetin(header_comm);
            os.ogg_stream_packetin(header_code);
            og = new ogg_page();
            op = new ogg_packet();
            FileInputStream fin = null;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(outFilename);
                    while (!eos) {
                        if (!os.ogg_stream_flush(og)) break;
                        fos.write(Wav2Ogg.og.header, 0, Wav2Ogg.og.header_len);
                        fos.write(Wav2Ogg.og.body, 0, Wav2Ogg.og.body_len);
                    }
                    fin = new FileInputStream(inFilename);
                    while (!eos) {
                        int bytes = fin.read(readbuffer, 0, READ * 4);
                        int break_count = 0;
                        if (bytes == 0) {
                            vd.vorbis_analysis_wrote(0);
                        } else {
                            float[][] buffer = vd.vorbis_analysis_buffer(READ);
                            int i = 0;
                            while (i < bytes / 4) {
                                buffer[0][Wav2Ogg.vd.pcm_current + i] = (float)(readbuffer[i * 4 + 1] << 8 | 0xFF & readbuffer[i * 4]) / 32768.0f;
                                buffer[1][Wav2Ogg.vd.pcm_current + i] = (float)(readbuffer[i * 4 + 3] << 8 | 0xFF & readbuffer[i * 4 + 2]) / 32768.0f;
                                ++i;
                            }
                            vd.vorbis_analysis_wrote(i);
                        }
                        while (vb.vorbis_analysis_blockout(vd)) {
                            vb.vorbis_analysis(null);
                            vb.vorbis_bitrate_addblock();
                            block21: while (vd.vorbis_bitrate_flushpacket(op)) {
                                os.ogg_stream_packetin(op);
                                while (!eos) {
                                    if (!os.ogg_stream_pageout(og)) {
                                        ++break_count;
                                        continue block21;
                                    }
                                    fos.write(Wav2Ogg.og.header, 0, Wav2Ogg.og.header_len);
                                    fos.write(Wav2Ogg.og.body, 0, Wav2Ogg.og.body_len);
                                    if (og.ogg_page_eos() <= 0) continue;
                                    eos = true;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LoggerDialog.logger(e, null);
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Exception e2) {
                            LoggerDialog.logger(e2, null);
                        }
                    }
                    if (fos == null) break block31;
                    try {
                        fos.close();
                    }
                    catch (Exception e3) {
                        LoggerDialog.logger(e3, null);
                    }
                }
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception e) {
                        LoggerDialog.logger(e, null);
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        LoggerDialog.logger(e, null);
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        String path = "C:/Users/sunjob/Desktop/pptcw_1.0/works/";
        Wav2Ogg.writeFile(String.valueOf(path) + "audio.wav", String.valueOf(path) + "audio.ogg");
    }
}

