/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import com.neuedu.educloud.tools.core.LoggerDialog;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.sampled.AudioFileTypes;
import org.tritonus.share.sampled.Encodings;

public class Wav2Mp3 {
    private static final AudioFormat.Encoding MPEG1L3 = Encodings.getEncoding((String)"MPEG1L3");
    private static final AudioFileFormat.Type MP3 = AudioFileTypes.getType((String)"MP3", (String)"mp3");

    private static AudioInputStream getInStream(String filename) throws IOException {
        File file = new File(filename);
        AudioInputStream ais = null;
        try {
            ais = AudioSystem.getAudioInputStream(file);
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
        if (ais == null) {
            throw new IOException("Cannot open \"" + filename + "\"");
        }
        return ais;
    }

    public static String stripExtension(String filename) {
        int ind = filename.lastIndexOf(".");
        if (ind == -1 || ind == filename.length() || filename.lastIndexOf(File.separator) > ind) {
            return filename;
        }
        return filename.substring(0, ind);
    }

    public static AudioInputStream getConvertedStream2(AudioInputStream sourceStream, AudioFormat.Encoding targetEncoding) throws Exception {
        AudioFormat intermediateFormat;
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), -1, sourceFormat.getChannels(), -1, -1.0f, false);
        AudioInputStream targetStream = null;
        if (!AudioSystem.isConversionSupported(targetFormat, sourceFormat) && AudioSystem.isConversionSupported(intermediateFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), 2 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), false), sourceFormat)) {
            sourceStream = AudioSystem.getAudioInputStream(intermediateFormat, sourceStream);
        }
        if ((targetStream = AudioSystem.getAudioInputStream(targetFormat, sourceStream)) == null) {
            throw new Exception("conversion not supported");
        }
        return targetStream;
    }

    public static AudioInputStream getConvertedStream(AudioInputStream sourceStream, AudioFormat.Encoding targetEncoding) throws Exception {
        AudioFormat intermediateFormat;
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioInputStream targetStream = null;
        if (!AudioSystem.isConversionSupported(targetEncoding, sourceFormat) && AudioSystem.isConversionSupported(intermediateFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), 2 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), false), sourceFormat)) {
            sourceStream = AudioSystem.getAudioInputStream(intermediateFormat, sourceStream);
        }
        if ((targetStream = AudioSystem.getAudioInputStream(targetEncoding, sourceStream)) == null) {
            throw new Exception("conversion not supported");
        }
        return targetStream;
    }

    public static int writeFile(String inFilename, String outFilename) {
        int writtenBytes;
        block20: {
            writtenBytes = -1;
            AudioInputStream wav_ais = null;
            AudioInputStream mp3_ais = null;
            try {
                try {
                    AudioFileFormat.Type targetType = MP3;
                    wav_ais = Wav2Mp3.getInStream(inFilename);
                    mp3_ais = Wav2Mp3.getConvertedStream(wav_ais, MPEG1L3);
                    writtenBytes = AudioSystem.write(mp3_ais, targetType, new File(outFilename));
                }
                catch (Exception e) {
                    LoggerDialog.logger(e, null);
                    if (wav_ais != null) {
                        try {
                            wav_ais.close();
                        }
                        catch (IOException e2) {
                            LoggerDialog.logger(e2, null);
                        }
                    }
                    if (mp3_ais == null) break block20;
                    try {
                        mp3_ais.close();
                    }
                    catch (IOException e3) {
                        LoggerDialog.logger(e3, null);
                    }
                }
            }
            finally {
                if (wav_ais != null) {
                    try {
                        wav_ais.close();
                    }
                    catch (IOException e) {
                        LoggerDialog.logger(e, null);
                    }
                }
                if (mp3_ais != null) {
                    try {
                        mp3_ais.close();
                    }
                    catch (IOException e) {
                        LoggerDialog.logger(e, null);
                    }
                }
            }
        }
        return writtenBytes;
    }
}

