/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import com.neuedu.educloud.tools.core.LoggerDialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ScreenCapturer {
    private String outputRoot = null;
    private long startTime = 0L;

    public ScreenCapturer(String root) {
        this.outputRoot = root;
    }

    public void reset() {
        this.startTime = 0L;
    }

    public long doScreen(long currentTime, long fixTime) {
        if (this.startTime == 0L) {
            this.startTime = currentTime;
        }
        try {
            Robot robot = new Robot();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            BufferedImage image = robot.createScreenCapture(new Rectangle(0, 0, d.width, d.height));
            this.save2File(image, currentTime, this.startTime, fixTime);
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
        return currentTime;
    }

    private void save2File(BufferedImage image, long currentTime, long startTime, long fixTime) throws Exception {
        long position = currentTime - startTime - fixTime;
        File file = new File(String.valueOf(this.outputRoot) + "/" + position + ".jpg");
        ImageIO.write((RenderedImage)image, "jpg", file);
    }
}

