/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private Image image;
    private Image scaledImage;
    private int imageWidth = 0;
    private int imageHeight = 0;

    public void loadImage(String file) throws IOException {
        this.image = ImageIO.read(new File(file));
        this.imageWidth = this.image.getWidth(this);
        this.imageHeight = this.image.getHeight(this);
        this.setScaledImage();
    }

    public void scaleImage() {
        this.setScaledImage();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            int x = (this.getWidth() - this.scaledImage.getWidth(this)) / 2;
            int y = (this.getHeight() - this.scaledImage.getHeight(this)) / 2;
            g.drawImage(this.scaledImage, x, y, this);
        }
    }

    private void setScaledImage() {
        if (this.image != null) {
            float iw = this.imageWidth;
            float ih = this.imageHeight;
            float pw = this.getWidth();
            float ph = this.getHeight();
            if (pw < iw || ph < ih) {
                if (pw / ph > iw / ih) {
                    iw = -1.0f;
                    ih = ph;
                } else {
                    iw = pw;
                    ih = -1.0f;
                }
                if (iw == 0.0f) {
                    iw = -1.0f;
                }
                if (ih == 0.0f) {
                    ih = -1.0f;
                }
                this.scaledImage = this.image.getScaledInstance(new Float(iw).intValue(), new Float(ih).intValue(), 2);
            } else {
                this.scaledImage = this.image;
            }
        }
    }
}

