/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import com.neuedu.educloud.tools.ResourceMaker;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.course.AudioRecorder;
import com.neuedu.educloud.tools.course.ScreenCapturer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public class CourseRecorder {
    public static int INIT = 0;
    public static int RUNNING = 3;
    public static int PAUSE = 5;
    public static int STOP = 7;
    private JFrame frame;
    private Point location;
    private boolean isDragged;
    private JLabel startLabel = new JLabel();
    private JLabel stopLabel = new JLabel();
    private JLabel timesLabel = new JLabel();
    private ResourceMaker parent = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private Timer timer = null;
    private ImageIcon pause_icon = new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/rec_pause.png"));
    private ImageIcon start_icon = new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/rec_start.png"));
    private String outputRoot = "WORKS/temp";
    private int status = INIT;
    private int audioNum = 1;
    private AudioRecorder audioRecorder = null;
    private ScreenCapturer screenRecorder = null;
    private long startTime = 0L;
    private long lastTime = 0L;
    private long pause_start_time = 0L;
    private long fixedTime = 0L;

    public CourseRecorder(ResourceMaker frame) {
        this.parent = frame;
        this.initComponents();
        this.timer = new Timer(53, new ClockListener());
        File file = new File(this.outputRoot);
        file.mkdirs();
        this.screenRecorder = new ScreenCapturer(this.outputRoot);
        this.audioRecorder = new AudioRecorder(this.outputRoot);
    }

    private void initComponents() {
        this.parent.setVisible(false);
        this.frame = new JFrame("\u777f\u9053\u4e91\u8bfe\u7a0b\u5f55\u5236\u5de5\u5177");
        this.frame.setUndecorated(true);
        this.frame.setSize(95, 32);
        this.frame.setResizable(false);
        this.frame.setAlwaysOnTop(true);
        int screen_width = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.frame.setLocation(screen_width - 200, 1);
        Container root = this.frame.getContentPane();
        root.setLayout(null);
        root.setBackground(Color.white);
        JLabel logoLabel = new JLabel();
        ImageIcon logo_icon = new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/logo.png"));
        logoLabel.setIcon(logo_icon);
        logoLabel.setBounds(new Rectangle(0, 0, 32, 32));
        root.add(logoLabel);
        this.startLabel.setIcon(this.start_icon);
        this.startLabel.setToolTipText("\u5f00\u59cb");
        this.startLabel.setBounds(new Rectangle(37, 16, 16, 16));
        root.add(this.startLabel);
        ImageIcon stop_icon = new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/rec_stop.png"));
        this.stopLabel.setToolTipText("\u505c\u6b62");
        this.stopLabel.setIcon(stop_icon);
        this.stopLabel.setBounds(new Rectangle(74, 16, 16, 16));
        root.add(this.stopLabel);
        this.timesLabel.setBounds(new Rectangle(40, 0, 63, 16));
        this.timesLabel.setText("00:00:00");
        root.add(this.timesLabel);
        logoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CourseRecorder.this.isDragged = false;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CourseRecorder.this.location = new Point(e.getX(), e.getY());
                CourseRecorder.this.isDragged = true;
            }
        });
        logoLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CourseRecorder.this.isDragged) {
                    Point new_point = new Point(((CourseRecorder)CourseRecorder.this).frame.getLocation().x + e.getX() - ((CourseRecorder)CourseRecorder.this).location.x, ((CourseRecorder)CourseRecorder.this).frame.getLocation().y + e.getY() - ((CourseRecorder)CourseRecorder.this).location.y);
                    CourseRecorder.this.frame.setLocation(new_point);
                }
            }
        });
        this.stopLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CourseRecorder.this.stopAudioRecord();
            }
        });
        this.startLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CourseRecorder.this.startOrPauseAudioRecord();
            }
        });
        this.frame.setVisible(false);
    }

    private void reset() {
        this.audioNum = 1;
        this.startTime = 0L;
        this.lastTime = 0L;
        this.fixedTime = 0L;
        this.pause_start_time = 0L;
        this.status = INIT;
        this.timesLabel.setText("00:00:00");
        this.startLabel.setIcon(this.start_icon);
        this.startLabel.setToolTipText("\u5f00\u59cb");
        this.screenRecorder.reset();
        this.audioRecorder = new AudioRecorder(this.outputRoot);
    }

    public void startOrPauseAudioRecord() {
        if (this.status == RUNNING) {
            this.pause_start_time = System.currentTimeMillis();
            this.timer.stop();
            this.audioRecorder.stopRecording();
            this.audioRecorder = null;
            this.audioRecorder = new AudioRecorder(this.outputRoot);
            ++this.audioNum;
            this.startLabel.setIcon(this.start_icon);
            this.startLabel.setToolTipText("\u5f00\u59cb");
            this.status = PAUSE;
        } else {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
                this.lastTime = this.screenRecorder.doScreen(System.currentTimeMillis(), this.fixedTime);
            }
            if (this.pause_start_time != 0L) {
                this.fixedTime += System.currentTimeMillis() - this.pause_start_time;
                this.pause_start_time = 0L;
            }
            this.timer.start();
            this.audioRecorder.startRecording(this.audioNum);
            this.startLabel.setIcon(this.pause_icon);
            this.startLabel.setToolTipText("\u6682\u505c");
            this.status = RUNNING;
        }
    }

    public void stopAudioRecord() {
        this.parent.setExtendedState(0);
        this.parent.setVisible(true);
        this.frame.setVisible(false);
        if (this.status != INIT) {
            this.timer.stop();
            this.audioRecorder.stopRecording();
            this.status = STOP;
            long alltimes = System.currentTimeMillis() - this.startTime - this.fixedTime;
            Resource res = new Resource(UUID.randomUUID().toString());
            res.setAlltime(alltimes);
            res.setType(Resource.COURSE_TYPE);
            res.setStatus(Resource.SAVED);
            this.parent.generateResource(res);
            this.reset();
        }
    }

    public void captureScreenKeyDown() {
        if (this.status == RUNNING && this.lastTime > 0L) {
            this.lastTime = this.screenRecorder.doScreen(this.lastTime, this.fixedTime);
        }
    }

    public void captureScreenKeyDown(int point_x, int point_y) {
        Rectangle rectangle = this.frame.getBounds();
        if (point_x >= rectangle.x && point_x <= rectangle.x + rectangle.width & point_y >= rectangle.y && point_y <= rectangle.y + rectangle.height) {
            return;
        }
        this.captureScreenKeyDown();
    }

    public void captureScreenKeyUp() {
        if (this.status == RUNNING) {
            this.lastTime = this.screenRecorder.doScreen(this.lastTime == 0L ? this.startTime : System.currentTimeMillis(), this.fixedTime);
        }
    }

    public void captureScreenKeyUp(int point_x, int point_y) {
        Rectangle rectangle = this.frame.getBounds();
        if (point_x >= rectangle.x && point_x <= rectangle.x + rectangle.width & point_y >= rectangle.y && point_y <= rectangle.y + rectangle.height) {
            return;
        }
        this.captureScreenKeyUp();
    }

    public void show() {
        this.startTime = 0L;
        this.lastTime = 0L;
        this.fixedTime = 0L;
        this.pause_start_time = 0L;
        this.frame.setExtendedState(0);
        this.frame.setVisible(true);
        this.parent.setVisible(false);
    }

    private void updateClock() {
        long tt = System.currentTimeMillis() - this.startTime - this.fixedTime;
        Date elapsed = new Date(tt + 57600000L);
        this.timesLabel.setText(this.dateFormat.format(elapsed));
        this.timesLabel.repaint();
    }

    private class ClockListener
    implements ActionListener {
        private ClockListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CourseRecorder.this.updateClock();
        }
    }
}

